/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

public class FieldWeightDialog
extends JDialog {
    JabRefFrame frame;
    HashMap<JSlider, SliderInfo> sliders = new HashMap();
    JButton ok = new JButton(Globals.lang("OK"));
    JButton cancel = new JButton(Globals.lang("Cancel"));

    public static void main(String[] args) {
        new FieldWeightDialog(null).setVisible(true);
    }

    public FieldWeightDialog(JabRefFrame frame) {
        this.frame = frame;
        JPanel main = this.buildMainPanel();
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)main, "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.pack();
    }

    public JPanel buildMainPanel() {
        FormLayout layout = new FormLayout("right:pref, 4dlu, fill:pref, 8dlu, right:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Globals.lang("Field sizes"));
        TreeSet<String> fields = new TreeSet<String>();
        this.sliders.clear();
        int len = BibtexFields.numberOfPublicFields();
        for (int i = 0; i < len; ++i) {
            fields.add(BibtexFields.getFieldName(i));
        }
        fields.remove("bibtexkey");
        for (String field : fields) {
            builder.append(field);
            int weight = (int)(100.0 * BibtexFields.getFieldWeight(field) / 2.0);
            JSlider slider = new JSlider(0, 100, weight);
            this.sliders.put(slider, new SliderInfo(field, weight));
            builder.append(slider);
        }
        builder.appendSeparator();
        return builder.getPanel();
    }

    public JPanel buildButtonPanel() {
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FieldWeightDialog.this.storeSettings();
                FieldWeightDialog.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FieldWeightDialog.this.dispose();
            }
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addButton((JComponent)this.ok);
        builder.addButton((JComponent)this.cancel);
        builder.addGlue();
        return builder.getPanel();
    }

    public void storeSettings() {
        for (JSlider slider : this.sliders.keySet()) {
            SliderInfo sInfo = this.sliders.get(slider);
            if (sInfo.originalValue == slider.getValue()) continue;
            double weight = 2.0 * (double)slider.getValue() / 100.0;
            BibtexFields.setFieldWeight(sInfo.fieldName, weight);
        }
        this.frame.removeCachedEntryEditors();
    }

    static class SliderInfo {
        String fieldName;
        int originalValue;

        public SliderInfo(String fieldName, int originalValue) {
            this.fieldName = fieldName;
            this.originalValue = originalValue;
        }
    }
}

