/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.ListLayout;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JEventListPanel<E>
extends JPanel {
    private TransformedList<E, E> swingSource;
    private List<JComponent[]> components = new ArrayList<JComponent[]>();
    private final ListLayout listLayout;
    private final Format<E> format;
    private final SourceChangeHandler sourceChangeHandler = new SourceChangeHandler();

    public JEventListPanel(EventList<E> source, Format<E> format) {
        this.swingSource = GlazedListsSwing.swingThreadProxyList(source);
        this.listLayout = new ListLayout(this, format);
        this.format = format;
        this.setLayout(this.listLayout);
        for (int i = 0; i < this.swingSource.size(); ++i) {
            this.sourceChangeHandler.insert(i);
        }
        this.swingSource.addListEventListener(this.sourceChangeHandler);
    }

    public void setElementColumns(int elementColumns) {
        if (elementColumns < 1) {
            throw new IllegalArgumentException("elementColumns must be in the range [1, 2147483647]");
        }
        this.listLayout.setElementColumns(elementColumns);
    }

    public void setElementRows(int elementRows) {
        if (elementRows < 1) {
            throw new IllegalArgumentException("elementRows must be in the range [1, 2147483647]");
        }
        this.listLayout.setElementRows(elementRows);
    }

    public void dispose() {
        this.swingSource.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractFormat<E>
    implements Format<E> {
        private RowSpec[] elementRows;
        private ColumnSpec[] elementColumns;
        private RowSpec gapRow;
        private ColumnSpec gapColumn;
        private CellConstraints[] cellConstraints;

        protected AbstractFormat(RowSpec[] rowSpecs, ColumnSpec[] columnSpecs, RowSpec gapRow, ColumnSpec gapColumn, CellConstraints[] cellConstraints) {
            this.elementRows = rowSpecs;
            this.elementColumns = columnSpecs;
            this.gapRow = gapRow;
            this.gapColumn = gapColumn;
            this.cellConstraints = cellConstraints;
        }

        protected AbstractFormat(String rowSpecs, String columnSpecs, String gapRow, String gapColumn, CellConstraints[] cellConstraints) {
            this(RowSpec.decodeSpecs(rowSpecs), ColumnSpec.decodeSpecs(columnSpecs), new RowSpec(gapRow), new ColumnSpec(gapColumn), cellConstraints);
        }

        protected AbstractFormat(String rowSpecs, String columnSpecs, String gapRow, String gapColumn, String[] cellConstraints) {
            this(RowSpec.decodeSpecs(rowSpecs), ColumnSpec.decodeSpecs(columnSpecs), gapRow == null ? null : new RowSpec(gapRow), gapColumn == null ? null : new ColumnSpec(gapColumn), AbstractFormat.decode(cellConstraints));
        }

        protected AbstractFormat() {
        }

        @Override
        public RowSpec[] getElementRows() {
            return this.elementRows;
        }

        public void setElementRows(RowSpec[] elementRows) {
            this.elementRows = elementRows;
        }

        @Override
        public ColumnSpec[] getElementColumns() {
            return this.elementColumns;
        }

        public void setElementColumns(ColumnSpec[] elementColumns) {
            this.elementColumns = elementColumns;
        }

        public void setElementCells(String rowSpecs, String columnSpecs) {
            this.setElementRows(RowSpec.decodeSpecs(rowSpecs));
            this.setElementColumns(ColumnSpec.decodeSpecs(columnSpecs));
        }

        @Override
        public int getComponentsPerElement() {
            return this.cellConstraints.length;
        }

        @Override
        public CellConstraints getConstraints(int component) {
            return this.cellConstraints[component];
        }

        public void setCellConstraints(CellConstraints[] cellConstraints) {
            this.cellConstraints = cellConstraints;
        }

        public void setCellConstraints(String[] cellConstraints) {
            this.setCellConstraints(AbstractFormat.decode(cellConstraints));
        }

        @Override
        public RowSpec getGapRow() {
            return this.gapRow;
        }

        @Override
        public ColumnSpec getGapColumn() {
            return this.gapColumn;
        }

        public void setGapRow(RowSpec gapRow) {
            this.gapRow = gapRow;
        }

        public void setGapColumn(ColumnSpec gapColumn) {
            this.gapColumn = gapColumn;
        }

        public void setGaps(String gapRow, String gapColumn) {
            this.setGapRow(gapRow != null ? new RowSpec(gapRow) : null);
            this.setGapColumn(gapColumn != null ? new ColumnSpec(gapColumn) : null);
        }

        private static CellConstraints[] decode(String[] cellConstraints) {
            CellConstraints[] decoded = new CellConstraints[cellConstraints.length];
            for (int c = 0; c < cellConstraints.length; ++c) {
                decoded[c] = new CellConstraints(cellConstraints[c]);
            }
            return decoded;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Format<E> {
        public int getComponentsPerElement();

        public JComponent getComponent(E var1, int var2);

        public CellConstraints getConstraints(int var1);

        public RowSpec[] getElementRows();

        public ColumnSpec[] getElementColumns();

        public RowSpec getGapRow();

        public ColumnSpec getGapColumn();
    }

    private class SourceChangeHandler
    implements ListEventListener {
        private SourceChangeHandler() {
        }

        private void insert(int index) {
            int c;
            Object element = JEventListPanel.this.swingSource.get(index);
            JComponent[] elementComponents = new JComponent[JEventListPanel.this.format.getComponentsPerElement()];
            for (c = 0; c < elementComponents.length; ++c) {
                elementComponents[c] = JEventListPanel.this.format.getComponent(element, c);
            }
            JEventListPanel.this.components.add(index, elementComponents);
            JEventListPanel.this.listLayout.insertIndex(index);
            for (c = 0; c < elementComponents.length; ++c) {
                if (elementComponents[c] == null) continue;
                JEventListPanel.this.add((Component)elementComponents[c], new ListLayout.Constraints(c, index));
            }
        }

        private void delete(int index) {
            JComponent[] elementComponents = (JComponent[])JEventListPanel.this.components.get(index);
            for (int c = 0; c < elementComponents.length; ++c) {
                if (elementComponents[c] == null) continue;
                JEventListPanel.this.remove(elementComponents[c]);
            }
            JEventListPanel.this.components.remove(index);
            JEventListPanel.this.listLayout.removeIndex(index);
        }

        private void update(int index) {
            int c;
            JComponent[] oldElementComponents = (JComponent[])JEventListPanel.this.components.get(index);
            Object element = JEventListPanel.this.swingSource.get(index);
            JComponent[] newElementComponents = new JComponent[JEventListPanel.this.format.getComponentsPerElement()];
            for (c = 0; c < newElementComponents.length; ++c) {
                newElementComponents[c] = JEventListPanel.this.format.getComponent(element, c);
            }
            for (c = 0; c < oldElementComponents.length; ++c) {
                if (oldElementComponents[c] == newElementComponents[c]) continue;
                if (oldElementComponents[c] != null) {
                    JEventListPanel.this.remove(oldElementComponents[c]);
                }
                if (newElementComponents[c] == null) continue;
                JEventListPanel.this.add((Component)newElementComponents[c], new ListLayout.Constraints(c, index));
            }
            JEventListPanel.this.components.set(index, newElementComponents);
            JEventListPanel.this.listLayout.updateIndex(index);
        }

        public void listChanged(ListEvent listChanges) {
            while (listChanges.next()) {
                int type = listChanges.getType();
                int index = listChanges.getIndex();
                if (type == 2) {
                    this.insert(index);
                    continue;
                }
                if (type == 0) {
                    this.delete(index);
                    continue;
                }
                if (type != 1) continue;
                this.update(index);
            }
            JEventListPanel.this.revalidate();
            JEventListPanel.this.repaint();
        }
    }
}

