/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.alaw;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaEncoder
extends AudioCodec {
    private Format lastFormat = null;
    private int inputSampleSize;
    private boolean bigEndian = false;
    public static final int MAX = Short.MAX_VALUE;
    private static byte[] pcmToALawMap = new byte[65536];
    public static final int MAX_USHORT = 65535;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("alaw", 8000.0, 8, 1, -1, -1)};
        this.PLUGIN_NAME = "pcm to alaw converter";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat inFormat = (AudioFormat)in;
        int sampleRate = (int)inFormat.getSampleRate();
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("alaw", (double)sampleRate, 8, 1, -1, -1)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void close() {
    }

    private int calculateOutputSize(int inputLength) {
        if (this.inputSampleSize == 16) {
            inputLength /= 2;
        }
        return inputLength;
    }

    private void initConverter(AudioFormat inFormat) {
        this.lastFormat = inFormat;
        this.inputSampleSize = inFormat.getSampleSizeInBits();
        this.bigEndian = inFormat.getEndian() == 1;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        Format newFormat = inputBuffer.getFormat();
        if (this.lastFormat != newFormat) {
            this.initConverter((AudioFormat)newFormat);
        }
        if (inputBuffer.getLength() == 0) {
            return 4;
        }
        int outLength = this.calculateOutputSize(inputBuffer.getLength());
        byte[] inpData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, outLength);
        JavaEncoder.aLawEncode(this.bigEndian, inpData, inputBuffer.getOffset(), inputBuffer.getLength(), outData);
        this.updateOutput(outputBuffer, (Format)this.outputFormat, outLength, 0);
        return 0;
    }

    public static int uShortToInt(short value) {
        if (value >= 0) {
            return value;
        }
        return 65536 + value;
    }

    public static void aLawEncode(boolean bigEndian, byte[] data, int offset, int length, byte[] target) {
        if (bigEndian) {
            JavaEncoder.aLawEncodeBigEndian(data, offset, length, target);
        } else {
            JavaEncoder.aLawEncodeLittleEndian(data, offset, length, target);
        }
    }

    public static void aLawEncodeLittleEndian(byte[] data, int offset, int length, byte[] target) {
        int size = length / 2;
        for (int i = 0; i < size; ++i) {
            target[i] = JavaEncoder.aLawEncode((data[offset + 2 * i + 1] & 0xFF) << 8 | data[offset + 2 * i] & 0xFF);
        }
    }

    public static void aLawEncodeBigEndian(byte[] data, int offset, int length, byte[] target) {
        int size = length / 2;
        for (int i = 0; i < size; ++i) {
            target[i] = JavaEncoder.aLawEncode(data[offset + 2 * i + 1] & 0xFF | (data[offset + 2 * i] & 0xFF) << 8);
        }
    }

    public static byte aLawEncode(int pcm) {
        return pcmToALawMap[JavaEncoder.uShortToInt((short)(pcm & 0xFFFF))];
    }

    private static byte encode(int pcm) {
        int sign = (pcm & 0x8000) >> 8;
        if (sign != 0) {
            pcm = -pcm;
        }
        if (pcm > Short.MAX_VALUE) {
            pcm = Short.MAX_VALUE;
        }
        int exponent = 7;
        int expMask = 16384;
        while ((pcm & expMask) == 0 && exponent > 0) {
            --exponent;
            expMask >>= 1;
        }
        int mantissa = pcm >> (exponent == 0 ? 4 : exponent + 3) & 0xF;
        byte alaw = (byte)(sign | exponent << 4 | mantissa);
        return (byte)(alaw ^ 0xD5);
    }

    static {
        for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
            JavaEncoder.pcmToALawMap[JavaEncoder.uShortToInt((short)((short)i))] = JavaEncoder.encode(i);
        }
    }
}

