/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import java.net.URL;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.impl.FileUtils;
import org.mozilla.browser.test.MozillaTest;

public class LoadHTMLTest
extends MozillaTest {
    public void testLoadHTML() throws Exception {
        int i;
        String u1 = LoadHTMLTest.resolveURL("bigpage1.html");
        String page1 = new String(FileUtils.readStream(new URL(u1).openStream()), "UTF-8");
        String u2 = LoadHTMLTest.resolveURL("bigpage2.html");
        String page2 = new String(FileUtils.readStream(new URL(u2).openStream()), "UTF-8");
        int N = 0;
        for (i = 0; i < N; ++i) {
            LoadHTMLTest.assertFalse((boolean)MozillaAutomation.blockingLoadHTML(this.moz, page1, null));
            MozillaAutomation.sleep(100);
            LoadHTMLTest.assertFalse((boolean)MozillaAutomation.blockingLoadHTML(this.moz, page2, null));
            MozillaAutomation.sleep(100);
        }
        for (i = 0; i < N; ++i) {
            LoadHTMLTest.assertFalse((boolean)MozillaAutomation.blockingLoadHTML(this.moz, page1, u1));
            MozillaAutomation.sleep(100);
            LoadHTMLTest.assertFalse((boolean)MozillaAutomation.blockingLoadHTML(this.moz, page2, u2));
            MozillaAutomation.sleep(100);
        }
    }

    public void testAsyncLoadHTML() throws Exception {
        String u1 = LoadHTMLTest.resolveURL("bigpage1.html");
        String page1 = new String(FileUtils.readStream(new URL(u1).openStream()), "UTF-8");
        String u2 = LoadHTMLTest.resolveURL("bigpage2.html");
        String page2 = new String(FileUtils.readStream(new URL(u2).openStream()), "UTF-8");
        int N = 50;
        for (int i = 0; i < N; ++i) {
            this.moz.loadHTML(page1, u1);
            this.moz.loadHTML(page2, u2);
        }
    }
}

