/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchManager;
import org.limewire.core.api.spam.SpamManager;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.search.model.AlreadyDownloadedListEventListener;
import org.limewire.ui.swing.search.model.BasicSearchResultsModel;
import org.limewire.ui.swing.search.model.GroupingListEventListener;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.SimilarResultsDetector;
import org.limewire.ui.swing.search.model.SimilarResultsDetectorFactory;
import org.limewire.ui.swing.search.model.SpamListEventListener;
import org.limewire.ui.swing.search.model.VisualSearchResultFactory;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.DownloadExceptionHandler;
import org.limewire.ui.swing.util.PropertiableHeadings;

public class SearchResultsModelFactory {
    private final SearchManager searchManager;
    private final SpamManager spamManager;
    private final SimilarResultsDetectorFactory similarResultsDetectorFactory;
    private final LibraryManager libraryManager;
    private final DownloadListManager downloadListManager;
    private final Provider<DownloadExceptionHandler> downloadExceptionHandler;
    private final VisualSearchResultFactory vsrFactory;

    @Inject
    public SearchResultsModelFactory(SearchManager searchManager, SimilarResultsDetectorFactory similarResultsDetectorFactory, SpamManager spamManager, LibraryManager libraryManager, DownloadListManager downloadListManager, Provider<PropertiableHeadings> propertiableHeadings, Provider<DownloadExceptionHandler> downloadExceptionHandler, VisualSearchResultFactory vsrFactory) {
        this.searchManager = searchManager;
        this.similarResultsDetectorFactory = similarResultsDetectorFactory;
        this.spamManager = spamManager;
        this.libraryManager = libraryManager;
        this.downloadListManager = downloadListManager;
        this.downloadExceptionHandler = downloadExceptionHandler;
        this.vsrFactory = vsrFactory;
    }

    public SearchResultsModel createSearchResultsModel(SearchInfo searchInfo, Search search) {
        BasicSearchResultsModel searchResultsModel = new BasicSearchResultsModel(searchInfo, search, this.vsrFactory, this.downloadListManager, this.downloadExceptionHandler, this.searchManager);
        SimilarResultsDetector similarResultsDetector = this.similarResultsDetectorFactory.newSimilarResultsDetector();
        AlreadyDownloadedListEventListener alreadyDownloadedListEventListener = new AlreadyDownloadedListEventListener(this.libraryManager, this.downloadListManager);
        searchResultsModel.addResultListener(alreadyDownloadedListEventListener);
        if (SwingUiSettings.GROUP_SIMILAR_RESULTS_ENABLED.getValue()) {
            GroupingListEventListener groupingListEventListener = new GroupingListEventListener(similarResultsDetector);
            searchResultsModel.addResultListener(groupingListEventListener);
        }
        SpamListEventListener spamListEventListener = new SpamListEventListener(this.spamManager, similarResultsDetector);
        searchResultsModel.addResultListener(spamListEventListener);
        return searchResultsModel;
    }
}

