/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.spam.SpamManager;
import org.limewire.core.settings.FilterSettings;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.options.AbstractFilterOptionPanel;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

public class FilterKeywordOptionPanel
extends AbstractFilterOptionPanel {
    private JButton okButton;
    private JTextField keywordTextField;
    private JButton addKeywordButton;
    private AbstractFilterOptionPanel.FilterTable filterTable;
    private SpamManager spamManager;

    @Inject
    public FilterKeywordOptionPanel(SpamManager spamManager) {
        this.spamManager = spamManager;
        this.setLayout(new MigLayout("gapy 10"));
        this.keywordTextField = new JTextField(30);
        this.addKeywordButton = new JButton(I18n.tr("Add Keyword"));
        this.filterTable = new AbstractFilterOptionPanel.FilterTable(new DefaultEventTableModel<String>(this.eventList, new AbstractFilterOptionPanel.FilterTableFormat(I18n.tr("Keyword"))));
        this.okButton = new JButton(new OKDialogAction());
        TextFieldClipboardControl.install(this.keywordTextField);
        this.addKeywordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = FilterKeywordOptionPanel.this.keywordTextField.getText();
                if (text == null || text.trim().length() == 0) {
                    return;
                }
                if (!FilterKeywordOptionPanel.this.eventList.contains(text)) {
                    FilterKeywordOptionPanel.this.eventList.add(text);
                }
                FilterKeywordOptionPanel.this.keywordTextField.setText("");
            }
        });
        this.add((Component)new MultiLineLabel(I18n.tr("LimeWire will not show files with the following keywords in your search results"), 300), "span, wrap");
        this.add((Component)this.keywordTextField, "gapright 10");
        this.add((Component)this.addKeywordButton, "wrap");
        this.add((Component)new JScrollPane(this.filterTable), "span 2, grow, wrap");
        this.add((Component)this.okButton, "tag ok, skip 1, alignx right");
    }

    @Override
    boolean applyOptions() {
        String[] values = this.eventList.toArray(new String[this.eventList.size()]);
        FilterSettings.BANNED_WORDS.set(values);
        BackgroundExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                FilterKeywordOptionPanel.this.spamManager.adjustSpamFilters();
            }
        });
        return false;
    }

    @Override
    boolean hasChanged() {
        List<String> model = Arrays.asList(FilterSettings.BANNED_WORDS.get());
        String[] values = this.eventList.toArray(new String[this.eventList.size()]);
        return ((Object)model).equals(new ArrayList<String>(Arrays.asList(values)));
    }

    @Override
    public void initOptions() {
        this.eventList.clear();
        String[] bannedWords = FilterSettings.BANNED_WORDS.get();
        this.eventList.addAll(new ArrayList<String>(Arrays.asList(bannedWords)));
    }
}

