/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import org.limewire.core.api.download.DownloadState;
import org.limewire.friend.api.FileMetaData;
import org.limewire.friend.api.FriendPresence;
import org.limewire.ui.swing.friends.chat.AbstractMessageImpl;
import org.limewire.ui.swing.friends.chat.Message;
import org.limewire.ui.swing.friends.chat.MessageFileOffer;
import org.limewire.ui.swing.util.I18n;

class MessageFileOfferImpl
extends AbstractMessageImpl
implements MessageFileOffer {
    private static final String DOWNLOAD_FROM_LIBRARY = I18n.tr("Download it now, or get it from them {0}later{1}.", "<a href=\"#library\">", "</a>");
    private final FileMetaData fileMetadata;
    private DownloadState downloadState;
    private FriendPresence sourcePresence;

    public MessageFileOfferImpl(String senderName, String friendId, Message.Type type, FileMetaData fileMetadata, FriendPresence sourcePresence) {
        super(senderName, friendId, type);
        this.fileMetadata = fileMetadata;
        this.downloadState = null;
        this.sourcePresence = sourcePresence;
    }

    @Override
    public FileMetaData getFileOffer() {
        return this.fileMetadata;
    }

    @Override
    public void setDownloadState(DownloadState downloadState) {
        this.downloadState = downloadState;
    }

    @Override
    public FriendPresence getPresence() {
        return this.sourcePresence;
    }

    public String toString() {
        String state = this.downloadState == null ? "No State" : this.downloadState.toString();
        String fileOffer = this.fileMetadata.getName();
        return fileOffer + "(" + state + ")";
    }

    @Override
    public String format() {
        boolean isIncoming = this.getType() == Message.Type.RECEIVED;
        return isIncoming ? this.formatIncoming() : this.formatOutgoing();
    }

    private String formatOutgoing() {
        StringBuffer fileOfferOutgoingMsg = new StringBuffer();
        fileOfferOutgoingMsg.append(I18n.tr("Sharing file with {0}", this.getFriendID()));
        fileOfferOutgoingMsg.append(this.formatButtonText(this.getFileOffer().getName(), false));
        return fileOfferOutgoingMsg.toString();
    }

    private String formatButtonText(String buttonText, boolean buttonEnabled) {
        StringBuilder bldr = new StringBuilder();
        bldr.append("<br/>").append("<form action=\"\"><input type=\"hidden\" name=\"fileid\" value=\"").append(this.getFileOffer().getId()).append("\"/><input type=\"submit\" value=\"").append(buttonText).append(buttonEnabled ? "\"/>" : ":disabled\"/>").append("</form><br/>");
        return bldr.toString();
    }

    private String formatIncoming() {
        String fileOfferFormatted;
        String fileOfferReceived = I18n.tr("{0} wants to share a file with you", this.getFriendID());
        String defaultFileOfferFormatted = fileOfferReceived + this.formatButtonText(I18n.tr("Download {0}", this.fileMetadata.getName()), true) + DOWNLOAD_FROM_LIBRARY;
        if (this.downloadState == null) {
            fileOfferFormatted = defaultFileOfferFormatted;
        } else {
            switch (this.downloadState) {
                case REMOTE_QUEUED: 
                case LOCAL_QUEUED: 
                case TRYING_AGAIN: 
                case CONNECTING: 
                case PAUSED: 
                case FINISHING: 
                case DOWNLOADING: {
                    fileOfferFormatted = fileOfferReceived + this.formatButtonText(I18n.tr("Downloading {0}", this.fileMetadata.getName()), false) + DOWNLOAD_FROM_LIBRARY;
                    break;
                }
                case CANCELLED: {
                    fileOfferFormatted = defaultFileOfferFormatted + "<br/><br/>" + I18n.tr("Download cancelled.  Click button to retry");
                    break;
                }
                case STALLED: 
                case ERROR: {
                    fileOfferFormatted = defaultFileOfferFormatted + "<br/><br/>" + I18n.tr("Error downloading file.  Click button to retry");
                    break;
                }
                case DONE: {
                    fileOfferFormatted = fileOfferReceived + I18n.tr("{0}Downloaded{1}", "<a href=\"#mylibrary\">", "</a>");
                    break;
                }
                case SCAN_FAILED: {
                    fileOfferFormatted = fileOfferReceived + I18n.tr("{0}Downloaded but not scanned for viruses{1}", "<a href=\"#mylibrary\">", "</a>");
                    break;
                }
                case SCANNING: 
                case SCANNING_FRAGMENT: {
                    fileOfferFormatted = fileOfferReceived + I18n.tr("Scanning for viruses - Powered by AVG");
                    break;
                }
                case THREAT_FOUND: {
                    fileOfferFormatted = fileOfferReceived + "<br/><br/>" + I18n.tr("File deleted - Threat detected by AVG");
                    break;
                }
                case DANGEROUS: {
                    fileOfferFormatted = fileOfferReceived + "<br/><br/>" + I18n.tr("File deleted - Dangerous file");
                    break;
                }
                default: {
                    fileOfferFormatted = defaultFileOfferFormatted;
                }
            }
        }
        return fileOfferFormatted;
    }
}

