/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.limewire.friend.api.ChatState;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendEvent;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.MessageWriter;
import org.limewire.friend.api.feature.Feature;
import org.limewire.friend.api.feature.FeatureEvent;
import org.limewire.inject.LazySingleton;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ChatMessageEvent;
import org.limewire.ui.swing.friends.chat.ChatModel;
import org.limewire.ui.swing.friends.chat.ChatStateEvent;
import org.limewire.ui.swing.friends.chat.Conversation;
import org.limewire.ui.swing.friends.chat.ConversationPane;
import org.limewire.ui.swing.friends.chat.ConversationPaneFactory;
import org.limewire.ui.swing.friends.chat.Message;

@LazySingleton
class ConversationPanel {
    private final ConversationPaneFactory conversationFactory;
    private final JPanel component;
    private final Map<String, Conversation> chats;
    private final ChatModel chatModel;
    private ChatFriend selectedConversation = null;
    private final ListenerSupport<ChatMessageEvent> messageListenerManager;
    private final ListenerSupport<ChatStateEvent> chatStateListenerManager;
    private final ListenerSupport<FeatureEvent> featureListenerManager;
    private final ListenerSupport<FriendEvent> friendListenerManager;
    private final EventListener<ChatMessageEvent> messageEventListener;
    private final EventListener<ChatStateEvent> chatStateEventListener;
    private final EventListener<FeatureEvent> featureEventListener;
    private final EventListener<FriendEvent> friendEventListener;

    @Inject
    public ConversationPanel(ConversationPaneFactory conversationFactory, ListenerSupport<ChatMessageEvent> messageListenerManager, ListenerSupport<ChatStateEvent> chatStateListenerManager, @Named(value="available") ListenerSupport<FriendEvent> friendListenerManager, ListenerSupport<FeatureEvent> featureListenerManager, ChatModel chatModel) {
        this.conversationFactory = conversationFactory;
        this.chatModel = chatModel;
        this.component = new JPanel(new BorderLayout());
        this.chats = new HashMap<String, Conversation>();
        this.messageListenerManager = messageListenerManager;
        this.chatStateListenerManager = chatStateListenerManager;
        this.friendListenerManager = friendListenerManager;
        this.featureListenerManager = featureListenerManager;
        this.messageEventListener = new EventListener<ChatMessageEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(ChatMessageEvent event) {
                Message message = (Message)event.getData();
                String friendId = message.getFriendID();
                if (ConversationPanel.this.chats.containsKey(friendId)) {
                    ((Conversation)ConversationPanel.this.chats.get(friendId)).newChatMessage(message);
                }
            }
        };
        this.chatStateEventListener = new EventListener<ChatStateEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(ChatStateEvent event) {
                ChatState chatState = (ChatState)((Object)event.getType());
                String friendId = (String)event.getSource();
                if (ConversationPanel.this.chats.containsKey(friendId)) {
                    ((Conversation)ConversationPanel.this.chats.get(friendId)).newChatState(chatState);
                }
            }
        };
        this.featureEventListener = new EventListener<FeatureEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FeatureEvent event) {
                String friendId = ((FriendPresence)event.getSource()).getFriend().getId();
                if (ConversationPanel.this.chats.containsKey(friendId)) {
                    ((Conversation)ConversationPanel.this.chats.get(friendId)).featureUpdate((Feature)event.getData(), (FeatureEvent.Type)((Object)event.getType()));
                }
            }
        };
        this.friendEventListener = new EventListener<FriendEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendEvent event) {
                String friendId = ((Friend)event.getData()).getId();
                if (ConversationPanel.this.chats.containsKey(friendId)) {
                    ((Conversation)ConversationPanel.this.chats.get(friendId)).friendAvailableUpdate((FriendEvent.Type)((Object)event.getType()));
                }
            }
        };
    }

    public void registerListeners() {
        this.messageListenerManager.addListener(this.messageEventListener);
        this.chatStateListenerManager.addListener(this.chatStateEventListener);
        this.friendListenerManager.addListener(this.friendEventListener);
        this.featureListenerManager.addListener(this.featureEventListener);
    }

    public void unregisterListeners() {
        this.messageListenerManager.removeListener(this.messageEventListener);
        this.chatStateListenerManager.removeListener(this.chatStateEventListener);
        this.friendListenerManager.removeListener(this.friendEventListener);
        this.featureListenerManager.removeListener(this.featureEventListener);
    }

    public JComponent getComponent() {
        return this.component;
    }

    private void setConversationPanel(JComponent chatComponent) {
        this.component.removeAll();
        this.component.add((Component)chatComponent, "Center");
        this.component.repaint();
    }

    public void displayConverstaion(ChatFriend chatFriend) {
        Conversation chatPane = this.chats.get(chatFriend.getID());
        this.selectedConversation = chatFriend;
        this.selectedConversation.setHasUnviewedMessages(false);
        this.setConversationPanel(chatPane.asComponent());
    }

    public ChatFriend getCurrentConversationFriend() {
        return this.selectedConversation;
    }

    public boolean hasConversation(ChatFriend chatFriend) {
        return this.chats.containsKey(chatFriend.getID());
    }

    public void removeConversation(ChatFriend chatFriend) {
        if (chatFriend.equals(this.selectedConversation)) {
            this.selectedConversation = null;
            this.setConversationPanel(new JPanel());
        }
        if (this.hasConversation(chatFriend)) {
            chatFriend.stopChat();
            Conversation conversation = this.chats.remove(chatFriend.getID());
            conversation.dispose();
            this.chatModel.removeFriendIfNecessary(chatFriend);
            if (this.chats.isEmpty()) {
                this.unregisterListeners();
            }
        }
    }

    public void removeAllConversations() {
        this.selectedConversation = null;
        this.setConversationPanel(new JPanel());
        for (String key : this.chats.keySet()) {
            this.chats.get(key).dispose();
        }
        this.chats.clear();
        this.unregisterListeners();
    }

    public void startNewChat(ChatFriend chatFriend, MessageWriter messageWriter) {
        if (this.chats.isEmpty()) {
            this.registerListeners();
        }
        ConversationPane chatPane = this.conversationFactory.create(messageWriter, chatFriend);
        this.chats.put(chatFriend.getID(), chatPane);
        this.selectedConversation = chatFriend;
        this.selectedConversation.setHasUnviewedMessages(false);
        this.setConversationPanel(chatPane);
    }
}

