/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.friend.api.ChatState;
import org.limewire.friend.api.FileMetaData;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendEvent;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.MessageWriter;
import org.limewire.friend.api.feature.Feature;
import org.limewire.friend.api.feature.FeatureEvent;
import org.limewire.friend.api.feature.FeatureTransport;
import org.limewire.friend.api.feature.FileOfferFeature;
import org.limewire.friend.api.feature.LimewireFeature;
import org.limewire.friend.impl.feature.NoSave;
import org.limewire.friend.impl.feature.NoSaveFeature;
import org.limewire.friend.impl.feature.NoSaveStatus;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.action.CopyAction;
import org.limewire.ui.swing.action.CopyAllAction;
import org.limewire.ui.swing.action.PopupUtil;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.friends.chat.ChatDocumentBuilder;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ChatHyperlinkListenerFactory;
import org.limewire.ui.swing.friends.chat.ChatMessageEvent;
import org.limewire.ui.swing.friends.chat.CloseChatMessage;
import org.limewire.ui.swing.friends.chat.Conversation;
import org.limewire.ui.swing.friends.chat.Displayable;
import org.limewire.ui.swing.friends.chat.ErrorMessage;
import org.limewire.ui.swing.friends.chat.Message;
import org.limewire.ui.swing.friends.chat.MessageFileOffer;
import org.limewire.ui.swing.friends.chat.MessageFileOfferImpl;
import org.limewire.ui.swing.friends.chat.NoSaveStatusMessage;
import org.limewire.ui.swing.friends.chat.ResizingInputPanel;
import org.limewire.ui.swing.painter.GenericBarPainter;
import org.limewire.ui.swing.search.FriendPresenceActions;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.ui.swing.util.PainterUtils;
import org.limewire.ui.swing.util.ResizeUtils;
import org.limewire.util.FileUtils;

public class ConversationPane
extends JPanel
implements Displayable,
Conversation {
    private static final int PADDING = 5;
    private static final Log LOG = LogFactory.getLog(ConversationPane.class);
    private static final Color DEFAULT_BACKGROUND = new Color(224, 224, 224);
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private final List<Message> messages = new ArrayList<Message>();
    private final Map<String, MessageFileOffer> idToMessageWithFileOffer = new ConcurrentHashMap<String, MessageFileOffer>();
    private final JEditorPane editor;
    private final String conversationName;
    private final String friendId;
    private final MessageWriter writer;
    private final ChatFriend chatFriend;
    private final Provider<IconManager> iconManager;
    private final FriendPresenceActions remoteHostActions;
    private HyperlinkButton downloadlink;
    private HyperlinkButton nosaveLink;
    private JXPanel toolbar;
    private ResizingInputPanel inputPanel;
    private ChatState currentChatState;
    private NoSave noSaveState;
    private final EventBroadcaster<ChatMessageEvent> messageBroadcaster;
    @Resource(key="ChatConversation.toolbarTopColor")
    private Color toolbarTopColor;
    @Resource(key="ChatConversation.toolbarBottomColor")
    private Color toolbarBottomColor;
    @Resource(key="ChatConversation.toolbarBorderColor")
    private Color toolbarBorderColor;
    @Resource(key="ChatConversation.linkFont")
    private Font linkFont;
    @Resource
    private Icon endChat;
    private final JScrollPane conversationScroll;
    private final JPanel chatWrapper;

    @Inject
    public ConversationPane(@Assisted MessageWriter writer, @Assisted ChatFriend chatFriend, Provider<IconManager> iconManager, ChatHyperlinkListenerFactory chatHyperlinkListenerFactory, CloseChatMessage closeChatMessage, FriendPresenceActions remoteHostActions, @Named(value="backgroundExecutor") ScheduledExecutorService schedExecService, EventBroadcaster<ChatMessageEvent> messageBroadcaster) {
        this.writer = writer;
        this.chatFriend = chatFriend;
        this.conversationName = chatFriend.getName();
        this.friendId = chatFriend.getID();
        this.iconManager = iconManager;
        this.noSaveState = null;
        this.remoteHostActions = remoteHostActions;
        this.messageBroadcaster = messageBroadcaster;
        GuiUtils.assignResources(this);
        this.setLayout(new BorderLayout());
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        this.editor.setContentType("text/html");
        this.editor.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        HTMLEditorKit editorKit = (HTMLEditorKit)this.editor.getEditorKit();
        editorKit.setAutoFormSubmission(false);
        this.conversationScroll = new JScrollPane(this.editor, 20, 30);
        this.conversationScroll.setOpaque(false);
        this.conversationScroll.setBorder(BorderFactory.createEmptyBorder());
        final IconButton closeConversation = new IconButton(closeChatMessage);
        ((AbstractButton)closeConversation).setIcon(this.endChat);
        this.chatWrapper = new JPanel();
        this.chatWrapper.setLayout(new OverlayLayout(this.chatWrapper));
        JPanel closePanel = new JPanel();
        closePanel.setLayout(null);
        closePanel.setOpaque(false);
        final Rectangle closeBounds = new Rectangle(268, 5, 6, 6);
        final Rectangle closeBoundsSlider = new Rectangle(250, 5, 6, 6);
        closeConversation.setBounds(closeBounds);
        closePanel.add(closeConversation);
        JPanel conversationPanel = new JPanel(new BorderLayout());
        conversationPanel.setOpaque(false);
        conversationPanel.add((Component)this.conversationScroll, "Center");
        this.chatWrapper.add(closePanel);
        this.chatWrapper.add(conversationPanel);
        this.conversationScroll.getVerticalScrollBar().addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                closeConversation.setBounds(closeBounds);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                closeConversation.setBounds(closeBoundsSlider);
            }
        });
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ConversationPane.this.chatWrapper.repaint();
            }
        };
        this.conversationScroll.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
        this.conversationScroll.getHorizontalScrollBar().addAdjustmentListener(adjustmentListener);
        this.add((Component)this.chatWrapper, "Center");
        PopupUtil.addPopupMenus((JComponent)this.editor, new CopyAction(this.editor), new CopyAllAction());
        this.add((Component)this.footerPanel(writer, chatFriend, schedExecService), "South");
        this.setBackground(DEFAULT_BACKGROUND);
        this.editor.addHyperlinkListener(chatHyperlinkListenerFactory.create(this));
    }

    @Override
    public void newChatMessage(Message message) {
        LOG.debugf("Message: from {0} text: {1}", (Object)message.getSenderName(), (Object)message.toString());
        this.messages.add(message);
        Message.Type type = message.getType();
        if (type != Message.Type.SENT) {
            this.currentChatState = ChatState.active;
        }
        if (message instanceof MessageFileOffer) {
            MessageFileOffer msgWithFileOffer = (MessageFileOffer)message;
            this.addFileOfferMessage(msgWithFileOffer);
        } else if (message instanceof NoSaveStatusMessage) {
            this.updateNoSaveLink(((NoSaveStatusMessage)message).getStatus());
        }
        this.displayMessages();
    }

    private void addFileOfferMessage(MessageFileOffer msgWithFileOffer) {
        String fileOfferID = msgWithFileOffer.getFileOffer().getId();
        this.idToMessageWithFileOffer.put(fileOfferID, msgWithFileOffer);
    }

    private void updateNoSaveLink(NoSave noSave) {
        this.noSaveState = noSave;
        this.nosaveLink.setText("<html><u>" + (this.noSaveState == NoSave.ENABLED ? I18n.tr("On the Record") : I18n.tr("Off the Record")) + "</u></html>");
    }

    @Override
    public void newChatState(ChatState chatState) {
        LOG.debugf("Chat state update for {0} to {1}", (Object)this.chatFriend.getName(), (Object)chatState);
        if (this.currentChatState != chatState) {
            this.currentChatState = chatState;
            this.displayMessages();
        }
    }

    @Override
    public void friendAvailableUpdate(FriendEvent.Type update2) {
        switch (update2) {
            case ADDED: {
                this.currentChatState = ChatState.active;
                this.displayMessages(false);
                if (this.nosaveLink == null || !this.hasFeature(NoSaveFeature.ID)) break;
                this.nosaveLink.setVisible(true);
                break;
            }
            case REMOVED: {
                this.displayMessages(true);
                if (this.nosaveLink == null) break;
                this.nosaveLink.setVisible(false);
            }
        }
    }

    @Override
    public void featureUpdate(Feature feature, FeatureEvent.Type action) {
        if (feature.getID().equals(LimewireFeature.ID)) {
            if (action == FeatureEvent.Type.ADDED) {
                this.downloadlink.setEnabled(true);
            } else if (action == FeatureEvent.Type.REMOVED) {
                this.downloadlink.setEnabled(this.chatFriend.isSignedInToLimewire());
            }
        } else if (feature.getID().equals(NoSaveFeature.ID) && action == FeatureEvent.Type.ADDED) {
            this.ensureNoSaveLinkExists();
            NoSave status = ((NoSaveStatus)feature.getFeature()).getStatus();
            if (status != this.noSaveState) {
                NoSaveStatusMessage msg = new NoSaveStatusMessage(this.friendId, Message.Type.SERVER, status);
                this.messageBroadcaster.broadcast(new ChatMessageEvent(msg));
            }
        }
    }

    @Override
    public void dispose() {
        this.inputPanel.dispose();
    }

    @Override
    public void displayMessages() {
        this.displayMessages(!this.chatFriend.isSignedIn());
    }

    @Override
    public ChatFriend getChatFriend() {
        return this.chatFriend;
    }

    @Override
    public JComponent asComponent() {
        return this;
    }

    @Override
    public Map<String, MessageFileOffer> getFileOfferMessages() {
        return Collections.unmodifiableMap(new HashMap<String, MessageFileOffer>(this.idToMessageWithFileOffer));
    }

    private void displayMessages(boolean friendSignedOff) {
        String chatDoc = ChatDocumentBuilder.buildChatText(this.messages, this.currentChatState, this.conversationName, friendSignedOff);
        LOG.debugf("Chat doc: {0}", (Object)chatDoc);
        final JScrollBar verticalScrollBar = this.conversationScroll.getVerticalScrollBar();
        final int scrollValue = verticalScrollBar.getValue();
        this.editor.setText(chatDoc);
        if (verticalScrollBar.getMaximum() > scrollValue + verticalScrollBar.getVisibleAmount() + 5) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    verticalScrollBar.setValue(scrollValue);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    verticalScrollBar.setValue(verticalScrollBar.getMaximum());
                }
            });
        }
        this.decorateFileOfferButtons();
        this.chatWrapper.repaint();
    }

    private void decorateFileOfferButtons() {
        this.recursiveButtonSearch(this.editor);
    }

    private void recursiveButtonSearch(Container container) {
        for (Component component : container.getComponents()) {
            String extension;
            if (component instanceof Container) {
                this.recursiveButtonSearch((Container)component);
            }
            if (!(component instanceof JButton)) continue;
            JButton button = (JButton)component;
            String buttonText = button.getText();
            if (buttonText.endsWith(":disabled")) {
                buttonText = buttonText.substring(0, buttonText.lastIndexOf(":disabled"));
                button.setText(buttonText);
                button.setEnabled(false);
            }
            if ((extension = FileUtils.getFileExtension(buttonText)).isEmpty()) continue;
            Icon icon = this.iconManager.get().getIconForExtension(extension);
            button.setIcon(icon);
        }
    }

    private JPanel footerPanel(MessageWriter writer, ChatFriend chatFriend, ScheduledExecutorService schedExecService) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(BACKGROUND_COLOR);
        this.downloadlink = new HyperlinkButton(new DownloadFromFriendLibraryAction());
        this.downloadlink.setFont(this.linkFont);
        this.downloadlink.setEnabled(chatFriend.isSignedInToLimewire());
        this.toolbar = new JXPanel(new MigLayout("insets 0 0 0 5, gap 10, alignx right, aligny 50%"));
        ResizeUtils.forceHeight(this.toolbar, 22);
        this.toolbar.setBackgroundPainter(new GenericBarPainter(new GradientPaint(0.0f, 0.0f, this.toolbarTopColor, 0.0f, 1.0f, this.toolbarBottomColor), this.toolbarBorderColor, PainterUtils.TRASPARENT, this.toolbarBorderColor, PainterUtils.TRASPARENT));
        if (this.hasFeature(NoSaveFeature.ID)) {
            this.ensureNoSaveLinkExists();
        }
        this.toolbar.add(this.downloadlink);
        this.inputPanel = new ResizingInputPanel(writer, schedExecService);
        this.inputPanel.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)this.toolbar, "North");
        panel.add((Component)this.inputPanel, "Center");
        return panel;
    }

    private boolean hasFeature(URI feature) {
        return this.getFeature(feature) != null;
    }

    private Feature getFeature(URI feature) {
        for (FriendPresence presence : this.chatFriend.getFriend().getPresences().values()) {
            if (!presence.hasFeatures(feature)) continue;
            return presence.getFeature(feature);
        }
        return null;
    }

    private void ensureNoSaveLinkExists() {
        if (this.nosaveLink == null) {
            NoSaveToggleAction action = new NoSaveToggleAction();
            this.nosaveLink = new HyperlinkButton(action);
            this.nosaveLink.setFont(this.linkFont);
            NoSaveFeature nosaveFeature = (NoSaveFeature)this.getFeature(NoSaveFeature.ID);
            this.updateNoSaveLink(((NoSaveStatus)nosaveFeature.getFeature()).getStatus());
            this.toolbar.add((Component)this.nosaveLink, 0);
        }
    }

    @Override
    public void handleDisplay() {
        this.invalidate();
        this.repaint();
        this.inputPanel.handleDisplay();
    }

    public void offerFolder(ListeningFuture<List<ListeningFuture<LocalFileItem>>> future) {
        future.addFutureListener(new EventListener<FutureEvent<List<ListeningFuture<LocalFileItem>>>>(){

            @Override
            public void handleEvent(FutureEvent<List<ListeningFuture<LocalFileItem>>> event) {
                if (event.getResult() != null) {
                    for (ListeningFuture<LocalFileItem> future : event.getResult()) {
                        ConversationPane.this.offerFile(future);
                    }
                }
            }
        });
    }

    public void offerFile(ListeningFuture<LocalFileItem> future) {
        future.addFutureListener(new EventListener<FutureEvent<LocalFileItem>>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FutureEvent<LocalFileItem> event) {
                if (event.getResult() != null) {
                    FileMetaData metadata = event.getResult().toMetadata();
                    boolean sentFileOffer = false;
                    Friend friend = ConversationPane.this.chatFriend.getFriend();
                    if (!friend.isSignedIn()) {
                        String errorMsg = I18n.tr("File offer not sent because friend signed off.");
                        MessageFileOfferImpl msg = new MessageFileOfferImpl(I18n.tr("me"), ConversationPane.this.friendId, Message.Type.SENT, metadata, null);
                        ConversationPane.this.messageBroadcaster.broadcast(new ChatMessageEvent(new ErrorMessage(errorMsg, msg)));
                        return;
                    }
                    FriendPresence activePresence = friend.getActivePresence();
                    if (activePresence != null && activePresence.hasFeatures(FileOfferFeature.ID)) {
                        sentFileOffer = this.performFileOffer(metadata, activePresence);
                    } else {
                        for (FriendPresence presence : friend.getPresences().values()) {
                            sentFileOffer |= this.performFileOffer(metadata, presence);
                        }
                    }
                    if (sentFileOffer) {
                        ConversationPane.this.messageBroadcaster.broadcast(new ChatMessageEvent(new MessageFileOfferImpl(I18n.tr("me"), ConversationPane.this.friendId, Message.Type.SENT, metadata, null)));
                    }
                }
            }

            private boolean performFileOffer(FileMetaData metadata, FriendPresence presence) {
                Feature fileOfferFeature = presence.getFeature(FileOfferFeature.ID);
                boolean fileOfferSent = false;
                if (fileOfferFeature != null) {
                    try {
                        ConversationPane.this.writer.setChatState(ChatState.active);
                        FeatureTransport fileOfferer = presence.getTransport(FileOfferFeature.class);
                        fileOfferer.sendFeature(presence, metadata);
                        fileOfferSent = true;
                    }
                    catch (FriendException e) {
                        LOG.debug("File offer failed", e);
                    }
                }
                return fileOfferSent;
            }
        });
    }

    private class NoSaveToggleAction
    extends AbstractAction {
        private NoSaveToggleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NoSaveStatus status = (NoSaveStatus)((NoSaveFeature)ConversationPane.this.getFeature(NoSaveFeature.ID)).getFeature();
            try {
                status.toggleStatus();
            }
            catch (FriendException e1) {
                LOG.warn("Error occurred while toggling nosave status", e1);
            }
        }
    }

    private class DownloadFromFriendLibraryAction
    extends AbstractAction {
        public DownloadFromFriendLibraryAction() {
            super("<html><u>" + I18n.tr("Browse Files") + "</u></html>");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConversationPane.this.remoteHostActions.viewFriendLibrary(ConversationPane.this.chatFriend.getFriend());
        }
    }
}

