/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.actions;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.jdesktop.application.Resource;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventUtils;
import org.limewire.ui.swing.util.GuiUtils;

public class FriendServiceItem
extends JLabel {
    @Resource
    private Font font;
    @Resource
    private Color foreground;
    @Resource
    private Color background;
    @Resource
    private Color separatorForeground;

    @Inject
    public FriendServiceItem(EventBean<FriendConnectionEvent> friendConnectionEventBean) {
        GuiUtils.assignResources(this);
        FriendConnection friendConnection = (FriendConnection)EventUtils.getSource(friendConnectionEventBean);
        if (friendConnection != null && friendConnection.isLoggedIn()) {
            this.setFont(this.font);
            this.setForeground(this.foreground);
            this.setBackground(this.background);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.separatorForeground), BorderFactory.createEmptyBorder(0, 6, 0, 6)));
            this.setIconTextGap(4);
            this.setMaximumSize(new Dimension(9999, 22));
            this.setPreferredSize(new Dimension(160, 22));
            this.setMinimumSize(new Dimension(130, 22));
            String name = friendConnection.getConfiguration().getCanonicalizedLocalID();
            this.setText(name);
            this.setToolTipText(name);
            this.setIcon(friendConnection.getConfiguration().getIcon());
        } else {
            this.setVisible(false);
        }
    }
}

