/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.transitions.EffectsManager;
import org.jdesktop.animation.transitions.ScreenTransition;
import org.jdesktop.animation.transitions.TransitionTarget;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.animate.EffectsUtils;
import org.limewire.ui.swing.components.AbstractTabList;
import org.limewire.ui.swing.components.FancyTab;
import org.limewire.ui.swing.components.FancyTabMoreButton;
import org.limewire.ui.swing.components.TabActionMap;
import org.limewire.ui.swing.components.decorators.ComboBoxDecorator;
import org.limewire.ui.swing.util.GuiUtils;

public class FlexibleTabList
extends AbstractTabList {
    private static final int MAX_TAB_WIDTH = 205;
    private static final int MIN_TAB_WIDTH = 115;
    private static final int RIGHT_INSET = 3;
    @Resource
    private Icon moreDefaultIcon;
    @Resource
    private Icon morePressedIcon;
    @Resource
    private Icon moreRolloverIcon;
    private final ComboBoxDecorator comboBoxDecorator;
    private final Action closeOtherAction;
    private final Action closeAllAction;
    private final JComponent parent;
    private final LayoutAnimator animator;
    private int maxVisibleTabs;
    private int vizStartIdx = -1;
    private boolean delayedLayout;
    private AbstractTabList.ChangeType pendingChangeType;

    @Inject
    FlexibleTabList(ComboBoxDecorator comboBoxDecorator) {
        this.comboBoxDecorator = comboBoxDecorator;
        GuiUtils.assignResources(this);
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0 0 0 3, gap 0, filly, hidemode 2"));
        this.setMinimumSize(new Dimension(0, this.getMinimumSize().height));
        this.closeOtherAction = new CloseOther();
        this.closeAllAction = new CloseAll();
        this.maxVisibleTabs = Integer.MAX_VALUE;
        this.parent = new JPanel(new BorderLayout());
        this.parent.setOpaque(false);
        this.parent.add((Component)this, "Center");
        this.animator = new LayoutAnimator(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (FlexibleTabList.this.calculateVisibleTabCount() != FlexibleTabList.this.maxVisibleTabs) {
                    FlexibleTabList.this.layoutTabs(AbstractTabList.ChangeType.NONE);
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.parent;
    }

    public void addTabActionMapAt(TabActionMap actionMap, int i) {
        FancyTab tab = this.createAndPrepareTab(actionMap);
        this.addTab(tab, i);
    }

    @Override
    protected FancyTab createAndPrepareTab(TabActionMap actionMap) {
        FancyTab tab = super.createAndPrepareTab(actionMap);
        tab.setMinimumSize(new Dimension(115, tab.getMinimumSize().height));
        tab.setMaximumSize(new Dimension(205, tab.getMaximumSize().height));
        actionMap.setRemoveAll(this.closeAllAction);
        actionMap.setRemoveOthers(this.closeOtherAction);
        return tab;
    }

    @Override
    protected void layoutTabs() {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.animator.isRunning() && !this.delayedLayout) {
            List<FancyTab> visibleTabs = this.getPendingVisibleTabs(false);
            this.doTabLayout(visibleTabs);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void layoutTabs(AbstractTabList.ChangeType changeType) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.delayedLayout) {
            return;
        }
        if (this.animator.isRunning()) {
            this.pendingChangeType = changeType;
            return;
        }
        this.pendingChangeType = null;
        int oldStartIdx = this.vizStartIdx;
        List<FancyTab> visibleTabs = this.getPendingVisibleTabs(changeType == AbstractTabList.ChangeType.ADDED);
        if (changeType == AbstractTabList.ChangeType.ADDED || changeType == AbstractTabList.ChangeType.REMOVED || changeType == AbstractTabList.ChangeType.SELECTED) {
            this.setupTabEffects(changeType, oldStartIdx, visibleTabs);
            this.animator.start(visibleTabs);
        } else {
            EffectsManager.clearAllEffects();
            this.doTabLayout(visibleTabs);
            this.revalidate();
            this.repaint();
        }
    }

    private void doTabLayout(List<FancyTab> visibleTabs) {
        this.removeAll();
        for (FancyTab tab : visibleTabs) {
            this.add((Component)tab, "growy");
        }
        List<FancyTab> allTabs = this.getTabs();
        if (visibleTabs.size() < allTabs.size()) {
            FancyTabMoreButton more = new FancyTabMoreButton(allTabs);
            this.comboBoxDecorator.decorateIconComboBox(more);
            more.setIcon(this.moreDefaultIcon);
            more.setPressedIcon(this.morePressedIcon);
            more.setRolloverIcon(this.moreRolloverIcon);
            more.setSelectedIcon(this.morePressedIcon);
            this.add((Component)more, "gapleft 0:" + String.valueOf(115));
        }
    }

    private void setupTabEffects(AbstractTabList.ChangeType mode, int oldStartIdx, List<FancyTab> visibleTabs) {
        EffectsManager.clearAllEffects();
        for (FancyTab tab : visibleTabs) {
            if (this.vizStartIdx == oldStartIdx) {
                if (mode == AbstractTabList.ChangeType.ADDED) {
                    EffectsManager.setEffect(tab, EffectsUtils.createMoveInEffect(-115, 0, false), EffectsManager.TransitionType.APPEARING);
                    continue;
                }
                EffectsManager.setEffect(tab, EffectsUtils.createMoveInEffect(this.getWidth() - 3, this.getHeight() / 2, true), EffectsManager.TransitionType.APPEARING);
                continue;
            }
            if (this.vizStartIdx < oldStartIdx || oldStartIdx < 0) {
                EffectsManager.setEffect(tab, EffectsUtils.createMoveInEffect(-115, 0, false), EffectsManager.TransitionType.APPEARING);
                continue;
            }
            EffectsManager.setEffect(tab, EffectsUtils.createMoveInEffect(this.getWidth() - 3, this.getHeight() / 2, true), EffectsManager.TransitionType.APPEARING);
        }
        List<FancyTab> allTabs = this.getTabs();
        for (FancyTab tab : allTabs) {
            if (this.vizStartIdx <= oldStartIdx) {
                EffectsManager.setEffect(tab, EffectsUtils.createMoveOutEffect(this.getWidth() - 3, this.getHeight() / 2, true), EffectsManager.TransitionType.DISAPPEARING);
                continue;
            }
            EffectsManager.setEffect(tab, EffectsUtils.createMoveOutEffect(-115, 0, false), EffectsManager.TransitionType.DISAPPEARING);
        }
    }

    private List<FancyTab> getPendingVisibleTabs(boolean tabAdded) {
        List<FancyTab> vizTabs;
        this.maxVisibleTabs = this.calculateVisibleTabCount();
        List<FancyTab> tabs = this.getTabs();
        if (this.maxVisibleTabs >= tabs.size()) {
            this.vizStartIdx = 0;
            vizTabs = tabs;
        } else {
            FancyTab selectedTab;
            if (tabs.size() - this.vizStartIdx < this.maxVisibleTabs) {
                this.vizStartIdx = tabs.size() - this.maxVisibleTabs;
            }
            vizTabs = tabs.subList(this.vizStartIdx, this.vizStartIdx + this.maxVisibleTabs);
            FancyTab fancyTab = selectedTab = tabAdded ? tabs.get(0) : this.getSelectedTab();
            if (selectedTab != null && !vizTabs.contains(selectedTab)) {
                int selIdx = tabs.indexOf(selectedTab);
                this.vizStartIdx = this.vizStartIdx > selIdx ? selIdx : selIdx - this.maxVisibleTabs + 1;
                vizTabs = tabs.subList(this.vizStartIdx, this.vizStartIdx + this.maxVisibleTabs);
            }
        }
        return vizTabs;
    }

    private int calculateVisibleTabCount() {
        int totalWidth = this.getSize().width;
        int availWidth = Math.max(totalWidth, 115);
        int visibleTabCount = availWidth / 115;
        if (visibleTabCount < this.getTabs().size()) {
            int moreWidth = this.moreDefaultIcon.getIconWidth();
            availWidth = Math.max(totalWidth - moreWidth - 3, 115);
            visibleTabCount = availWidth / 115;
        }
        return visibleTabCount;
    }

    private void recreateTabs() {
        List<FancyTab> tabs = this.getTabs();
        if (tabs.size() > 0) {
            ArrayList<TabActionMap> actionMaps = new ArrayList<TabActionMap>(tabs.size());
            for (FancyTab tab : tabs) {
                actionMaps.add(tab.getTabActionMap());
            }
            this.setTabActionMaps(actionMaps);
        }
    }

    private void layoutDone() {
        if (this.pendingChangeType != null) {
            this.layoutTabs(this.pendingChangeType);
        }
    }

    public void freezeTabLayout() {
        assert (SwingUtilities.isEventDispatchThread());
        this.delayedLayout = true;
    }

    public void updateTabLayout(AbstractTabList.ChangeType changeType) {
        this.delayedLayout = false;
        this.layoutTabs(changeType);
    }

    public void setCloseAllText(String closeAllText) {
        this.getTabProperties().setCloseAllText(closeAllText);
        this.closeAllAction.putValue("Name", closeAllText);
    }

    public void setCloseOneText(String closeOneText) {
        this.getTabProperties().setCloseOneText(closeOneText);
    }

    public void setCloseOtherText(String closeOtherText) {
        this.getTabProperties().setCloseOtherText(closeOtherText);
        this.closeOtherAction.putValue("Name", closeOtherText);
    }

    public void setRemovable(boolean removable) {
        this.getTabProperties().setRemovable(removable);
        this.recreateTabs();
    }

    public void setTabInsets(Insets insets) {
        this.getTabProperties().setInsets(insets);
        this.revalidate();
    }

    private class LayoutAnimator
    extends TimingTargetAdapter
    implements TransitionTarget {
        private final Animator animator = new Animator(300, this);
        private final ScreenTransition transition;
        private List<FancyTab> newVisibleTabs;
        private boolean running;

        public LayoutAnimator(JComponent tabContainer) {
            this.animator.setResolution(30);
            this.transition = new ScreenTransition(tabContainer, (TransitionTarget)this, this.animator);
        }

        public void start(List<FancyTab> visibleTabs) {
            this.running = true;
            this.newVisibleTabs = new ArrayList<FancyTab>(visibleTabs);
            this.transition.start();
        }

        public boolean isRunning() {
            return this.running;
        }

        @Override
        public void setupNextScreen() {
            FlexibleTabList.this.doTabLayout(this.newVisibleTabs);
        }

        @Override
        public void end() {
            this.running = false;
            FlexibleTabList.this.layoutDone();
        }
    }

    private class CloseOther
    extends AbstractAction {
        public CloseOther() {
            super(FlexibleTabList.this.getTabProperties().getCloseOtherText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlexibleTabList.this.freezeTabLayout();
            while (FlexibleTabList.this.getTabs().size() > 1) {
                FancyTab tab = FlexibleTabList.this.getTabs().get(0);
                if (this.isFrom(tab, (Component)e.getSource())) {
                    tab = FlexibleTabList.this.getTabs().get(1);
                }
                tab.remove();
            }
            FlexibleTabList.this.updateTabLayout(AbstractTabList.ChangeType.REMOVED);
        }

        private boolean isFrom(JComponent parent, Component child) {
            while (child.getParent() != null) {
                if ((child = child.getParent()) instanceof JPopupMenu) {
                    child = ((JPopupMenu)child).getInvoker();
                }
                if (child != parent) continue;
                return true;
            }
            return false;
        }
    }

    private class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(FlexibleTabList.this.getTabProperties().getCloseAllText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlexibleTabList.this.freezeTabLayout();
            while (!FlexibleTabList.this.getTabs().isEmpty()) {
                FlexibleTabList.this.getTabs().get(0).remove();
            }
            FlexibleTabList.this.updateTabLayout(AbstractTabList.ChangeType.REMOVED);
        }
    }
}

