/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.file.selection;

import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.swarm.SwarmBlockSelector;

public class RandomDownloadStrategy
implements SwarmBlockSelector {
    private static final Log LOG = LogFactory.getLog(RandomDownloadStrategy.class);
    private static final int MAX_FRAGMENTS = 16;
    protected static Random pseudoRandom = new Random();
    protected final long completedSize;

    public RandomDownloadStrategy(long completedSize) {
        this.completedSize = completedSize;
    }

    @Override
    public Range selectAssignment(IntervalSet candidateBytes, IntervalSet neededBytes, long blockSize) throws NoSuchElementException {
        long lowerBound = neededBytes.getFirst().getLow();
        long upperBound = neededBytes.getLast().getHigh();
        if (blockSize < 1L) {
            throw new IllegalArgumentException("Block size cannot be " + blockSize);
        }
        if (lowerBound < 0L) {
            throw new IllegalArgumentException("lowerBound must be >= 0, " + lowerBound + "<0");
        }
        if (upperBound >= this.completedSize) {
            throw new IllegalArgumentException("Greatest needed byte must be less than completedSize " + upperBound + " >= " + this.completedSize);
        }
        if (candidateBytes.isEmpty()) {
            throw new NoSuchElementException();
        }
        long idealLocation = this.getIdealLocation(neededBytes, blockSize);
        Range intervalAbove = null;
        Range intervalBelow = null;
        for (Range candidateInterval : candidateBytes) {
            if (candidateInterval.getLow() < idealLocation) {
                intervalBelow = this.optimizeIntervalBelow(candidateInterval, idealLocation, blockSize);
            }
            if (candidateInterval.getHigh() < idealLocation) continue;
            intervalAbove = this.optimizeIntervalAbove(candidateInterval, idealLocation, blockSize);
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("idealLocation=" + idealLocation + " intervalAbove=" + intervalAbove + " intervalBelow=" + intervalBelow + " out of possibilites:" + candidateBytes);
        }
        if (intervalAbove == null) {
            return intervalBelow;
        }
        if (intervalBelow == null) {
            return intervalAbove;
        }
        return (pseudoRandom.nextInt() & 1) == 1 ? intervalAbove : intervalBelow;
    }

    protected long alignHigh(long location, long blockSize) {
        location += blockSize;
        location -= location % blockSize;
        return location - 1L;
    }

    protected long alignLow(long location, long blockSize) {
        location -= location % blockSize;
        return location;
    }

    private long getIdealLocation(IntervalSet neededBytes, long blockSize) {
        int fragmentCount = neededBytes.getNumberOfIntervals();
        if (fragmentCount >= 16) {
            int randomFragmentNumber = pseudoRandom.nextInt(fragmentCount + 1);
            if (randomFragmentNumber == fragmentCount) {
                return neededBytes.getLast().getHigh() + 1L;
            }
            return neededBytes.getAllIntervalsAsList().get(randomFragmentNumber).getLow();
        }
        return this.getRandomLocation(neededBytes.getFirst().getLow(), neededBytes.getLast().getHigh(), blockSize);
    }

    private Range optimizeIntervalAbove(Range candidate, long location, long blockSize) {
        long bestHigh;
        long bestLow = candidate.getLow();
        if (bestLow < location) {
            bestLow = location;
        }
        if ((bestHigh = this.alignHigh(bestLow, blockSize)) > candidate.getHigh()) {
            bestHigh = candidate.getHigh();
        }
        if (candidate.getHigh() == bestHigh && candidate.getLow() == bestLow) {
            return candidate;
        }
        return Range.createRange(bestLow, bestHigh);
    }

    private Range optimizeIntervalBelow(Range candidate, long location, long blockSize) {
        long bestLow;
        long bestHigh = candidate.getHigh();
        if (bestHigh >= location) {
            bestHigh = location - 1L;
        }
        if ((bestLow = this.alignLow(bestHigh, blockSize)) < candidate.getLow()) {
            bestLow = candidate.getLow();
        }
        if (candidate.getHigh() == bestHigh && candidate.getLow() == bestLow) {
            return candidate;
        }
        return Range.createRange(bestLow, bestHigh);
    }

    private long getRandomLocation(long minIndex, long maxIndex, long blockSize) {
        long minBlock = minIndex / blockSize;
        long maxBlock = maxIndex / blockSize;
        if (minBlock >= maxBlock) {
            return minIndex;
        }
        return blockSize * (minBlock + Math.abs(pseudoRandom.nextLong() % (maxBlock - minBlock + 1L)));
    }
}

