/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.statistic;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.statistic.Statistic;
import org.limewire.statistic.StatisticAccumulator;

@EagerSingleton
final class StatisticsAccumulatorImpl
implements StatisticAccumulator,
Service {
    private final ScheduledExecutorService backgroundExecutor;
    private volatile ScheduledFuture<?> scheduledFuture;
    private final List<Statistic> basicStatistics = new CopyOnWriteArrayList<Statistic>();

    @Inject
    StatisticsAccumulatorImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        this.backgroundExecutor = backgroundExecutor;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        if (this.scheduledFuture != null) {
            throw new IllegalStateException("already started!");
        }
        this.scheduledFuture = this.backgroundExecutor.scheduleWithFixedDelay(new Runner(), 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        ScheduledFuture<?> f = this.scheduledFuture;
        if (f != null) {
            f.cancel(false);
            this.scheduledFuture = null;
        }
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Statistic Management");
    }

    @Override
    public void addBasicStatistic(Statistic stat) {
        this.basicStatistics.add(stat);
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            for (Statistic stat : StatisticsAccumulatorImpl.this.basicStatistics) {
                stat.storeCurrentStat();
            }
        }
    }
}

