/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendEvent;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.FriendPresenceEvent;
import org.limewire.friend.api.MutableFriendManager;
import org.limewire.friend.api.feature.LimewireFeature;
import org.limewire.inject.EagerSingleton;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

@EagerSingleton
class MutableFriendManagerImpl
implements MutableFriendManager {
    private static final Log LOG = LogFactory.getLog(MutableFriendManagerImpl.class);
    private final EventBroadcaster<FriendEvent> knownBroadcaster;
    private final EventBroadcaster<FriendEvent> availableBroadcaster;
    private final ConcurrentMap<String, Friend> knownFriends = new ConcurrentHashMap<String, Friend>();
    private final ConcurrentMap<String, Friend> availFriends = new ConcurrentHashMap<String, Friend>();

    @Inject
    public MutableFriendManagerImpl(@Named(value="known") EventBroadcaster<FriendEvent> knownBroadcaster, @Named(value="available") EventBroadcaster<FriendEvent> availableBroadcaster, EventBroadcaster<FriendPresenceEvent> friendPresenceBroadcaster) {
        this.knownBroadcaster = knownBroadcaster;
        this.availableBroadcaster = availableBroadcaster;
    }

    @Inject
    void register(ListenerSupport<FriendConnectionEvent> listenerSupport) {
        listenerSupport.addListener(new EventListener<FriendConnectionEvent>(){

            @Override
            public void handleEvent(FriendConnectionEvent event) {
                switch ((FriendConnectionEvent.Type)((Object)event.getType())) {
                    case DISCONNECTED: {
                        for (Friend user : MutableFriendManagerImpl.this.availFriends.values()) {
                            MutableFriendManagerImpl.this.removeAvailableFriend(user);
                        }
                        for (Friend user : MutableFriendManagerImpl.this.knownFriends.values()) {
                            MutableFriendManagerImpl.this.removeKnownFriend(user, false);
                        }
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void addKnownFriend(Friend friend) {
        if (this.knownFriends.putIfAbsent(friend.getId(), friend) == null) {
            LOG.debugf("adding known friend: {0}", (Object)friend);
            this.knownBroadcaster.broadcast(new FriendEvent(friend, FriendEvent.Type.ADDED));
        } else {
            LOG.debugf("not adding known friend: {0}", (Object)friend);
        }
    }

    @Override
    public void removeKnownFriend(Friend friend, boolean delete) {
        if (this.knownFriends.remove(friend.getId()) != null) {
            LOG.debugf("removed known friend: {0}", (Object)friend);
            if (delete) {
                this.knownBroadcaster.broadcast(new FriendEvent(friend, FriendEvent.Type.DELETE));
            }
            this.knownBroadcaster.broadcast(new FriendEvent(friend, FriendEvent.Type.REMOVED));
        } else {
            LOG.debugf("known friend {0} already removed", (Object)friend);
        }
    }

    @Override
    public FriendPresence getMostRelevantFriendPresence(String id) {
        Friend friend = (Friend)this.availFriends.get(id);
        if (friend == null) {
            return null;
        }
        Collection<FriendPresence> presences = friend.getPresences().values();
        for (FriendPresence nextPresence : presences) {
            if (!nextPresence.hasFeatures(LimewireFeature.ID)) continue;
            return nextPresence;
        }
        return null;
    }

    Map<String, Friend> getKnownFriends() {
        return Collections.unmodifiableMap(this.knownFriends);
    }

    Map<String, Friend> getAvailableFriends() {
        return Collections.unmodifiableMap(this.availFriends);
    }

    Set<String> getAvailableFriendIds() {
        return Collections.unmodifiableSet(this.availFriends.keySet());
    }

    @Override
    public void addAvailableFriend(Friend friend) {
        if (this.availFriends.putIfAbsent(friend.getId(), friend) == null) {
            LOG.debugf("adding avail friend: {0}", (Object)friend);
            this.availableBroadcaster.broadcast(new FriendEvent(friend, FriendEvent.Type.ADDED));
        } else {
            LOG.debugf("not adding avail friend: {0}", (Object)friend);
        }
    }

    @Override
    public void removeAvailableFriend(Friend friend) {
        if (this.availFriends.remove(friend.getId()) != null) {
            LOG.debugf("removed avail friend: {0}", (Object)friend);
            this.availableBroadcaster.broadcast(new FriendEvent(friend, FriendEvent.Type.REMOVED));
        } else {
            LOG.debugf("avail friend {0} already removed", (Object)friend);
        }
    }
}

