/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.xmpp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewManager;
import com.limegroup.gnutella.uploader.HttpException;
import com.limegroup.gnutella.uploader.authentication.HttpRequestFileViewProvider;
import java.util.Collections;
import org.apache.http.auth.Credentials;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.auth.ServerAuthState;

@Singleton
public class FriendFileViewProvider
implements HttpRequestFileViewProvider {
    private final FileViewManager fileManager;

    @Inject
    public FriendFileViewProvider(FileViewManager fileManager) {
        this.fileManager = fileManager;
    }

    @Override
    public Iterable<FileView> getFileViews(String userId, HttpContext httpContext) throws HttpException {
        Credentials credentials;
        if (userId == null) {
            throw new HttpException("no user given", 403);
        }
        ServerAuthState authState = (ServerAuthState)httpContext.getAttribute("http.server.auth");
        if (authState != null && (credentials = authState.getCredentials()) != null) {
            if (!credentials.getUserPrincipal().getName().equals(userId)) {
                throw new HttpException("not authorized", 401);
            }
            FileView buddyFileList = this.fileManager.getFileViewForId(credentials.getUserPrincipal().getName());
            if (buddyFileList == null) {
                throw new HttpException("no such list for: " + credentials.getUserPrincipal().getName(), 404);
            }
            return Collections.singletonList(buddyFileList);
        }
        throw new HttpException("forbidden", 403);
    }
}

