/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.URN;
import org.limewire.core.api.search.GroupedSearchResult;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.search.SearchResultList;
import org.limewire.core.api.search.sponsored.SponsoredResult;
import org.limewire.core.impl.search.CoreSearch;
import org.limewire.core.impl.search.GroupedSearchResultImpl;
import org.limewire.io.GUID;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;

class CoreSearchResultList
implements SearchResultList {
    private final Search search;
    private final SearchDetails searchDetails;
    private final EventListenerList<Collection<GroupedSearchResult>> listListeners;
    private final Comparator<Object> resultFinder;
    private final SearchListener searchListener;
    private final EventList<GroupedSearchResult> groupedUrnResultList;
    private final EventList<GroupedSearchResult> threadSafeResultList;
    private volatile int resultCount;

    public CoreSearchResultList(Search search, SearchDetails searchDetails) {
        this.search = search;
        this.searchDetails = searchDetails;
        this.listListeners = new EventListenerList();
        this.resultFinder = new UrnResultFinder();
        this.searchListener = new SearchListenerImpl();
        this.groupedUrnResultList = new BasicEventList<GroupedSearchResult>();
        this.threadSafeResultList = GlazedListsFactory.threadSafeList(this.groupedUrnResultList);
        search.addSearchListener(this.searchListener);
    }

    @Override
    public GUID getGuid() {
        if (this.search instanceof CoreSearch) {
            return ((CoreSearch)this.search).getQueryGuid();
        }
        return null;
    }

    @Override
    public int getResultCount() {
        return this.resultCount;
    }

    @Override
    public Search getSearch() {
        return this.search;
    }

    @Override
    public EventList<GroupedSearchResult> getGroupedResults() {
        return this.threadSafeResultList;
    }

    @Override
    public void addListener(EventListener<Collection<GroupedSearchResult>> listener) {
        this.listListeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<Collection<GroupedSearchResult>> listener) {
        return this.listListeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock lock = this.groupedUrnResultList.getReadWriteLock().writeLock();
        lock.lock();
        try {
            this.groupedUrnResultList.clear();
            this.resultCount = 0;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void dispose() {
        this.search.removeSearchListener(this.searchListener);
    }

    void addResult(SearchResult result) {
        this.addResultsInternal(Collections.singletonList(result));
    }

    void addResults(Collection<? extends SearchResult> results) {
        this.addResultsInternal(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResultsInternal(Collection<? extends SearchResult> results) {
        ArrayList<GroupedSearchResult> newResults = new ArrayList<GroupedSearchResult>();
        Lock lock = this.groupedUrnResultList.getReadWriteLock().writeLock();
        lock.lock();
        try {
            for (SearchResult searchResult : results) {
                GroupedSearchResultImpl gsr;
                URN urn = searchResult.getUrn();
                if (urn == null) continue;
                int idx = Collections.binarySearch(this.groupedUrnResultList, urn, this.resultFinder);
                if (idx >= 0) {
                    gsr = (GroupedSearchResultImpl)this.groupedUrnResultList.get(idx);
                    gsr.addNewSource(searchResult, this.searchDetails.getSearchQuery());
                    this.groupedUrnResultList.set(idx, gsr);
                    gsr.notifyNewSource();
                } else {
                    idx = -(idx + 1);
                    gsr = new GroupedSearchResultImpl(searchResult, this.searchDetails.getSearchQuery());
                    this.groupedUrnResultList.add(idx, gsr);
                    newResults.add(gsr);
                }
                this.resultCount += searchResult.getSources().size();
            }
        }
        finally {
            lock.unlock();
        }
        if (newResults.size() > 0) {
            this.notifyResultsCreated(newResults);
        }
    }

    private void notifyResultsCreated(Collection<GroupedSearchResult> results) {
        this.listListeners.broadcast(results);
    }

    private static class UrnResultFinder
    implements Comparator<Object> {
        private UrnResultFinder() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ((GroupedSearchResult)o1).getUrn().compareTo((URN)o2);
        }
    }

    private class SearchListenerImpl
    implements SearchListener {
        private SearchListenerImpl() {
        }

        @Override
        public void handleSearchResult(Search search, SearchResult searchResult) {
            CoreSearchResultList.this.addResult(searchResult);
        }

        @Override
        public void handleSearchResults(Search search, Collection<? extends SearchResult> searchResults) {
            CoreSearchResultList.this.addResults(searchResults);
        }

        @Override
        public void handleSponsoredResults(Search search, List<SponsoredResult> sponsoredResults) {
        }

        @Override
        public void searchStarted(Search search) {
        }

        @Override
        public void searchStopped(Search search) {
        }
    }
}

