/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.activation.impl;

import java.util.Date;
import org.limewire.activation.api.ActivationID;
import org.limewire.activation.api.ActivationItem;
import org.limewire.util.OSUtils;

class ActivationItemImpl
implements ActivationItem {
    private final int intID;
    private final ActivationID moduleID;
    private final String licenseName;
    private final Date datePurchased;
    private final Date dateExpired;
    private final ActivationItem.Status currentStatus;

    public ActivationItemImpl(int intID, String licenseName, Date datePurchased, Date dateExpired, ActivationItem.Status currentStatus) {
        this(intID, licenseName, datePurchased, dateExpired, currentStatus, false);
    }

    public ActivationItemImpl(int intID, String licenseName, Date datePurchased, Date dateExpired, ActivationItem.Status currentStatus, boolean isLoadedFromDisk) {
        this.intID = intID;
        this.moduleID = ActivationID.getActivationID(intID);
        this.licenseName = licenseName;
        this.datePurchased = datePurchased;
        this.dateExpired = dateExpired;
        this.currentStatus = this.updateActivationStatus(currentStatus, isLoadedFromDisk);
    }

    @Override
    public ActivationID getModuleID() {
        return this.moduleID;
    }

    @Override
    public Date getDateExpired() {
        return this.dateExpired;
    }

    @Override
    public Date getDatePurchased() {
        return this.datePurchased;
    }

    @Override
    public String getLicenseName() {
        return this.licenseName;
    }

    @Override
    public String getURL() {
        return "http://www.limewire.com/client_redirect/?page=accountDetails" + Integer.toString(this.intID);
    }

    @Override
    public ActivationItem.Status getStatus() {
        return this.currentStatus;
    }

    private ActivationItem.Status updateActivationStatus(ActivationItem.Status status, boolean isLoadedFromDisk) {
        if (status == ActivationItem.Status.ACTIVE) {
            if (this.moduleID == ActivationID.UNKNOWN_MODULE) {
                return ActivationItem.Status.UNUSEABLE_LW;
            }
            if (this.moduleID == ActivationID.AVG_MODULE && !OSUtils.isAVGCompatibleWindows()) {
                return ActivationItem.Status.UNUSEABLE_OS;
            }
            if (isLoadedFromDisk && System.currentTimeMillis() > this.dateExpired.getTime()) {
                return ActivationItem.Status.EXPIRED;
            }
            return status;
        }
        return status;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActivationItemImpl)) {
            return false;
        }
        ActivationItemImpl item = (ActivationItemImpl)object;
        return item.getDateExpired().equals(this.dateExpired) && item.getDatePurchased().equals(this.datePurchased) && item.getLicenseName().equals(this.licenseName) && item.getModuleID().equals((Object)this.moduleID) && item.getStatus().equals((Object)this.currentStatus) && item.getURL().equals(this.getURL());
    }
}

