/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

public class OggCRCFactory {
    private static long[] crc_lookup = new long[256];
    private static boolean init = false;

    public static void init() {
        for (int i = 0; i < 256; ++i) {
            long r = i << 24;
            for (int j = 0; j < 8; ++j) {
                if ((r & 0x80000000L) != 0L) {
                    r = r << 1 ^ 0x4C11DB7L;
                    continue;
                }
                r <<= 1;
            }
            OggCRCFactory.crc_lookup[i] = r & 0xFFFFFFFFFFFFFFFFL;
        }
        init = true;
    }

    public boolean checkCRC(byte[] data, byte[] crc) {
        return new String(crc).equals(new String(OggCRCFactory.computeCRC(data)));
    }

    public static byte[] computeCRC(byte[] data) {
        if (!init) {
            OggCRCFactory.init();
        }
        long crc_reg = 0L;
        for (int i = 0; i < data.length; ++i) {
            int tmp = (int)(crc_reg >>> 24 & 0xFFL ^ (long)OggCRCFactory.u(data[i]));
            crc_reg = crc_reg << 8 ^ crc_lookup[tmp];
            crc_reg &= 0xFFFFFFFFFFFFFFFFL;
        }
        byte[] sum = new byte[]{(byte)(crc_reg & 0xFFL), (byte)(crc_reg >>> 8 & 0xFFL), (byte)(crc_reg >>> 16 & 0xFFL), (byte)(crc_reg >>> 24 & 0xFFL)};
        return sum;
    }

    private static int u(int n) {
        return n & 0xFF;
    }
}

