/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.media.AsyncBufferTransferHandlerNotifier;
import net.sf.fmj.utility.LoggerSingleton;

public class CloneablePushBufferDataSource
extends PushBufferDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    private final PushBufferDataSource source;
    private PushBufferStream[] streams;
    private final ClonedDataSource firstClonedDataSource;
    private List<ClonedDataSource> clones = new ArrayList<ClonedDataSource>();
    private boolean sourceConnected = false;
    private boolean sourceStarted = false;

    public CloneablePushBufferDataSource(PushBufferDataSource source) {
        this.source = source;
        this.firstClonedDataSource = (ClonedDataSource)this.createClone();
    }

    public PushBufferStream[] getStreams() {
        return this.firstClonedDataSource.getStreams();
    }

    public void connect() throws IOException {
        this.firstClonedDataSource.connect();
    }

    public void disconnect() {
        this.firstClonedDataSource.disconnect();
    }

    public String getContentType() {
        return this.firstClonedDataSource.getContentType();
    }

    public Object getControl(String controlType) {
        return this.firstClonedDataSource.getControl(controlType);
    }

    public Object[] getControls() {
        return this.firstClonedDataSource.getControls();
    }

    public Time getDuration() {
        return this.firstClonedDataSource.getDuration();
    }

    public void start() throws IOException {
        this.firstClonedDataSource.start();
    }

    public void stop() throws IOException {
        this.firstClonedDataSource.stop();
    }

    public synchronized DataSource createClone() {
        ClonedDataSource result = new ClonedDataSource();
        this.clones.add(result);
        return result;
    }

    static /* synthetic */ PushBufferStream[] access$302(CloneablePushBufferDataSource x0, PushBufferStream[] x1) {
        x0.streams = x1;
        return x1;
    }

    private class ClonedDataSource
    extends PushBufferDataSource {
        private ClonedPushBufferStream[] clonedStreams;
        private boolean cloneConnected;
        public boolean cloneStarted;

        private ClonedDataSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PushBufferStream[] getStreams() {
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                if (this.clonedStreams == null) {
                    this.clonedStreams = new ClonedPushBufferStream[CloneablePushBufferDataSource.this.streams.length];
                    for (int i = 0; i < CloneablePushBufferDataSource.this.streams.length; ++i) {
                        this.clonedStreams[i] = new ClonedPushBufferStream(CloneablePushBufferDataSource.this.streams[i]);
                    }
                }
                return this.clonedStreams;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect() throws IOException {
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                if (this.cloneConnected) {
                    return;
                }
                if (!CloneablePushBufferDataSource.this.sourceConnected) {
                    CloneablePushBufferDataSource.this.source.connect();
                    CloneablePushBufferDataSource.this.sourceConnected = true;
                }
                this.cloneConnected = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            boolean disposeAllClones = false;
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                if (!this.cloneConnected) {
                    return;
                }
                this.cloneConnected = false;
                if (CloneablePushBufferDataSource.this.sourceConnected) {
                    for (ClonedDataSource clone : CloneablePushBufferDataSource.this.clones) {
                        if (!clone.cloneConnected) continue;
                        return;
                    }
                    CloneablePushBufferDataSource.this.source.disconnect();
                    for (ClonedDataSource clone : CloneablePushBufferDataSource.this.clones) {
                        clone.disposeAsync();
                    }
                    CloneablePushBufferDataSource.this.sourceConnected = false;
                }
            }
            if (disposeAllClones) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getContentType() {
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                return CloneablePushBufferDataSource.this.source.getContentType();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getControl(String controlType) {
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                return CloneablePushBufferDataSource.this.source.getControl(controlType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getControls() {
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                return CloneablePushBufferDataSource.this.source.getControls();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Time getDuration() {
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                return CloneablePushBufferDataSource.this.source.getDuration();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws IOException {
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                if (this.cloneStarted) {
                    return;
                }
                if (!CloneablePushBufferDataSource.this.sourceStarted) {
                    CloneablePushBufferDataSource.access$302(CloneablePushBufferDataSource.this, CloneablePushBufferDataSource.this.source.getStreams());
                    for (int i = 0; i < CloneablePushBufferDataSource.this.streams.length; ++i) {
                        CloneablePushBufferDataSource.this.streams[i].setTransferHandler(new MyBufferTransferHandler(i));
                    }
                    CloneablePushBufferDataSource.this.source.start();
                    CloneablePushBufferDataSource.this.sourceStarted = true;
                }
                this.cloneStarted = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws IOException {
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                if (!this.cloneStarted) {
                    return;
                }
                this.cloneStarted = false;
                if (CloneablePushBufferDataSource.this.sourceStarted) {
                    for (ClonedDataSource clone : CloneablePushBufferDataSource.this.clones) {
                        if (!clone.cloneStarted) continue;
                        return;
                    }
                    CloneablePushBufferDataSource.this.source.stop();
                    CloneablePushBufferDataSource.this.sourceStarted = false;
                }
            }
        }

        public void disposeAsync() {
            for (ClonedPushBufferStream clonedStream : this.clonedStreams) {
                clonedStream.disposeAsync();
            }
        }

        class ClonedPushBufferStream
        implements PushBufferStream {
            private final PushBufferStream stream;
            private final ProducerConsumerQueue bufferQueue = new ProducerConsumerQueue();
            private boolean eos = false;
            private final AsyncBufferTransferHandlerNotifier asyncBufferTransferHandlerNotifier = new AsyncBufferTransferHandlerNotifier(this);

            public ClonedPushBufferStream(PushBufferStream stream) {
                this.stream = stream;
            }

            ProducerConsumerQueue getBufferQueue() {
                return this.bufferQueue;
            }

            public boolean endOfStream() {
                return this.eos;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ContentDescriptor getContentDescriptor() {
                CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
                synchronized (cloneablePushBufferDataSource) {
                    return this.stream.getContentDescriptor();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long getContentLength() {
                CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
                synchronized (cloneablePushBufferDataSource) {
                    return this.stream.getContentLength();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getControl(String controlType) {
                CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
                synchronized (cloneablePushBufferDataSource) {
                    return this.stream.getControl(controlType);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object[] getControls() {
                CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
                synchronized (cloneablePushBufferDataSource) {
                    return this.stream.getControls();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Format getFormat() {
                CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
                synchronized (cloneablePushBufferDataSource) {
                    return this.stream.getFormat();
                }
            }

            public void read(Buffer buffer) throws IOException {
                Buffer nextBuffer = null;
                try {
                    nextBuffer = (Buffer)this.bufferQueue.get();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("" + e);
                }
                if (nextBuffer.isEOM()) {
                    this.eos = true;
                }
                buffer.copy(nextBuffer);
            }

            public void setTransferHandler(BufferTransferHandler transferHandler) {
                this.asyncBufferTransferHandlerNotifier.setTransferHandler(transferHandler);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notifyTransferHandlerAsync() throws InterruptedException {
                CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
                synchronized (cloneablePushBufferDataSource) {
                    if (!ClonedDataSource.this.cloneStarted) {
                        return;
                    }
                    this.asyncBufferTransferHandlerNotifier.notifyTransferHandlerAsync();
                }
            }

            public void dispose() {
                this.asyncBufferTransferHandlerNotifier.dispose();
            }

            public void disposeAsync() {
                this.asyncBufferTransferHandlerNotifier.disposeAsync();
            }
        }
    }

    private class MyBufferTransferHandler
    implements BufferTransferHandler {
        private final int streamIndex;

        public MyBufferTransferHandler(int streamIndex) {
            this.streamIndex = streamIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferData(PushBufferStream stream) {
            Buffer originalBuffer;
            block10: {
                originalBuffer = new Buffer();
                try {
                    stream.read(originalBuffer);
                }
                catch (IOException e) {
                    originalBuffer.setEOM(true);
                    originalBuffer.setDiscard(true);
                    originalBuffer.setLength(0);
                    if (e instanceof InterruptedIOException) break block10;
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
            ArrayList<ClonedDataSource.ClonedPushBufferStream> clonedStreams = new ArrayList<ClonedDataSource.ClonedPushBufferStream>();
            CloneablePushBufferDataSource cloneablePushBufferDataSource = CloneablePushBufferDataSource.this;
            synchronized (cloneablePushBufferDataSource) {
                for (ClonedDataSource clone : CloneablePushBufferDataSource.this.clones) {
                    ClonedDataSource.ClonedPushBufferStream clonedStream = (ClonedDataSource.ClonedPushBufferStream)clone.getStreams()[this.streamIndex];
                    if (!clone.cloneStarted) continue;
                    clonedStreams.add(clonedStream);
                }
            }
            try {
                for (ClonedDataSource.ClonedPushBufferStream clonedStream : clonedStreams) {
                    clonedStream.getBufferQueue().put(originalBuffer.clone());
                }
                for (ClonedDataSource.ClonedPushBufferStream clonedStream : clonedStreams) {
                    clonedStream.notifyTransferHandlerAsync();
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
                return;
            }
        }
    }
}

