/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.hashing;

import com.limegroup.gnutella.hashing.NonMetaDataHasher;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.limewire.io.IOUtils;

class FLACNonMetaDataHasher
extends NonMetaDataHasher {
    private final File file;

    FLACNonMetaDataHasher(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStartPosition() throws IOException {
        long l;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.file, "r");
            FlacStreamReader flacStream = new FlacStreamReader(raf);
            try {
                flacStream.findStream();
            }
            catch (CannotReadException e) {
                throw new IOException(e);
            }
            boolean isEndOfHeader = false;
            while (!isEndOfHeader) {
                MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(raf);
                raf.seek(raf.getFilePointer() + (long)mbh.getDataLength());
                isEndOfHeader = mbh.isLastBlock();
            }
            l = raf.getFilePointer();
        }
        catch (Throwable throwable) {
            IOUtils.close(raf);
            throw throwable;
        }
        IOUtils.close(raf);
        return l;
    }

    @Override
    public long getEndPosition() throws IOException {
        return this.file.length();
    }
}

