/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.LWSIntegrationServices;
import com.limegroup.gnutella.downloader.LWSIntegrationServicesDelegate;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.StoreDownloader;
import com.limegroup.gnutella.lws.server.LWSManager;
import com.limegroup.gnutella.lws.server.LWSManagerCommandResponseHandlerWithCallback;
import com.limegroup.gnutella.lws.server.LWSUtil;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.util.Tagged;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.limewire.activation.api.ActivationManager;
import org.limewire.core.api.Category;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.LWSSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.util.Visitor;

@EagerSingleton
public final class LWSIntegrationServicesImpl
implements LWSIntegrationServices,
Service {
    private static final Log LOG = LogFactory.getLog(LWSIntegrationServicesImpl.class);
    private static final int CALL_GET_DOWNLOAD_PROGRESS_PERIOD_MILLIS = 300000;
    private long lastTimeWeCalledGetDownloadProgress = -1L;
    private final LWSManager lwsManager;
    private final DownloadServices downloadServices;
    private final LWSIntegrationServicesDelegate lwsIntegrationServicesDelegate;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final ScheduledExecutorService scheduler;
    private final CategoryManager categoryManager;
    private final ActivationManager activationManager;
    private final Map<String, String> downloaderIDs2progressBarIDs = new HashMap<String, String>();
    private final Map<String, Downloader> everActiveDownloaderIDs2Downloaders = new HashMap<String, Downloader>();
    private String downloadPrefix;
    private final EnumMap<Downloader.DownloadState, String> downloadStateName = new EnumMap<Downloader.DownloadState, String>(Downloader.DownloadState.class){
        {
            this.put(Downloader.DownloadState.INITIALIZING, "Initializing");
            this.put(Downloader.DownloadState.QUEUED, "Queued");
            this.put(Downloader.DownloadState.CONNECTING, "Connecting");
            this.put(Downloader.DownloadState.DOWNLOADING, "Downloading");
            this.put(Downloader.DownloadState.BUSY, "Busy");
            this.put(Downloader.DownloadState.COMPLETE, "Complete");
            this.put(Downloader.DownloadState.ABORTED, "Aborted");
            this.put(Downloader.DownloadState.GAVE_UP, "Gave up");
            this.put(Downloader.DownloadState.UNABLE_TO_CONNECT, "Could not connect");
            this.put(Downloader.DownloadState.DISK_PROBLEM, "Disk problem");
            this.put(Downloader.DownloadState.WAITING_FOR_GNET_RESULTS, "Waiting for gnet results");
            this.put(Downloader.DownloadState.CORRUPT_FILE, "Corrupt file");
            this.put(Downloader.DownloadState.REMOTE_QUEUED, "Remote queued");
            this.put(Downloader.DownloadState.HASHING, "Hashing");
            this.put(Downloader.DownloadState.SAVING, "Saving");
            this.put(Downloader.DownloadState.WAITING_FOR_USER, "Waiting for user");
            this.put(Downloader.DownloadState.WAITING_FOR_CONNECTIONS, "Waiting for connections");
            this.put(Downloader.DownloadState.ITERATIVE_GUESSING, "Iterative guessing");
            this.put(Downloader.DownloadState.QUERYING_DHT, "Querying DHT");
            this.put(Downloader.DownloadState.PAUSED, "Paused");
            this.put(Downloader.DownloadState.INVALID, "Invalid");
            this.put(Downloader.DownloadState.RESUMING, "Resuming");
            this.put(Downloader.DownloadState.DANGEROUS, "Dangerous");
            this.put(Downloader.DownloadState.SCANNING, "Scanning");
            this.put(Downloader.DownloadState.THREAT_FOUND, "Threat found");
            this.put(Downloader.DownloadState.SCAN_FAILED, "Scan failed");
            this.put(Downloader.DownloadState.APPLYING_ANTIVIRUS_DEFINITION_UPDATE, "Applying anti-virus definition update");
            assert (this.isComplete());
        }

        private boolean isComplete() {
            for (Downloader.DownloadState state : Downloader.DownloadState.values()) {
                if (this.containsKey((Object)state)) continue;
                return false;
            }
            return true;
        }
    };

    @Inject
    public LWSIntegrationServicesImpl(LWSManager lwsManager, DownloadServices downloadServices, LWSIntegrationServicesDelegate lwsIntegrationServicesDelegate, RemoteFileDescFactory remoteFileDescFactory, @Named(value="backgroundExecutor") ScheduledExecutorService scheduler, CategoryManager categoryManager, ActivationManager activationManager) {
        this(lwsManager, downloadServices, lwsIntegrationServicesDelegate, remoteFileDescFactory, scheduler, LWSSettings.LWS_DOWNLOAD_PREFIX.get(), categoryManager, activationManager);
    }

    LWSIntegrationServicesImpl(LWSManager lwsManager, DownloadServices downloadServices, LWSIntegrationServicesDelegate lwsIntegrationServicesDelegate, RemoteFileDescFactory remoteFileDescFactory, ScheduledExecutorService scheduler, String downloadPrefix, CategoryManager categoryManager, ActivationManager activationManager) {
        this.lwsManager = lwsManager;
        this.downloadServices = downloadServices;
        this.lwsIntegrationServicesDelegate = lwsIntegrationServicesDelegate;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.scheduler = scheduler;
        this.downloadPrefix = downloadPrefix;
        this.categoryManager = categoryManager;
        this.activationManager = activationManager;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("LimeWire Store Integration");
    }

    @Override
    public void start() {
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                if (LWSIntegrationServicesImpl.this.lastTimeWeCalledGetDownloadProgress == -1L || now - LWSIntegrationServicesImpl.this.lastTimeWeCalledGetDownloadProgress < 300000L) {
                    LWSIntegrationServicesImpl.this.getDownloadProgress();
                }
            }
        }, 300000L, 300000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
    }

    @Override
    public void setDownloadPrefix(String downloadPrefix) {
        this.downloadPrefix = downloadPrefix;
    }

    public RemoteFileDesc createRemoteFileDescriptor(String fileName, String urlString, long length) throws IOException, URISyntaxException, HttpException, InterruptedException {
        URL url = new URL("http://" + this.downloadPrefix + urlString);
        if (fileName == null) {
            fileName = this.fileNameFromURL(urlString);
        }
        RemoteFileDesc rfd = this.remoteFileDescFactory.createUrlRemoteFileDesc(url, fileName, null, length);
        rfd.setHTTP11(false);
        return rfd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Downloader createDownloader(RemoteFileDesc rfd, File saveDir) throws DownloadException {
        String fileName = rfd.getFileName();
        final AtomicReference<Downloader> downloader = new AtomicReference<Downloader>();
        LWSIntegrationServicesDelegate lWSIntegrationServicesDelegate = this.lwsIntegrationServicesDelegate;
        synchronized (lWSIntegrationServicesDelegate) {
            final File saveFile = new File(saveDir, fileName);
            this.lwsIntegrationServicesDelegate.visitDownloads(new Visitor<CoreDownloader>(){

                @Override
                public boolean visit(CoreDownloader d) {
                    if (d.conflictsSaveFile(saveFile)) {
                        downloader.set(d);
                        return false;
                    }
                    return true;
                }
            });
        }
        if (downloader.get() == null) {
            downloader.set(this.downloadServices.downloadFromStore(rfd, true, saveDir, fileName));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Have downloader " + downloader.toString());
        }
        return (Downloader)downloader.get();
    }

    @Override
    public void initialize() {
        this.lwsManager.registerHandler("GetDownloadProgress", new LWSManagerCommandResponseHandlerWithCallback("GetDownloadProgress"){

            @Override
            protected String handleRest(Map<String, String> args) {
                return LWSIntegrationServicesImpl.this.getDownloadProgress();
            }
        });
        this.lwsManager.registerHandler("Download", new LWSManagerCommandResponseHandlerWithCallback("Download"){

            @Override
            protected String handleRest(Map<String, String> args) {
                Tagged<String> idOfTheProgressBarString;
                Tagged<String> urlString = LWSUtil.getArg(args, "url", "downloading");
                if (!urlString.isValid()) {
                    return urlString.getValue();
                }
                Tagged<String> fileString = LWSUtil.getArg(args, "file", "downloading");
                if (!fileString.isValid()) {
                    LOG.info("no file name given to downloader...");
                }
                if (!(idOfTheProgressBarString = LWSUtil.getArg(args, "id", "downloading")).isValid()) {
                    return idOfTheProgressBarString.getValue();
                }
                Tagged<String> lengthString = LWSUtil.getArg(args, "length", "downloading");
                long length = -1L;
                if (lengthString.isValid()) {
                    try {
                        length = Long.parseLong(lengthString.getValue());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                try {
                    Category category = LWSIntegrationServicesImpl.this.categoryManager.getCategoryForFilename(fileString.getValue());
                    File saveDir = SharingSettings.getSaveDirectory(category);
                    RemoteFileDesc rfd = LWSIntegrationServicesImpl.this.createRemoteFileDescriptor(fileString.getValue(), urlString.getValue(), length);
                    Downloader theDownloader = LWSIntegrationServicesImpl.this.createDownloader(rfd, saveDir);
                    long idOfTheDownloader = System.identityHashCode(theDownloader);
                    LWSIntegrationServicesImpl.this.downloaderIDs2progressBarIDs.put(String.valueOf(idOfTheDownloader), idOfTheProgressBarString.getValue());
                    return idOfTheDownloader + " " + idOfTheProgressBarString.getValue();
                }
                catch (IOException e) {
                }
                catch (HttpException e) {
                }
                catch (InterruptedException e) {
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                return "invalid.download";
            }
        });
        this.lwsManager.registerHandler("PauseDownload", new LWSManagerCommandResponseForDownloading("PauseDownload", this.lwsIntegrationServicesDelegate){

            @Override
            protected void takeAction(Downloader d) {
                d.pause();
            }
        });
        this.lwsManager.registerHandler("StopDownload", new LWSManagerCommandResponseForDownloading("StopDownload", this.lwsIntegrationServicesDelegate){

            @Override
            protected void takeAction(Downloader d) {
                d.stop();
            }
        });
        this.lwsManager.registerHandler("ResumeDownload", new LWSManagerCommandResponseForDownloading("ResumeDownload", this.lwsIntegrationServicesDelegate){

            @Override
            protected void takeAction(Downloader d) {
                d.resume();
            }
        });
        this.lwsManager.registerHandler("PauseAllDownloads", new LWSManagerCommandResponseForDownloadingAll("PauseAllDownloads", this.lwsIntegrationServicesDelegate){

            @Override
            protected void takeAction(Downloader d) {
                d.pause();
            }
        });
        this.lwsManager.registerHandler("StopAllDownloads", new LWSManagerCommandResponseForDownloadingAll("StopAllDownloads", this.lwsIntegrationServicesDelegate){

            @Override
            protected void takeAction(Downloader d) {
                d.stop();
            }
        });
        this.lwsManager.registerHandler("ResumeAllDownloads", new LWSManagerCommandResponseForDownloadingAll("ResumeAllDownloads", this.lwsIntegrationServicesDelegate){

            @Override
            protected void takeAction(Downloader d) {
                d.resume();
            }
        });
        this.lwsManager.registerHandler("GetInfo", new LWSManagerCommandResponseHandlerWithCallback("GetInfo"){

            private void add(StringBuilder b, String name, Object value) {
                b.append(name);
                b.append('=');
                b.append(value);
                b.append('\t');
            }

            @Override
            protected String handleRest(Map<String, String> args) {
                StringBuilder res = new StringBuilder();
                this.add(res, "version", LimeWireUtils.getLimeWireVersion());
                this.add(res, "major.version.number", LimeWireUtils.getMajorVersionNumber());
                this.add(res, "minor.version.number", LimeWireUtils.getMinorVersionNumber());
                this.add(res, "vendor", LimeWireUtils.getVendor());
                this.add(res, "service.version.number", LimeWireUtils.getServiceVersionNumber());
                this.add(res, "is.alpha.release", LimeWireUtils.isAlphaRelease());
                this.add(res, "is.beta.release", LimeWireUtils.isBetaRelease());
                this.add(res, "is.pro", LWSIntegrationServicesImpl.this.activationManager.isProActive());
                this.add(res, "is.testing.version", LimeWireUtils.isTestingVersion());
                return res.toString();
            }
        });
    }

    private String fileNameFromURL(String urlString) {
        int ilast = urlString.lastIndexOf("/");
        if (ilast == -1) {
            ilast = urlString.lastIndexOf("\\");
        }
        return urlString.substring(ilast + 1);
    }

    private synchronized String getDownloadProgress() {
        this.lastTimeWeCalledGetDownloadProgress = System.currentTimeMillis();
        final StringBuilder res = new StringBuilder();
        final HashSet activeDownloaderIDS = new HashSet();
        this.lwsIntegrationServicesDelegate.visitDownloads(new Visitor<CoreDownloader>(){

            @Override
            public boolean visit(CoreDownloader d) {
                if (d == null) {
                    return true;
                }
                if (!(d instanceof StoreDownloader)) {
                    return true;
                }
                String id = String.valueOf(System.identityHashCode(d));
                if (!LWSIntegrationServicesImpl.this.everActiveDownloaderIDs2Downloaders.containsKey(id)) {
                    LWSIntegrationServicesImpl.this.everActiveDownloaderIDs2Downloaders.put(id, d);
                }
                activeDownloaderIDS.add(id);
                LWSIntegrationServicesImpl.this.recordProgress(d, res, id);
                return true;
            }
        });
        ArrayList<String> idsToRemove = new ArrayList<String>();
        for (String downloaderID : this.everActiveDownloaderIDs2Downloaders.keySet()) {
            Downloader d = this.everActiveDownloaderIDs2Downloaders.get(downloaderID);
            if (activeDownloaderIDS.contains(downloaderID)) continue;
            this.recordProgress(d, res, downloaderID);
            idsToRemove.add(downloaderID);
        }
        for (String idToRemove : idsToRemove) {
            this.everActiveDownloaderIDs2Downloaders.remove(idToRemove);
            this.downloaderIDs2progressBarIDs.remove(idToRemove);
        }
        return res.toString();
    }

    private void recordProgress(Downloader d, StringBuilder res, String id) {
        String ratio = String.valueOf((float)d.getAmountRead() / (float)d.getContentLength());
        String progressBarID = this.downloaderIDs2progressBarIDs.get(id);
        String stateName = this.downloadStateName.get((Object)d.getState());
        res.append(id).append(" ").append(progressBarID).append(" ").append(ratio).append(":").append(stateName).append("|");
    }

    private abstract class LWSManagerCommandResponseForDownloadingAll
    extends LWSManagerCommandResponseHandlerWithCallback {
        private final LWSIntegrationServicesDelegate del;

        LWSManagerCommandResponseForDownloadingAll(String name, LWSIntegrationServicesDelegate del) {
            super(name);
            this.del = del;
        }

        protected abstract void takeAction(Downloader var1);

        @Override
        protected final String handleRest(Map<String, String> args) {
            final StringBuffer res = new StringBuffer();
            final ArrayList downloadersToAffect = new ArrayList();
            this.del.visitDownloads(new Visitor<CoreDownloader>(){

                @Override
                public boolean visit(CoreDownloader d) {
                    String hash = String.valueOf(System.identityHashCode(d));
                    if (LWSIntegrationServicesImpl.this.downloaderIDs2progressBarIDs.containsKey(hash)) {
                        downloadersToAffect.add(d);
                        if (res.length() > 0) {
                            res.append(" ");
                        }
                        res.append(hash);
                    }
                    return true;
                }
            });
            for (int i = 0; i < downloadersToAffect.size(); ++i) {
                this.takeAction((Downloader)downloadersToAffect.get(i));
            }
            return res.toString();
        }
    }

    private abstract class LWSManagerCommandResponseForDownloading
    extends LWSManagerCommandResponseHandlerWithCallback {
        private final LWSIntegrationServicesDelegate del;

        LWSManagerCommandResponseForDownloading(String name, LWSIntegrationServicesDelegate del) {
            super(name);
            this.del = del;
        }

        protected abstract void takeAction(Downloader var1);

        @Override
        protected final String handleRest(Map<String, String> args) {
            Tagged<String> idOfTheDownloader = LWSUtil.getArg(args, "id", "downloading");
            if (!idOfTheDownloader.isValid()) {
                return idOfTheDownloader.getValue();
            }
            final String id = idOfTheDownloader.getValue();
            final AtomicReference<String> res = new AtomicReference<String>("OK");
            this.del.visitDownloads(new Visitor<CoreDownloader>(){

                @Override
                public boolean visit(CoreDownloader d) {
                    String hash = String.valueOf(System.identityHashCode(d));
                    if (hash.equals(id)) {
                        LWSManagerCommandResponseForDownloading.this.takeAction(d);
                        res.set(hash);
                        return false;
                    }
                    return true;
                }
            });
            return res.get();
        }
    }
}

