/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.PropertyAccessor;
import com.jgoodies.binding.beans.PropertyException;

public final class PropertyAccessException
extends PropertyException {
    public PropertyAccessException(String message, Throwable cause) {
        super(message, cause);
    }

    public static PropertyAccessException createReadAccessException(Object bean, PropertyAccessor propertyAccessor, Throwable cause) {
        String beanType = bean == null ? null : bean.getClass().getName();
        String message = "Failed to read an adapted Java Bean property.\ncause=" + cause + "\nbean=" + bean + "\nbean type=" + beanType + "\nproperty name=" + propertyAccessor.getPropertyName() + "\nproperty type=" + propertyAccessor.getPropertyType().getName() + "\nproperty reader=" + propertyAccessor.getReadMethod();
        return new PropertyAccessException(message, cause);
    }

    public static PropertyAccessException createWriteAccessException(Object bean, Object value, PropertyAccessor propertyAccessor, Throwable cause) {
        String beanType = bean == null ? null : bean.getClass().getName();
        String valueType = value == null ? null : value.getClass().getName();
        String message = "Failed to set an adapted Java Bean property.\ncause=" + cause + "\nbean=" + bean + "\nbean type=" + beanType + "\nvalue=" + value + "\nvalue type=" + valueType + "\nproperty name=" + propertyAccessor.getPropertyName() + "\nproperty type=" + propertyAccessor.getPropertyType().getName() + "\nproperty setter=" + propertyAccessor.getWriteMethod();
        return new PropertyAccessException(message, cause);
    }
}

