/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import jlibs.core.io.ByteArrayOutputStream2;
import jlibs.core.lang.ImpossibleException;

public class Util {
    public static <T> T notNull(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.getClass().isArray()) {
            if (obj2.getClass().isArray()) {
                if (obj1 instanceof Object[] && obj2 instanceof Object[]) {
                    return Arrays.deepEquals((Object[])obj1, (Object[])obj2);
                }
                if (obj1 instanceof boolean[] && obj2 instanceof boolean[]) {
                    return Arrays.equals((boolean[])obj1, (boolean[])obj2);
                }
                if (obj1 instanceof char[] && obj2 instanceof char[]) {
                    return Arrays.equals((char[])obj1, (char[])obj2);
                }
                if (obj1 instanceof byte[] && obj2 instanceof byte[]) {
                    return Arrays.equals((byte[])obj1, (byte[])obj2);
                }
                if (obj1 instanceof short[] && obj2 instanceof short[]) {
                    return Arrays.equals((short[])obj1, (short[])obj2);
                }
                if (obj1 instanceof int[] && obj2 instanceof int[]) {
                    return Arrays.equals((int[])obj1, (int[])obj2);
                }
                if (obj1 instanceof long[] && obj2 instanceof long[]) {
                    return Arrays.equals((long[])obj1, (long[])obj2);
                }
                if (obj1 instanceof float[] && obj2 instanceof float[]) {
                    return Arrays.equals((float[])obj1, (float[])obj2);
                }
                if (obj1 instanceof double[] && obj2 instanceof double[]) {
                    return Arrays.equals((double[])obj1, (double[])obj2);
                }
                throw new ImpossibleException("couldn't do equals for" + obj1.getClass().getComponentType().getSimpleName() + "[]");
            }
            return false;
        }
        return obj1.equals(obj2);
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Arrays.deepHashCode((Object[])obj);
            }
            if (obj instanceof boolean[]) {
                return Arrays.hashCode((boolean[])obj);
            }
            if (obj instanceof char[]) {
                return Arrays.hashCode((char[])obj);
            }
            if (obj instanceof byte[]) {
                return Arrays.hashCode((byte[])obj);
            }
            if (obj instanceof short[]) {
                return Arrays.hashCode((short[])obj);
            }
            if (obj instanceof int[]) {
                return Arrays.hashCode((int[])obj);
            }
            if (obj instanceof long[]) {
                return Arrays.hashCode((long[])obj);
            }
            if (obj instanceof float[]) {
                return Arrays.hashCode((float[])obj);
            }
            if (obj instanceof double[]) {
                return Arrays.hashCode((double[])obj);
            }
            throw new ImpossibleException("couldn't find hascode for" + obj.getClass().getComponentType().getSimpleName() + "[]");
        }
        return obj.hashCode();
    }

    public static int hashCode(Object ... objects) {
        int hashCode = 0;
        for (Object obj : objects) {
            hashCode = 31 * hashCode + Util.hashCode(obj);
        }
        return hashCode;
    }

    public static <T> T clone(T obj) throws CloneNotSupportedException {
        if (obj == null) {
            return null;
        }
        try {
            if (obj instanceof Cloneable) {
                Method method = obj.getClass().getMethod("clone", new Class[0]);
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                return (T)method.invoke(obj, new Object[0]);
            }
            if (obj instanceof Serializable) {
                ByteArrayOutputStream2 bout = new ByteArrayOutputStream2();
                ObjectOutputStream objOut = new ObjectOutputStream(bout);
                objOut.writeObject(obj);
                objOut.close();
                ObjectInputStream objIn = new ObjectInputStream(bout.toByteSequence().asInputStream());
                return (T)objIn.readObject();
            }
            throw new CloneNotSupportedException(obj.getClass().getName());
        }
        catch (Exception ex) {
            if (ex instanceof CloneNotSupportedException) {
                throw (CloneNotSupportedException)ex;
            }
            throw (CloneNotSupportedException)new CloneNotSupportedException().initCause(ex);
        }
    }
}

