/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.BaseSliderUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class FastSliderUI
extends BaseSliderUI {
    private static ThumbHorIcon thumbHorIcon = new ThumbHorIcon();
    private static ThumbVerIcon thumbVerIcon = new ThumbVerIcon();

    public FastSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new FastSliderUI((JSlider)jComponent);
    }

    public Icon getThumbHorIcon() {
        return thumbHorIcon;
    }

    public Icon getThumbHorIconRollover() {
        return thumbHorIcon;
    }

    public Icon getThumbVerIcon() {
        return thumbVerIcon;
    }

    public Icon getThumbVerIconRollover() {
        return thumbVerIcon;
    }

    public void paintTrack(Graphics graphics) {
        boolean bl = JTattooUtilities.isLeftToRight(this.slider);
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n = 5;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.slider.getOrientation() == 0) {
            n5 = this.trackRect.height - 1 - n;
            n3 = n5 - (this.getTrackWidth() - 1);
            n4 = this.trackRect.width - 1;
        } else {
            if (bl) {
                n2 = this.trackRect.width - n - this.getTrackWidth();
                n4 = this.trackRect.width - n - 1;
            } else {
                n2 = n;
                n4 = n + this.getTrackWidth() - 1;
            }
            n5 = this.trackRect.height - 1;
        }
        graphics.setColor(Color.gray);
        graphics.drawRect(n2, n3, n4 - n2 - 1, n5 - n3 - 1);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (this.slider.getOrientation() == 0) {
            n6 = this.thumbRect.x + this.thumbRect.width / 2;
            n6 -= this.trackRect.x;
            n7 = n3 + 1;
            n9 = n5 - 2;
            if (!this.drawInverted()) {
                n8 = n2 + 1;
                n10 = n6;
            } else {
                n8 = n6;
                n10 = n4 - 2;
            }
            graphics.setColor(FastLookAndFeel.getControlBackgroundColor());
            graphics.fillRect(n8, n7, n10 - n8, n9 - n7 + 1);
        } else {
            n6 = this.thumbRect.y + this.thumbRect.height / 2;
            n6 -= this.trackRect.y;
            n8 = n2 + 1;
            n10 = n4 - 2;
            if (!this.drawInverted()) {
                n7 = n6;
                n9 = n5 - 2;
            } else {
                n7 = n3 + 1;
                n9 = n6;
            }
            graphics.setColor(FastLookAndFeel.getControlBackgroundColor());
            graphics.fillRect(n8, n7, n10 - n8 + 1, n9 - n7 + 1);
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    private static class ThumbVerIcon
    implements Icon {
        private static final int WIDTH = 18;
        private static final int HEIGHT = 11;

        private ThumbVerIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = 17;
            int n4 = 10;
            int n5 = 5;
            ColorUIResource colorUIResource = FastLookAndFeel.getControlBackgroundColor();
            ColorUIResource colorUIResource2 = FastLookAndFeel.getFrameColor();
            Color color = ColorHelper.brighter(colorUIResource, 40.0);
            Polygon polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3 - n5, n2);
            polygon.addPoint(n + n3, n2 + n5);
            polygon.addPoint(n + n3 - n5, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            graphics.setColor(colorUIResource);
            graphics.fillPolygon(polygon);
            graphics.setColor(colorUIResource2);
            graphics.drawPolygon(polygon);
            graphics.setColor(color);
            graphics.drawLine(n + 1, n2 + 1, n + n3 - n5, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 1);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 11;
        }
    }

    private static class ThumbHorIcon
    implements Icon {
        private static final int WIDTH = 11;
        private static final int HEIGHT = 18;

        private ThumbHorIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = 10;
            int n4 = 17;
            int n5 = 5;
            ColorUIResource colorUIResource = FastLookAndFeel.getControlBackgroundColor();
            ColorUIResource colorUIResource2 = FastLookAndFeel.getFrameColor();
            Color color = ColorHelper.brighter(colorUIResource, 40.0);
            Polygon polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4 - n5);
            polygon.addPoint(n + n5, n2 + n4);
            polygon.addPoint(n, n2 + n4 - n5);
            graphics.setColor(colorUIResource);
            graphics.fillPolygon(polygon);
            graphics.setColor(colorUIResource2);
            graphics.drawPolygon(polygon);
            graphics.setColor(color);
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 1, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - n5);
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 18;
        }
    }
}

