/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import com.jtattoo.plaf.fast.FastScrollButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class FastScrollBarUI
extends BaseScrollBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new FastScrollBarUI();
    }

    protected JButton createDecreaseButton(int n) {
        return new FastScrollButton(n, this.scrollBarWidth);
    }

    protected JButton createIncreaseButton(int n) {
        return new FastScrollButton(n, this.scrollBarWidth);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(FastLookAndFeel.getControlColorLight());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        Color color = FastLookAndFeel.getTheme().getControlBackgroundColor();
        if (!JTattooUtilities.isActive(jComponent)) {
            color = ColorHelper.brighter(color, 50.0);
        }
        Color color2 = ColorHelper.brighter(color, 40.0);
        Color color3 = ColorHelper.darker(color, 30.0);
        graphics.setColor(color);
        graphics.fillRect(1, 1, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(color3);
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(color2);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        graphics.translate(-rectangle.x, -rectangle.y);
    }
}

