/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.session;

import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSessionConfig;

public abstract class AbstractIoSessionConfig
implements IoSessionConfig {
    private int minReadBufferSize = 64;
    private int readBufferSize = 2048;
    private int maxReadBufferSize = 65536;
    private int idleTimeForRead;
    private int idleTimeForWrite;
    private int idleTimeForBoth;
    private int writeTimeout = 60;
    private boolean useReadOperation;
    private int throughputCalculationInterval = 3;

    protected AbstractIoSessionConfig() {
    }

    public final void setAll(IoSessionConfig ioSessionConfig) {
        if (ioSessionConfig == null) {
            throw new IllegalArgumentException("config");
        }
        this.setReadBufferSize(ioSessionConfig.getReadBufferSize());
        this.setMinReadBufferSize(ioSessionConfig.getMinReadBufferSize());
        this.setMaxReadBufferSize(ioSessionConfig.getMaxReadBufferSize());
        this.setIdleTime(IdleStatus.BOTH_IDLE, ioSessionConfig.getIdleTime(IdleStatus.BOTH_IDLE));
        this.setIdleTime(IdleStatus.READER_IDLE, ioSessionConfig.getIdleTime(IdleStatus.READER_IDLE));
        this.setIdleTime(IdleStatus.WRITER_IDLE, ioSessionConfig.getIdleTime(IdleStatus.WRITER_IDLE));
        this.setWriteTimeout(ioSessionConfig.getWriteTimeout());
        this.setUseReadOperation(ioSessionConfig.isUseReadOperation());
        this.setThroughputCalculationInterval(ioSessionConfig.getThroughputCalculationInterval());
        this.doSetAll(ioSessionConfig);
    }

    protected abstract void doSetAll(IoSessionConfig var1);

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("readBufferSize: " + n + " (expected: 1+)");
        }
        this.readBufferSize = n;
    }

    public int getMinReadBufferSize() {
        return this.minReadBufferSize;
    }

    public void setMinReadBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("minReadBufferSize: " + n + " (expected: 1+)");
        }
        if (n > this.maxReadBufferSize) {
            throw new IllegalArgumentException("minReadBufferSize: " + n + " (expected: smaller than " + this.maxReadBufferSize + ')');
        }
        this.minReadBufferSize = n;
    }

    public int getMaxReadBufferSize() {
        return this.maxReadBufferSize;
    }

    public void setMaxReadBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxReadBufferSize: " + n + " (expected: 1+)");
        }
        if (n < this.minReadBufferSize) {
            throw new IllegalArgumentException("maxReadBufferSize: " + n + " (expected: greater than " + this.minReadBufferSize + ')');
        }
        this.maxReadBufferSize = n;
    }

    public int getIdleTime(IdleStatus idleStatus) {
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            return this.idleTimeForBoth;
        }
        if (idleStatus == IdleStatus.READER_IDLE) {
            return this.idleTimeForRead;
        }
        if (idleStatus == IdleStatus.WRITER_IDLE) {
            return this.idleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
    }

    public long getIdleTimeInMillis(IdleStatus idleStatus) {
        return (long)this.getIdleTime(idleStatus) * 1000L;
    }

    public void setIdleTime(IdleStatus idleStatus, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal idle time: " + n);
        }
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            this.idleTimeForBoth = n;
        } else if (idleStatus == IdleStatus.READER_IDLE) {
            this.idleTimeForRead = n;
        } else if (idleStatus == IdleStatus.WRITER_IDLE) {
            this.idleTimeForWrite = n;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
        }
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public long getWriteTimeoutInMillis() {
        return (long)this.writeTimeout * 1000L;
    }

    public void setWriteTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal write timeout: " + n);
        }
        this.writeTimeout = n;
    }

    public boolean isUseReadOperation() {
        return this.useReadOperation;
    }

    public void setUseReadOperation(boolean bl) {
        this.useReadOperation = bl;
    }

    public int getThroughputCalculationInterval() {
        return this.throughputCalculationInterval;
    }

    public void setThroughputCalculationInterval(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("throughputCalculationInterval: " + n);
        }
        this.throughputCalculationInterval = n;
    }
}

