/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.exchange.XMLStreamUtil;
import davmail.exchange.ews.EWSMethod;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class GetUserPhotoMethod
extends EWSMethod {
    protected String email;
    protected SizeRequested sizeRequested;
    protected String contentType = null;
    protected String pictureData = null;

    public GetUserPhotoMethod(String email, SizeRequested sizeRequested) {
        super("GetUserPhoto", "GetUserPhoto");
        this.email = email;
        this.sizeRequested = sizeRequested;
    }

    @Override
    protected void writeSoapBody(Writer writer) throws IOException {
        writer.write("<m:Email>");
        writer.write(this.email);
        writer.write("</m:Email>");
        writer.write("<m:SizeRequested>");
        writer.write(this.sizeRequested.toString());
        writer.write("</m:SizeRequested>");
    }

    @Override
    protected void handleCustom(XMLStreamReader reader) throws XMLStreamException {
        if (XMLStreamUtil.isStartTag(reader, "PictureData")) {
            this.pictureData = reader.getElementText();
            if (this.pictureData.isEmpty()) {
                this.pictureData = null;
            }
        }
        if (XMLStreamUtil.isStartTag(reader, "ContentType")) {
            this.contentType = reader.getElementText();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getPictureData() {
        return this.pictureData;
    }

    public static enum SizeRequested {
        HR48x48,
        HR64x64,
        HR96x96,
        HR120x120,
        HR240x240,
        HR360x360,
        HR432x432,
        HR504x504,
        HR648x648;

    }
}

