/*
 * Decompiled with CFR 0.152.
 */
public class DMatrix {
    public int rows;
    public int columns;
    private int rowsMax;
    private int columnsMax;
    public double[][] m;

    public DMatrix(int rMax, int cMax) {
        this.m = new double[rMax][cMax];
        this.rowsMax = rMax;
        this.columnsMax = cMax;
        this.rows = 0;
        this.columns = 0;
    }

    public DMatrix(float[][] fm) {
        if (fm == null) {
            this.rowsMax = 0;
            this.columnsMax = 0;
            this.m = null;
            this.rows = this.rowsMax;
            this.columns = this.columnsMax;
        } else {
            this.rowsMax = fm.length;
            this.columnsMax = fm[0].length;
            this.m = new double[this.rowsMax][this.columnsMax];
            int i = 0;
            while (i < this.rowsMax) {
                int j = 0;
                while (j < this.columnsMax) {
                    this.m[i][j] = fm[i][j];
                    ++j;
                }
                ++i;
            }
            this.rows = this.rowsMax;
            this.columns = this.columnsMax;
        }
    }

    public DMatrix(double[][] dm) {
        if (dm == null) {
            this.rowsMax = 0;
            this.columnsMax = 0;
            this.m = null;
            this.rows = this.rowsMax;
            this.columns = this.columnsMax;
        } else {
            this.rowsMax = dm.length;
            this.columnsMax = dm[0].length;
            this.m = new double[this.rowsMax][this.columnsMax];
            int i = 0;
            while (i < this.rowsMax) {
                int j = 0;
                while (j < this.columnsMax) {
                    this.m[i][j] = dm[i][j];
                    ++j;
                }
                ++i;
            }
            this.rows = this.rowsMax;
            this.columns = this.columnsMax;
        }
    }

    public static DMatrix MMultiply(DMatrix A, DMatrix B) {
        if (A.columns != B.rows) {
            return null;
        }
        DMatrix C = new DMatrix(A.rows, B.columns);
        C.set(A.rows, B.columns);
        int i = 0;
        while (i < A.rows) {
            int j = 0;
            while (j < B.columns) {
                int k = 0;
                double element = 0.0;
                while (k < B.rows) {
                    element += A.m[i][k] * B.m[k][j];
                    ++k;
                }
                C.m[i][j] = element;
                ++j;
            }
            ++i;
        }
        return C;
    }

    public static DMatrix MMultiplyAtB(DMatrix A, DMatrix B) {
        if (A.rows != B.rows) {
            return null;
        }
        DMatrix C = new DMatrix(A.columns, B.columns);
        C.set(A.columns, B.columns);
        int i = 0;
        while (i < A.columns) {
            int j = 0;
            while (j < B.columns) {
                int k = 0;
                double element = 0.0;
                while (k < B.rows) {
                    element += A.m[k][i] * B.m[k][j];
                    ++k;
                }
                C.m[i][j] = element;
                ++j;
            }
            ++i;
        }
        return C;
    }

    public static DMatrix MMultiplyABt(DMatrix A, DMatrix B) {
        if (A.columns != B.columns) {
            return null;
        }
        DMatrix C = new DMatrix(A.rows, B.rows);
        C.set(A.rows, B.rows);
        int i = 0;
        while (i < A.rows) {
            int j = 0;
            while (j < B.rows) {
                int k = 0;
                double element = 0.0;
                while (k < B.columns) {
                    element += A.m[i][k] * B.m[j][k];
                    ++k;
                }
                C.m[i][j] = element;
                ++j;
            }
            ++i;
        }
        return C;
    }

    public static boolean invert(DMatrix a, int n) {
        int l;
        double temp;
        int k;
        int icol = 0;
        int irow = 0;
        if (n > a.rows || n > a.columns || n <= 0) {
            return false;
        }
        int[] indxc = new int[n];
        int[] indxr = new int[n];
        int[] ipiv = new int[n];
        int j = 0;
        while (j < n) {
            ipiv[j] = 0;
            ++j;
        }
        int i = 0;
        while (i < n) {
            double big = 0.0;
            j = 0;
            while (j < n) {
                if (ipiv[j] != 1) {
                    k = 0;
                    while (k < n) {
                        if (ipiv[k] == 0) {
                            double d;
                            temp = Math.abs(a.m[j][k]);
                            if (d >= big) {
                                big = temp;
                                irow = j;
                                icol = k;
                            }
                        } else if (ipiv[k] > 1) {
                            return false;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                l = 0;
                while (l < n) {
                    temp = a.m[irow][l];
                    a.m[irow][l] = a.m[icol][l];
                    a.m[icol][l] = temp;
                    ++l;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a.m[icol][icol] == 0.0) {
                return false;
            }
            double pivinv = 1.0 / a.m[icol][icol];
            a.m[icol][icol] = 1.0;
            l = 0;
            while (l < n) {
                double[] dArray = a.m[icol];
                int n3 = l++;
                dArray[n3] = dArray[n3] * pivinv;
            }
            int ll = 0;
            while (ll < n) {
                if (ll != icol) {
                    double dum = a.m[ll][icol];
                    a.m[ll][icol] = 0.0;
                    l = 0;
                    while (l < n) {
                        double[] dArray = a.m[ll];
                        int n4 = l;
                        dArray[n4] = dArray[n4] - a.m[icol][l] * dum;
                        ++l;
                    }
                }
                ++ll;
            }
            ++i;
        }
        l = n - 1;
        while (l >= 0) {
            if (indxr[l] != indxc[l]) {
                k = 0;
                while (k < n) {
                    temp = a.m[k][indxr[l]];
                    a.m[k][indxr[l]] = a.m[k][indxc[l]];
                    a.m[k][indxc[l]] = temp;
                    ++k;
                }
            }
            --l;
        }
        return true;
    }

    public int getRows() {
        return this.rowsMax;
    }

    public int getColumns() {
        return this.columnsMax;
    }

    public void set(int rows, int columns) {
        if (rows >= 0 && rows <= this.rowsMax) {
            this.rows = rows;
        }
        if (columns >= 0 && columns <= this.columnsMax) {
            this.columns = columns;
        }
    }
}

