/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.expression;

import org.snpeff.vcf.VcfEntry;
import org.snpsift.lang.Value;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.ExpressionBinary;

public class Or
extends ExpressionBinary {
    public Or(Expression left, Expression right) {
        super(left, right, "|");
    }

    @Override
    public Value eval(VcfEntry vcfEntry) {
        Value lval = this.left.eval(vcfEntry);
        if (lval.isBool() && lval.asBool()) {
            return Value.TRUE;
        }
        Value rval = this.right != null ? this.right.eval(vcfEntry) : null;
        return this.evalOp(lval, rval);
    }

    @Override
    protected Value evalOp(Value lval, Value rval) {
        if (lval.isBool() && rval.isBool()) {
            return new Value(lval.asBool() || rval.asBool());
        }
        if (lval.canBeInt() && rval.canBeInt()) {
            return new Value(lval.asInt() | rval.asInt());
        }
        throw new RuntimeException("Cannot peroform '|' between " + (Object)((Object)lval.type()) + " and " + (Object)((Object)rval.type()));
    }
}

