/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffects;

public class Regulation
extends Marker {
    private static final long serialVersionUID = -5607588295343642199L;
    String regulationType = "";
    String name = "";

    public Regulation() {
        this.type = EffectType.REGULATION;
    }

    public Regulation(Marker parent, int start, int end, boolean strandMinus, String id, String name, String regulationType) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.REGULATION;
        this.name = name;
        this.regulationType = regulationType;
    }

    @Override
    public Regulation cloneShallow() {
        Regulation clone2 = (Regulation)super.cloneShallow();
        clone2.regulationType = this.regulationType;
        clone2.name = this.name;
        return clone2;
    }

    public String getName() {
        return this.name;
    }

    public String getRegulationType() {
        return this.regulationType;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.regulationType = markerSerializer.getNextField();
        this.name = markerSerializer.getNextField();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.regulationType + "\t" + this.name;
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + "\t" + this.start + "-" + this.end + " " + (Object)((Object)this.type) + (this.name != null && !this.name.isEmpty() ? " '" + this.name + "'" : "");
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        EffectType effType = EffectType.REGULATION;
        variantEffects.add(variant, this, effType, "");
        return true;
    }
}

