/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.biojava3.core.sequence.io.util.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLHelper {
    public static Element addChildElement(Element parentElement, String elementName) {
        Element childElement = parentElement.getOwnerDocument().createElement(elementName);
        parentElement.appendChild(childElement);
        return childElement;
    }

    public static Document getNewDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static Document loadXML(String fileName) throws Exception {
        InputStream is = IOUtils.openFile(new File(fileName));
        Document doc = XMLHelper.inputStreamToDocument(new BufferedInputStream(is));
        IOUtils.close(is);
        return doc;
    }

    public static Document inputStreamToDocument(InputStream inputStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(inputStream);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static void outputToStream(Document document2, OutputStream outputStream) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document2);
        StreamResult result2 = new StreamResult(outputStream);
        transformer.transform(source, result2);
    }

    public static void outputToStream(Element document2, OutputStream outputStream) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document2);
        StreamResult result2 = new StreamResult(outputStream);
        transformer.transform(source, result2);
    }

    public static Element selectParentElement(Element element, String parentName) {
        Element parentElement = (Element)element.getParentNode();
        if (parentElement == null) {
            return null;
        }
        if (parentElement.getTagName().equals(parentName)) {
            return parentElement;
        }
        return XMLHelper.selectParentElement(parentElement, parentName);
    }

    public static Element selectSingleElement(Element element, String xpathExpression) throws Exception {
        if (xpathExpression.indexOf("/") == -1) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(xpathExpression)) continue;
                return (Element)node;
            }
            return null;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element node = (Element)xpath.evaluate(xpathExpression, element, XPathConstants.NODE);
        return node;
    }

    public static ArrayList<Element> selectElements(Element element, String xpathExpression) throws Exception {
        ArrayList<Element> resultVector = new ArrayList<Element>();
        if (element == null) {
            return resultVector;
        }
        if (xpathExpression.indexOf("/") == -1) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(xpathExpression)) continue;
                resultVector.add((Element)node);
            }
        } else {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(xpathExpression, element, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                resultVector.add((Element)node);
            }
        }
        return resultVector;
    }
}

