/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.views;

import java.util.HashMap;
import java.util.Map;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.compound.RNACompoundSet;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.ProxySequenceReader;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceProxyView;

public class RnaSequenceView
extends SequenceProxyView<NucleotideCompound>
implements ProxySequenceReader<NucleotideCompound> {
    private CompoundSet<NucleotideCompound> rnaCompounds;
    private Map<NucleotideCompound, NucleotideCompound> dnaToRna = null;
    private Map<NucleotideCompound, NucleotideCompound> rnaToDna = null;

    public RnaSequenceView(Sequence<NucleotideCompound> sourceDna) {
        this(sourceDna, RNACompoundSet.getRNACompoundSet());
    }

    public RnaSequenceView(Sequence<NucleotideCompound> sourceDna, CompoundSet<NucleotideCompound> rnaCompounds) {
        super(sourceDna);
        this.rnaCompounds = rnaCompounds;
    }

    @Override
    public String getSequenceAsString() {
        return SequenceMixin.toString(this);
    }

    @Override
    public NucleotideCompound getCompoundAt(int position) {
        NucleotideCompound dna = (NucleotideCompound)this.getViewedSequence().getCompoundAt(position);
        return this.getDnaToRna().get(dna);
    }

    @Override
    public int getIndexOf(NucleotideCompound compound) {
        return this.getViewedSequence().getIndexOf(this.getRnaToDna().get(compound));
    }

    @Override
    public int getLastIndexOf(NucleotideCompound compound) {
        return this.getViewedSequence().getLastIndexOf(this.getRnaToDna().get(compound));
    }

    public Map<NucleotideCompound, NucleotideCompound> getRnaToDna() {
        if (this.rnaToDna == null) {
            this.buildTranslators();
        }
        return this.rnaToDna;
    }

    public Map<NucleotideCompound, NucleotideCompound> getDnaToRna() {
        if (this.dnaToRna == null) {
            this.buildTranslators();
        }
        return this.dnaToRna;
    }

    protected void buildTranslators() {
        HashMap<NucleotideCompound, NucleotideCompound> localDnaToRna = new HashMap<NucleotideCompound, NucleotideCompound>();
        HashMap<NucleotideCompound, NucleotideCompound> localRnaToDna = new HashMap<NucleotideCompound, NucleotideCompound>();
        NucleotideCompound thymine = (NucleotideCompound)this.getViewedSequence().getCompoundSet().getCompoundForString("T");
        NucleotideCompound lowerThymine = (NucleotideCompound)this.getViewedSequence().getCompoundSet().getCompoundForString("t");
        for (NucleotideCompound dnaBase : this.getViewedSequence().getCompoundSet().getAllCompounds()) {
            NucleotideCompound equivalent = dnaBase.equals(thymine) ? this.rnaCompounds.getCompoundForString("U") : (dnaBase.equals(lowerThymine) ? this.rnaCompounds.getCompoundForString("u") : this.rnaCompounds.getCompoundForString(dnaBase.toString()));
            localDnaToRna.put(dnaBase, equivalent);
            localRnaToDna.put(equivalent, dnaBase);
        }
        this.dnaToRna = localDnaToRna;
        this.rnaToDna = localRnaToDna;
    }

    @Override
    public void setCompoundSet(CompoundSet<NucleotideCompound> compoundSet) {
        throw new UnsupportedOperationException("Unsupported operation; create a new viewed sequence");
    }

    @Override
    public void setContents(String sequence2) {
        throw new UnsupportedOperationException("Unsupported operation; create a new viewed sequence");
    }
}

