/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.snpeff.codons.CodonTable;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Custom;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Motif;
import org.snpeff.interval.NextProt;
import org.snpeff.interval.Regulation;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.TranscriptSupportLevel;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.HgvsDna;
import org.snpeff.snpEffect.HgvsProtein;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;

public class VariantEffect
implements Cloneable,
Comparable<VariantEffect> {
    public static final int MAX_CODON_SEQUENCE_LEN = 100;
    protected Variant variant;
    protected List<EffectType> effectTypes;
    protected EffectType effectType;
    protected List<EffectImpact> effectImpacts;
    protected EffectImpact effectImpact;
    protected Marker marker;
    protected String error = "";
    protected String warning = "";
    protected String message = "";
    protected String codonsRef = "";
    protected String codonsAlt = "";
    protected String codonsAroundOld = "";
    protected String codonsAroundNew = "";
    protected int distance = -1;
    protected int cDnaPos = -1;
    protected int codonNum = -1;
    protected int codonIndex = -1;
    protected int codonDegeneracy = -1;
    protected String aaRef = "";
    protected String aaAlt = "";
    protected String aasAroundOld = "";
    protected String aasAroundNew = "";

    public VariantEffect(Variant variant) {
        this.variant = variant;
        this.effectTypes = new ArrayList<EffectType>();
        this.effectImpacts = new ArrayList<EffectImpact>();
    }

    public VariantEffect(Variant variant, Marker marker, EffectType effectType, EffectImpact effectImpact, String codonsOld, String codonsNew, int codonNum, int codonIndex, int cDnaPos) {
        this.variant = variant;
        this.effectTypes = new ArrayList<EffectType>();
        this.effectImpacts = new ArrayList<EffectImpact>();
        this.set(marker, effectType, effectImpact, "");
        this.setCodons(codonsOld, codonsNew, codonNum, codonIndex);
        this.cDnaPos = cDnaPos;
    }

    public void addEffect(EffectType effectType) {
        this.addEffectType(effectType);
        this.addEffectImpact(effectType.effectImpact());
    }

    public void addEffectImpact(EffectImpact effectImpact) {
        this.effectImpacts.add(effectImpact);
        this.effectImpact = null;
    }

    public void addEffectType(EffectType effectType) {
        this.effectTypes.add(effectType);
        this.effectType = null;
    }

    public void addErrorMessage(ErrorWarningType errmsg) {
        this.addErrorWarningInfo(errmsg);
    }

    public void addErrorWarningInfo(ErrorWarningType errwarn) {
        if (errwarn == null) {
            return;
        }
        if (errwarn.isError()) {
            if (this.error.indexOf(errwarn.toString()) < 0) {
                this.error = this.error + (this.error.isEmpty() ? "" : "&") + (Object)((Object)errwarn);
            }
        } else if (this.warning.indexOf(errwarn.toString()) < 0) {
            this.warning = this.warning + (this.warning.isEmpty() ? "" : "&") + (Object)((Object)errwarn);
        }
    }

    public void addInfoMessage(ErrorWarningType infomsg) {
        this.addErrorWarningInfo(infomsg);
    }

    public void addWarningMessge(ErrorWarningType warnmsg) {
        this.addErrorWarningInfo(warnmsg);
    }

    public VariantEffect clone() {
        try {
            return (VariantEffect)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    String codonEffect(boolean showAaChange, boolean showBioType, boolean useSeqOntology, boolean useFirstEffect) {
        if (this.marker == null || this.codonNum < 0) {
            return "";
        }
        if (!showAaChange) {
            return this.getEffectTypeString(useSeqOntology, useFirstEffect);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEffectTypeString(useSeqOntology, useFirstEffect));
        sb.append("(");
        sb.append(this.getAaChange());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(VariantEffect varEffOther) {
        int comp = this.getEffectImpact().compareTo(varEffOther.getEffectImpact());
        if (comp != 0) {
            return comp;
        }
        comp = this.getEffectType().compareTo(varEffOther.getEffectType());
        if (comp != 0) {
            return comp;
        }
        Transcript trThis = this.getTranscript();
        Transcript trOther = varEffOther.getTranscript();
        int tslThis = 9;
        int canonThis = 0;
        int startThis = 0;
        int endThis = 0;
        String idThis = null;
        String chrThis = null;
        if (trThis != null) {
            tslThis = TranscriptSupportLevel.tsl(trThis.getTranscriptSupportLevel());
            canonThis = trThis.isCanonical() ? 1 : 0;
            idThis = trThis.getId();
            chrThis = trThis.getChromosomeName();
            startThis = trThis.getStart();
            endThis = trThis.getEnd();
        }
        int tslOther = 9;
        int canonOther = 0;
        int startOther = 0;
        int endOther = 0;
        String idOther = null;
        String chrOther = null;
        if (trOther != null) {
            tslOther = TranscriptSupportLevel.tsl(trOther.getTranscriptSupportLevel());
            canonOther = trOther.isCanonical() ? 1 : 0;
            idOther = trOther.getId();
            chrOther = trOther.getChromosomeName();
            startOther = trOther.getStart();
            endOther = trOther.getEnd();
        }
        if ((comp = tslThis - tslOther) != 0) {
            return comp;
        }
        comp = canonOther - canonThis;
        if (comp != 0) {
            return comp;
        }
        comp = Gpr.compareNull((Comparable)((Object)chrThis), (Comparable)((Object)chrOther));
        if (comp != 0) {
            return comp;
        }
        comp = startThis - startOther;
        if (comp != 0) {
            return comp;
        }
        comp = endThis - endOther;
        if (comp != 0) {
            return comp;
        }
        comp = Gpr.compareNull((Comparable)((Object)idThis), (Comparable)((Object)idOther));
        if (comp != 0) {
            return comp;
        }
        Marker mThis = this.getMarker();
        Marker mOther = varEffOther.getMarker();
        startThis = 0;
        endThis = 0;
        idThis = null;
        chrThis = null;
        if (mThis != null) {
            idThis = mThis.getId();
            chrThis = mThis.getChromosomeName();
            startThis = mThis.getStart();
            endThis = mThis.getEnd();
        }
        startOther = 0;
        endOther = 0;
        idOther = null;
        chrOther = null;
        if (mOther != null) {
            idOther = mOther.getId();
            chrOther = mOther.getChromosomeName();
            startOther = mOther.getStart();
            endOther = mOther.getEnd();
        }
        if ((comp = Gpr.compareNull((Comparable)((Object)chrThis), (Comparable)((Object)chrOther))) != 0) {
            return comp;
        }
        comp = startThis - startOther;
        if (comp != 0) {
            return comp;
        }
        comp = endThis - endOther;
        if (comp != 0) {
            return comp;
        }
        comp = Gpr.compareNull((Comparable)((Object)idThis), (Comparable)((Object)idOther));
        if (comp != 0) {
            return comp;
        }
        return this.variant.compareTo(varEffOther.getVariant());
    }

    public String effect(boolean shortFormat, boolean showAaChange, boolean showBioType, boolean useSeqOntology, boolean useFirstEffect) {
        String e = "";
        String codonEffect = this.codonEffect(showAaChange, showBioType, useSeqOntology, useFirstEffect);
        if (!codonEffect.isEmpty()) {
            e = codonEffect;
        } else {
            if (this.isRegulation()) {
                return this.getEffectTypeString(useSeqOntology, useFirstEffect) + "[" + ((Regulation)this.marker).getName() + "]";
            }
            if (this.isNextProt()) {
                return this.getEffectTypeString(useSeqOntology, useFirstEffect) + "[" + VcfEffect.vcfEffSafe(((NextProt)this.marker).getId()) + "]";
            }
            if (this.isMotif()) {
                return this.getEffectTypeString(useSeqOntology, useFirstEffect) + "[" + ((Motif)this.marker).getPwmId() + ":" + ((Motif)this.marker).getPwmName() + "]";
            }
            if (this.isCustom()) {
                String label = ((Custom)this.marker).getLabel();
                double score = ((Custom)this.marker).getScore();
                if (!Double.isNaN(score)) {
                    label = label + ":" + score;
                }
                if (!label.isEmpty()) {
                    label = "[" + label + "]";
                }
                return this.getEffectTypeString(useSeqOntology, useFirstEffect) + label;
            }
            e = this.isIntergenic() || this.isIntron() || this.isSpliceSite() ? this.getEffectTypeString(useSeqOntology, useFirstEffect) : (!this.message.isEmpty() ? this.getEffectTypeString(useSeqOntology, useFirstEffect) + ": " + this.message : (this.marker == null ? this.getEffectTypeString(useSeqOntology, useFirstEffect) : this.getEffectTypeString(useSeqOntology, useFirstEffect) + ": " + this.marker.getId()));
        }
        if (shortFormat) {
            e = e.split(":")[0];
        }
        return e;
    }

    public String getAaAlt() {
        return this.aaAlt;
    }

    public String getAaChange() {
        if (this.aaRef.isEmpty() && this.aaAlt.isEmpty()) {
            if (this.codonNum >= 0) {
                return "" + (this.codonNum + 1);
            }
            return "";
        }
        if (this.aaRef.equals(this.aaAlt)) {
            return this.aaAlt + (this.codonNum + 1);
        }
        return this.aaRef + (this.codonNum + 1) + this.aaAlt;
    }

    public String getAaChangeOld() {
        if (this.aaRef.isEmpty() && this.aaAlt.isEmpty()) {
            return "";
        }
        if (this.aaRef.equals(this.aaAlt)) {
            return this.aaAlt;
        }
        return (this.aaRef.isEmpty() ? "-" : this.aaRef) + "/" + (this.aaAlt.isEmpty() ? "-" : this.aaAlt);
    }

    public int getAaLength() {
        int cdsLen = this.getCdsLength();
        if (cdsLen < 0) {
            return -1;
        }
        int lenNoStop = Math.max(0, cdsLen - 3);
        return lenNoStop / 3;
    }

    public String getAaNetChange() {
        String aaShort = this.getAaRef().toUpperCase();
        String aaLong = this.getAaAlt().toUpperCase();
        if (aaLong.length() < aaShort.length()) {
            String tmp = aaShort;
            aaShort = aaLong;
            aaLong = tmp;
        }
        if (aaLong.startsWith(aaShort)) {
            return aaLong.substring(aaShort.length());
        }
        if (aaLong.endsWith(aaLong)) {
            return aaLong.substring(0, aaLong.length() - aaShort.length());
        }
        if (aaShort.isEmpty()) {
            return aaLong;
        }
        return null;
    }

    public String getAaRef() {
        return this.aaRef;
    }

    public BioType getBiotype() {
        Gene gene = this.getGene();
        if (gene == null) {
            return null;
        }
        Transcript tr = this.getTranscript();
        if (tr != null) {
            return tr.getBioType();
        }
        if (gene.getGenome().hasCodingInfo()) {
            return BioType.coding(gene.isProteinCoding());
        }
        return null;
    }

    public int getcDnaPos() {
        return this.cDnaPos;
    }

    public int getCdsLength() {
        Transcript tr = this.getTranscript();
        if (tr != null && tr.isProteinCoding()) {
            return tr.cds().length();
        }
        return -1;
    }

    public String getCodonChange() {
        if (this.codonsRef.isEmpty() && this.codonsAlt.isEmpty()) {
            return "";
        }
        return this.codonsRef + "/" + this.codonsAlt;
    }

    public String getCodonChangeMax() {
        if (this.variant.size() > 100) {
            return "";
        }
        if (this.codonsRef.isEmpty() && this.codonsAlt.isEmpty()) {
            return "";
        }
        return this.codonsRef + "/" + this.codonsAlt;
    }

    public int getCodonIndex() {
        return this.codonIndex;
    }

    public int getCodonNum() {
        return this.codonNum;
    }

    public String getCodonsAlt() {
        return this.codonsAlt;
    }

    public String getCodonsRef() {
        return this.codonsRef;
    }

    public int getDistance() {
        return this.distance;
    }

    public EffectImpact getEffectImpact() {
        if (this.effectImpact == null) {
            if (this.variant != null && !this.variant.isVariant()) {
                this.effectImpact = EffectImpact.MODIFIER;
            } else {
                this.effectImpact = EffectImpact.MODIFIER;
                for (EffectImpact eimp : this.effectImpacts) {
                    if (eimp.compareTo(this.effectImpact) >= 0) continue;
                    this.effectImpact = eimp;
                }
            }
        }
        return this.effectImpact;
    }

    public EffectType getEffectType() {
        if (this.effectType != null) {
            return this.effectType;
        }
        if (this.effectTypes == null || this.effectTypes.isEmpty()) {
            return EffectType.NONE;
        }
        this.effectType = EffectType.NONE;
        for (EffectType et : this.effectTypes) {
            if (et.compareTo(this.effectType) >= 0) continue;
            this.effectType = et;
        }
        return this.effectType;
    }

    public List<EffectType> getEffectTypes() {
        return this.effectTypes;
    }

    public String getEffectTypeString(boolean useSeqOntology) {
        return this.getEffectTypeString(useSeqOntology, false, EffFormatVersion.FORMAT_EFF_4);
    }

    public String getEffectTypeString(boolean useSeqOntology, boolean useFirstEffect) {
        return this.getEffectTypeString(useSeqOntology, useFirstEffect, EffFormatVersion.FORMAT_EFF_4);
    }

    public String getEffectTypeString(boolean useSeqOntology, boolean useFirstEffect, EffFormatVersion formatVersion) {
        if (this.effectTypes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.effectTypes);
        HashSet<String> added = this.effectTypes.size() > 1 && !useFirstEffect ? new HashSet<String>() : null;
        for (EffectType et : this.effectTypes) {
            String eff;
            String string2 = eff = useSeqOntology ? et.toSequenceOntology(formatVersion, this.variant) : et.toString();
            if (added == null || added.add(eff)) {
                if (sb.length() > 0) {
                    sb.append(formatVersion.separator());
                }
                sb.append(eff);
            }
            if (!useFirstEffect) continue;
            return sb.toString();
        }
        return sb.toString();
    }

    public String getError() {
        return this.error;
    }

    public Exon getExon() {
        if (this.marker != null) {
            if (this.marker instanceof Exon) {
                return (Exon)this.marker;
            }
            return (Exon)this.marker.findParent(Exon.class);
        }
        return null;
    }

    public FunctionalClass getFunctionalClass() {
        if (this.variant.isSnp()) {
            if (!this.aaAlt.equals(this.aaRef)) {
                CodonTable codonTable = this.marker.codonTable();
                if (codonTable.isStop(this.codonsAlt)) {
                    return FunctionalClass.NONSENSE;
                }
                return FunctionalClass.MISSENSE;
            }
            if (!this.codonsAlt.equals(this.codonsRef)) {
                return FunctionalClass.SILENT;
            }
        }
        return FunctionalClass.NONE;
    }

    public Gene getGene() {
        if (this.marker != null) {
            if (this.marker instanceof Gene) {
                return (Gene)this.marker;
            }
            return (Gene)this.marker.findParent(Gene.class);
        }
        return null;
    }

    public String getGeneRegion() {
        EffectType eff = this.getEffectType().getGeneRegion();
        if (eff == EffectType.TRANSCRIPT && this.isExon()) {
            eff = EffectType.EXON;
        }
        return eff.toString();
    }

    public List<Gene> getGenes() {
        return null;
    }

    public String getGenotype() {
        if (this.variant == null) {
            return "";
        }
        return this.variant.getGenotype();
    }

    public String getHgvs() {
        if (!Config.get().isHgvs()) {
            return "";
        }
        String hgvsProt = this.getHgvsProt();
        String hgvsDna = this.getHgvsDna();
        StringBuilder hgvs = new StringBuilder();
        if (hgvsProt != null) {
            hgvs.append(hgvsProt);
        }
        if (hgvsDna != null) {
            if (hgvs.length() > 0) {
                hgvs.append('/');
            }
            hgvs.append(hgvsDna);
        }
        return hgvs.toString();
    }

    public String getHgvsDna() {
        if (!Config.get().isHgvs()) {
            return "";
        }
        HgvsDna hgvsDna = new HgvsDna(this);
        String hgvs = hgvsDna.toString();
        return hgvs != null ? hgvs : "";
    }

    public String getHgvsProt() {
        if (!Config.get().isHgvs()) {
            return "";
        }
        HgvsProtein hgvsProtein = new HgvsProtein(this);
        String hgvs = hgvsProtein.toString();
        return hgvs != null ? hgvs : "";
    }

    public Intron getIntron() {
        if (this.marker != null) {
            if (this.marker instanceof Intron) {
                return (Intron)this.marker;
            }
            return (Intron)this.marker.findParent(Intron.class);
        }
        return null;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public Transcript getTranscript() {
        if (this.marker != null) {
            if (this.marker instanceof Transcript) {
                return (Transcript)this.marker;
            }
            return (Transcript)this.marker.findParent(Transcript.class);
        }
        return null;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public String getWarning() {
        return this.warning;
    }

    public boolean hasAdditionalAnnotations() {
        return this.getMarker() != null && this.getMarker() instanceof Custom && ((Custom)this.getMarker()).hasAnnotations();
    }

    public boolean hasEffectImpact(EffectImpact effectImpact) {
        for (EffectImpact effImp : this.effectImpacts) {
            if (effImp != effectImpact) continue;
            return true;
        }
        return false;
    }

    public boolean hasEffectType(EffectType effectType) {
        for (EffectType effType : this.effectTypes) {
            if (effType != effectType) continue;
            return true;
        }
        return false;
    }

    public boolean hasError() {
        return this.error != null && !this.error.isEmpty();
    }

    public boolean hasWarning() {
        return this.warning != null && !this.warning.isEmpty();
    }

    public boolean isCustom() {
        return this.getEffectType() == EffectType.CUSTOM;
    }

    public boolean isExon() {
        return this.marker instanceof Exon || this.hasEffectType(EffectType.EXON_DELETED);
    }

    public boolean isIntergenic() {
        return this.hasEffectType(EffectType.INTERGENIC) || this.hasEffectType(EffectType.INTERGENIC_CONSERVED);
    }

    public boolean isIntron() {
        return this.hasEffectType(EffectType.INTRON) || this.hasEffectType(EffectType.INTRON_CONSERVED);
    }

    public boolean isMotif() {
        return this.hasEffectType(EffectType.MOTIF);
    }

    public boolean isMultipleGenes() {
        return false;
    }

    public boolean isNextProt() {
        return this.hasEffectType(EffectType.NEXT_PROT);
    }

    public boolean isRegulation() {
        return this.hasEffectType(EffectType.REGULATION);
    }

    public boolean isSpliceSite() {
        return this.hasEffectType(EffectType.SPLICE_SITE_DONOR) || this.hasEffectType(EffectType.SPLICE_SITE_ACCEPTOR) || this.hasEffectType(EffectType.SPLICE_SITE_REGION) || this.hasEffectType(EffectType.SPLICE_SITE_BRANCH) || this.hasEffectType(EffectType.SPLICE_SITE_BRANCH_U12);
    }

    public boolean isSpliceSiteCore() {
        return this.hasEffectType(EffectType.SPLICE_SITE_DONOR) || this.hasEffectType(EffectType.SPLICE_SITE_ACCEPTOR);
    }

    public boolean isSpliceSiteRegion() {
        return this.hasEffectType(EffectType.SPLICE_SITE_REGION);
    }

    public boolean isUtr3() {
        return this.hasEffectType(EffectType.UTR_3_PRIME) || this.hasEffectType(EffectType.UTR_3_DELETED);
    }

    public boolean isUtr5() {
        return this.hasEffectType(EffectType.UTR_5_PRIME) || this.hasEffectType(EffectType.UTR_5_DELETED);
    }

    public void set(Marker marker, EffectType effectType, EffectImpact effectImpact, String message) {
        this.setMarker(marker);
        this.setEffectType(effectType);
        this.setEffectImpact(effectImpact);
        this.message = message;
    }

    public void setCodons(String codonsOld, String codonsNew, int codonNum, int codonIndex) {
        this.codonsRef = codonsOld;
        this.codonsAlt = codonsNew;
        this.codonNum = codonNum;
        this.codonIndex = codonIndex;
        CodonTable codonTable = this.marker.codonTable();
        if (codonsOld.isEmpty()) {
            this.aaRef = "";
        } else {
            this.aaRef = codonTable.aa(codonsOld);
            this.codonDegeneracy = codonTable.degenerate(codonsOld, codonIndex);
        }
        this.aaAlt = codonsNew.isEmpty() ? "" : codonTable.aa(codonsNew);
    }

    public void setCodonsAround(String codonsLeft, String codonsRight) {
        this.codonsAroundOld = codonsLeft.toLowerCase() + this.codonsRef.toUpperCase() + codonsRight.toLowerCase();
        this.codonsAroundNew = codonsLeft.toLowerCase() + this.codonsAlt.toUpperCase() + codonsRight.toLowerCase();
        CodonTable codonTable = this.marker.codonTable();
        String aasLeft = codonTable.aa(codonsLeft);
        String aasRigt = codonTable.aa(codonsRight);
        this.aasAroundOld = aasLeft.toLowerCase() + this.aaRef.toUpperCase() + aasRigt.toLowerCase();
        this.aasAroundNew = aasLeft.toLowerCase() + this.aaAlt.toUpperCase() + aasRigt.toLowerCase();
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public void setEffect(EffectType effectType) {
        this.setEffectType(effectType);
        this.setEffectImpact(effectType.effectImpact());
    }

    public void setEffectImpact(EffectImpact effectImpact) {
        this.effectImpacts.clear();
        this.effectImpacts.add(effectImpact);
        this.effectImpact = null;
    }

    public void setEffectType(EffectType effectType) {
        this.effectTypes.clear();
        this.effectTypes.add(effectType);
        this.effectType = null;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
        Transcript transcript = this.getTranscript();
        if (transcript != null) {
            this.addErrorWarningInfo(transcript.sanityCheck(this.variant));
            Exon exon = this.getExon();
            if (exon != null) {
                this.addErrorWarningInfo(exon.sanityCheck(this.variant));
            }
        }
    }

    public String toStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("Variant             : " + this.variant.toStr());
        sb.append("\n\tEffectTypes     : " + this.effectTypes);
        sb.append("\n\tEffectImpacts   : " + this.effectImpacts);
        if (this.marker != null) {
            sb.append("\n\tMarker          : " + this.marker.toStr());
        }
        if (!this.codonsRef.isEmpty() || !this.codonsAlt.isEmpty()) {
            sb.append("\n\tCodons Ref/Alt  : " + this.codonsRef + " / " + this.codonsAlt);
        }
        if (!this.aaRef.isEmpty() || !this.aaAlt.isEmpty()) {
            sb.append("\n\tAA Ref/Alt      : " + this.aaRef + " / " + this.aaAlt);
        }
        if (this.cDnaPos >= 0) {
            sb.append("\n\tcDnaPos         : " + this.cDnaPos);
        }
        if (this.codonNum >= 0) {
            sb.append("\n\tcodon num/index : " + this.codonNum + " / " + this.codonIndex);
        }
        if (!this.error.isEmpty()) {
            sb.append("\n\tError           : " + this.error);
        }
        if (!this.warning.isEmpty()) {
            sb.append("\n\tWarning         : " + this.warning);
        }
        if (!this.message.isEmpty()) {
            sb.append("\n\tMessage         : " + this.message);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean useSeqOntology, boolean useHgvs) {
        String geneId = "";
        String geneName = "";
        String transcriptId = "";
        String exonId = "";
        String customId = "";
        String bioType = null;
        int exonRank = -1;
        if (this.marker != null) {
            Exon exon;
            Gene gene = this.getGene();
            Transcript tr = this.getTranscript();
            if (gene != null) {
                geneId = gene.getId();
                geneName = gene.getGeneName();
                String string2 = bioType = this.getBiotype() == null ? "" : this.getBiotype().toString();
            }
            if (tr != null) {
                transcriptId = tr.getId();
            }
            if ((exon = this.getExon()) != null) {
                exonId = exon.getId();
                exonRank = exon.getRank();
            }
            if (this.isRegulation()) {
                bioType = ((Regulation)this.marker).getRegulationType();
            }
        }
        if (!this.variant.getId().isEmpty()) {
            customId = customId + this.variant.getId();
        }
        if (this.marker != null && this.marker instanceof Custom) {
            customId = customId + (customId.isEmpty() ? "" : ";") + this.marker.getId();
        }
        int cdsSize = this.getCdsLength();
        String errWarn = this.error + (this.error.isEmpty() ? "" : "|") + this.warning;
        String aaChange = "";
        aaChange = useHgvs ? this.getHgvs() : (this.aaRef.length() + this.aaAlt.length() > 0 ? this.aaRef + "/" + this.aaAlt : "");
        return errWarn + "\t" + geneId + "\t" + geneName + "\t" + bioType + "\t" + transcriptId + "\t" + exonId + "\t" + (exonRank >= 0 ? Integer.valueOf(exonRank) : "") + "\t" + this.effect(false, false, false, useSeqOntology, false) + "\t" + aaChange + "\t" + (this.codonsRef.length() + this.codonsAlt.length() > 0 ? this.codonsRef + "/" + this.codonsAlt : "") + "\t" + (this.codonNum >= 0 ? Integer.valueOf(this.codonNum + 1) : "") + "\t" + (this.codonDegeneracy >= 0 ? this.codonDegeneracy + "" : "") + "\t" + (cdsSize >= 0 ? Integer.valueOf(cdsSize) : "") + "\t" + (this.codonsAroundOld.length() > 0 ? this.codonsAroundOld + " / " + this.codonsAroundNew : "") + "\t" + (this.aasAroundOld.length() > 0 ? this.aasAroundOld + " / " + this.aasAroundNew : "") + "\t" + customId;
    }

    public String toStringSimple(boolean shortFormat) {
        String eff;
        String transcriptId = "";
        Transcript tr = this.getTranscript();
        if (tr != null) {
            transcriptId = tr.getId();
        }
        String exonId = "";
        Exon exon = this.getExon();
        if (exon != null) {
            exonId = exon.getId();
        }
        if (!(eff = this.effect(shortFormat, true, true, false, false)).isEmpty()) {
            return eff;
        }
        if (!exonId.isEmpty()) {
            return exonId;
        }
        if (!transcriptId.isEmpty()) {
            return transcriptId;
        }
        return "NO EFFECT";
    }

    public static enum FunctionalClass {
        NONE,
        SILENT,
        MISSENSE,
        NONSENSE;

    }

    public static enum ErrorWarningType {
        INFO_REALIGN_3_PRIME,
        WARNING_SEQUENCE_NOT_AVAILABLE,
        WARNING_REF_DOES_NOT_MATCH_GENOME,
        WARNING_TRANSCRIPT_INCOMPLETE,
        WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS,
        WARNING_TRANSCRIPT_NO_START_CODON,
        WARNING_TRANSCRIPT_NO_STOP_CODON,
        ERROR_CHROMOSOME_NOT_FOUND,
        ERROR_OUT_OF_CHROMOSOME_RANGE,
        ERROR_OUT_OF_EXON,
        ERROR_MISSING_CDS_SEQUENCE;


        public boolean isError() {
            return this.toString().startsWith("ERROR");
        }

        public boolean isWarning() {
            return this.toString().startsWith("WARNING");
        }
    }

    public static enum EffectImpact {
        HIGH,
        MODERATE,
        LOW,
        MODIFIER;

    }

    public static enum Coding {
        CODING,
        NON_CODING;

    }
}

