/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.geneSets.algorithm;

import org.apfloat.Apfloat;
import org.snpeff.geneSets.GeneSet;
import org.snpeff.geneSets.GeneSets;
import org.snpeff.geneSets.algorithm.FisherPValueGreedyAlgorithm;
import org.snpeff.gsa.ScoreList;
import org.snpeff.probablility.FisherExactTest;
import org.snpeff.util.Timer;

public class LeadingEdgeFractionAlgorithm
extends FisherPValueGreedyAlgorithm {
    public static final double SCORE_CUTOFF_QUANTILE_DEFAULT = 0.05;
    public static final Apfloat ONE = new Apfloat(1.0);
    boolean orderDescending = false;
    double scoreCutOff;
    double scoreCutOffQuantile = 0.05;
    int N;
    int D;

    public LeadingEdgeFractionAlgorithm(GeneSets geneSets, int numberToSelect, boolean orderDescending) {
        super(geneSets, numberToSelect);
        this.orderDescending = orderDescending;
        this.init();
    }

    void init() {
        this.scoreCutOff = this.scoreCutOff();
        this.D = 0;
        this.N = 0;
        for (String geneId : this.geneSets.getGenes()) {
            if (!this.geneSets.hasValue(geneId)) continue;
            ++this.N;
            if (!this.isTopScore(geneId)) continue;
            ++this.D;
        }
        if (this.verbose) {
            Timer.showStdErr("Fisher Exact test parameters:\n\tN : " + this.N + "\n\tD : " + this.D);
        }
    }

    boolean isTopScore(String geneId) {
        double val = this.geneSets.getValue(geneId);
        return !this.orderDescending && val <= this.scoreCutOff || this.orderDescending && this.scoreCutOff <= val;
    }

    @Override
    Apfloat pValue(GeneSet geneSet) {
        int count2 = 0;
        int tot = 0;
        for (String geneId : geneSet) {
            if (!this.geneSets.hasValue(geneId)) continue;
            if (this.isTopScore(geneId)) {
                ++count2;
            }
            ++tot;
        }
        if (tot <= 0) {
            return ONE;
        }
        if (this.debug) {
            double leadingEdgeFraction = (double)count2 / (double)tot;
            Timer.showStdErr("Gene set: " + geneSet.getName() + "\tsize: " + geneSet.size() + "\tsize (eff): " + geneSet.sizeEffective() + "\t" + count2 + "\tleadingEdgeFraction: " + leadingEdgeFraction);
        }
        double pvalueFisher = FisherExactTest.get().fisherExactTestUp(count2, this.N, this.D, tot);
        return new Apfloat(pvalueFisher);
    }

    double scoreCutOff() {
        ScoreList scoreList = new ScoreList();
        for (String geneId : this.geneSets.getGenes()) {
            if (!this.geneSets.hasValue(geneId)) continue;
            scoreList.add(this.geneSets.getValue(geneId));
        }
        double quantile = this.scoreCutOffQuantile;
        if (this.orderDescending) {
            quantile = 1.0 - this.scoreCutOffQuantile;
        }
        double pco = scoreList.quantile(quantile);
        if (this.verbose) {
            Timer.showStdErr("Calculate pValue_CutOff: \n\tSize (effective) : " + scoreList.size() + "\n\tQuantile         : " + this.scoreCutOffQuantile + "\n\tScore CutOff     : " + pco);
        }
        if (this.debug) {
            Timer.showStdErr("\tp-values: " + scoreList);
        }
        return pco;
    }

    public void setOrderDescending(boolean orderDescending) {
        this.orderDescending = orderDescending;
    }

    public void setpValueCutOffQuantile(double pValueCutOffQuantile) {
        this.scoreCutOffQuantile = pValueCutOffQuantile;
        this.scoreCutOff = this.scoreCutOff();
    }
}

