/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import org.snpeff.interval.Gene;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantBnd;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffectStructural;

public class VariantEffectFusion
extends VariantEffectStructural {
    int aaNumLeftStart;
    int aaNumLeftEnd;
    int aaNumRightStart;
    int aaNumRightEnd;
    Marker mLeft;
    Marker mRight;
    Transcript trLeft;
    Transcript trRight;
    Gene geneLeft;
    Gene geneRight;

    public VariantEffectFusion(Variant variant, Marker mLeft, Marker mRight) {
        super(variant);
        this.mLeft = mLeft;
        if (this.isTranscript(mLeft)) {
            this.trLeft = (Transcript)mLeft;
            this.geneLeft = (Gene)mLeft.getParent();
            this.genes.add(this.geneLeft);
        }
        this.mRight = mRight;
        if (this.isTranscript(mRight)) {
            this.trRight = (Transcript)mRight;
            this.geneRight = (Gene)mRight.getParent();
            this.genes.add(this.geneRight);
        }
        this.featuresLeft.add(mLeft);
        this.featuresRight.add(mRight);
        this.calcEffect();
    }

    void aaLeftBegin() {
        this.aaNumLeftStart = 0;
        this.aaNumLeftEnd = this.baseNumberCdsLeft() / 3;
    }

    void aaLeftEnd() {
        this.aaNumLeftStart = this.baseNumberCdsLeft() / 3;
        this.aaNumLeftEnd = this.trLeft.protein().length() - 1;
    }

    void aaPos() {
        VariantBnd vtrans = this.getVariantTranslocation();
        if (!vtrans.isLeft() && !vtrans.isBefore()) {
            if (this.trLeft != null) {
                if (this.trLeft.isStrandPlus()) {
                    this.aaLeftBegin();
                } else {
                    this.aaLeftEnd();
                }
            }
            if (this.trRight != null) {
                if (this.trRight.isStrandMinus()) {
                    this.aaRightBegin();
                } else {
                    this.aaRightEnd();
                }
            }
        }
        if (vtrans.isLeft() && !vtrans.isBefore()) {
            if (this.trLeft != null) {
                if (this.trLeft.isStrandPlus()) {
                    this.aaLeftBegin();
                } else {
                    this.aaLeftEnd();
                }
            }
            if (this.trRight != null) {
                if (this.trRight.isStrandPlus()) {
                    this.aaRightBegin();
                } else {
                    this.aaRightEnd();
                }
            }
        }
        if (!vtrans.isLeft() && vtrans.isBefore()) {
            if (this.trLeft != null) {
                if (this.trLeft.isStrandMinus()) {
                    this.aaLeftBegin();
                } else {
                    this.aaLeftEnd();
                }
            }
            if (this.trRight != null) {
                if (this.trRight.isStrandMinus()) {
                    this.aaRightBegin();
                } else {
                    this.aaRightEnd();
                }
            }
        }
        if (vtrans.isLeft() && vtrans.isBefore()) {
            if (this.trLeft != null) {
                if (this.trLeft.isStrandMinus()) {
                    this.aaLeftBegin();
                } else {
                    this.aaLeftEnd();
                }
            }
            if (this.trRight != null) {
                if (this.trRight.isStrandPlus()) {
                    this.aaRightBegin();
                } else {
                    this.aaRightEnd();
                }
            }
        }
    }

    void aaRightBegin() {
        this.aaNumRightStart = 0;
        this.aaNumRightEnd = this.baseNumberCdsRight() / 3;
    }

    void aaRightEnd() {
        this.aaNumRightStart = this.baseNumberCdsRight() / 3;
        this.aaNumRightEnd = this.trRight.protein().length() - 1;
    }

    int baseNumberCdsLeft() {
        return this.trLeft.baseNumberCds(this.variant.getStart(), this.usePrevBaseIntronLeft());
    }

    int baseNumberCdsRight() {
        return this.trRight.baseNumberCds(this.getVariantTranslocation().getEndPoint().getStart(), !this.usePrevBaseIntronLeft());
    }

    void calcEffect() {
        boolean sameStrand = this.trLeft == null || this.trRight == null || this.trLeft.isStrandPlus() == this.trRight.isStrandPlus();
        switch (this.variant.getVariantType()) {
            case INV: {
                this.setEffect(sameStrand ? EffectType.GENE_FUSION_REVERESE : EffectType.GENE_FUSION);
                this.marker = this.geneLeft;
                break;
            }
            case DEL: 
            case DUP: {
                this.setEffect(sameStrand ? EffectType.GENE_FUSION : EffectType.GENE_FUSION_REVERESE);
                this.marker = this.geneLeft;
                break;
            }
            case BND: {
                this.marker = this.trLeft;
                if (this.marker == null) {
                    this.marker = this.trRight;
                }
                if (this.marker == null) {
                    this.marker = this.mLeft;
                }
                if (this.marker == null) {
                    this.marker = this.mRight;
                }
                VariantBnd vtrans = this.getVariantTranslocation();
                EffectType effType = null;
                if (this.trLeft == null && this.trRight == null) {
                    effType = EffectType.FEATURE_FUSION;
                } else if (this.trLeft == null || this.trRight == null) {
                    effType = EffectType.GENE_FUSION_HALF;
                } else if (!vtrans.isLeft() && !vtrans.isBefore()) {
                    effType = sameStrand ? EffectType.GENE_FUSION : EffectType.GENE_FUSION_REVERESE;
                } else if (vtrans.isLeft() && !vtrans.isBefore()) {
                    effType = !sameStrand ? EffectType.GENE_FUSION : EffectType.GENE_FUSION_REVERESE;
                } else if (!vtrans.isLeft() && vtrans.isBefore()) {
                    effType = !sameStrand ? EffectType.GENE_FUSION : EffectType.GENE_FUSION_REVERESE;
                } else if (vtrans.isLeft() && vtrans.isBefore()) {
                    effType = sameStrand ? EffectType.GENE_FUSION : EffectType.GENE_FUSION_REVERESE;
                } else {
                    throw new RuntimeException("This should never happen!");
                }
                this.setEffect(effType);
                this.aaPos();
                if (effType != EffectType.GENE_FUSION) break;
                this.frameShift();
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented method for variant type '" + (Object)((Object)this.variant.getVariantType()) + "'");
            }
        }
    }

    void frameShift() {
        if (this.trLeft == null || this.trRight == null) {
            return;
        }
        int cdsPosLeft = this.baseNumberCdsLeft();
        int frameLeft = cdsPosLeft % 3;
        int cdsPosRight = this.baseNumberCdsRight();
        int frameRight = cdsPosRight % 3;
        boolean ok = false;
        boolean before = this.getVariantTranslocation().isBefore();
        if (!before && this.trLeft.isStrandPlus()) {
            ok = (frameLeft + 1) % 3 == frameRight;
        } else if (!before && this.trLeft.isStrandMinus()) {
            ok = (frameRight + 1) % 3 == frameLeft;
        } else if (before && this.trLeft.isStrandMinus()) {
            ok = (frameLeft + 1) % 3 == frameRight;
        } else if (before && this.trLeft.isStrandPlus()) {
            boolean bl = ok = (frameRight + 1) % 3 == frameLeft;
        }
        if (!ok) {
            this.addEffect(EffectType.FRAME_SHIFT);
        }
    }

    public int getAaNumLeftEnd() {
        return this.aaNumLeftEnd;
    }

    public int getAaNumLeftStart() {
        return this.aaNumLeftStart;
    }

    public int getAaNumRightEnd() {
        return this.aaNumRightEnd;
    }

    public int getAaNumRightStart() {
        return this.aaNumRightStart;
    }

    @Override
    public Gene getGene() {
        if (this.geneLeft != null) {
            return this.geneLeft;
        }
        if (this.geneRight != null) {
            return this.geneRight;
        }
        return null;
    }

    public Gene getGeneLeft() {
        return this.geneLeft;
    }

    public Gene getGeneRight() {
        return this.geneRight;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    public Transcript getTrLeft() {
        return this.trLeft;
    }

    public Transcript getTrRight() {
        return this.trRight;
    }

    VariantBnd getVariantTranslocation() {
        return (VariantBnd)this.variant;
    }

    public boolean isGeneGeneFusion() {
        return this.geneLeft != null && this.geneRight != null;
    }

    boolean isVariantTranslocation() {
        return this.variant instanceof VariantBnd;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toStr());
        sb.append("\n\tFeatures left  : [");
        for (Marker m : this.featuresLeft) {
            sb.append(" " + m.getId());
        }
        sb.append("]");
        sb.append("\n\tFeatures right  : [");
        for (Marker m : this.featuresRight) {
            sb.append(" " + m.getId());
        }
        sb.append("]");
        sb.append("\n\tGenes: [");
        for (Gene g : this.genes) {
            sb.append(g.getGeneName() + " ");
        }
        sb.append(" ]");
        return sb.toString();
    }

    boolean usePrevBaseIntronLeft() {
        return this.trLeft != null && (this.trLeft.isStrandPlus() && !this.getVariantTranslocation().isBefore() || this.trLeft.isStrandMinus() && this.getVariantTranslocation().isBefore());
    }
}

