/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.genBank;

import java.util.Iterator;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.genBank.Features;
import org.snpeff.util.Gpr;

public abstract class FeaturesFile
implements Iterable<Features>,
Iterator<Features> {
    LineFileIterator lineFileIterator;
    Features next;

    public FeaturesFile(String fileName) {
        this.open(fileName);
        this.next = this.readNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Iterator<Features> iterator() {
        return this;
    }

    @Override
    public Features next() {
        Features n = this.next;
        this.next = this.readNext();
        if (!this.lineFileIterator.hasNext() && this.next.isEmpty()) {
            this.next = null;
        }
        return n;
    }

    protected void open(String fileName) {
        if (!Gpr.canRead(fileName)) {
            throw new RuntimeException("Cannot read file '" + fileName + "'");
        }
        if (this.lineFileIterator != null) {
            this.lineFileIterator.close();
        }
        this.lineFileIterator = new LineFileIterator(fileName);
    }

    abstract Features readNext();

    @Override
    public void remove() {
        throw new RuntimeException("Unimplemented method!");
    }
}

