/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.pI;

import com.informagen.Sequence;
import com.informagen.Util;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.ImagePrinter;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import com.informagen.sa.pI.IsoElectricGraph;
import com.informagen.sa.pI.IsoElectricPoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class IsoElectricPointPanel
extends AnalysisPanel {
    private IsoElectricGraph graph = new IsoElectricGraph();
    private Sequence sequence;
    private int[] selection;
    private boolean threadIsRunning = false;

    public static String getAnalysisName() {
        return "pI";
    }

    public IsoElectricPointPanel() {
        this.buildUI();
    }

    public boolean ignorePropertyChangeEvents() {
        return true;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = nArray;
        this.writeIt();
    }

    public void sequenceUnavailable() {
        this.saObject = null;
        this.selection = null;
        this.sequence = null;
        this.remove(this.graph);
        this.graph = new IsoElectricGraph();
        this.add((Component)this.graph, "Center");
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = null;
        this.writeIt();
    }

    public void selectionChanged(int[] nArray) {
        this.selection = nArray;
        this.writeIt();
    }

    public void selectionCancelled() {
        this.selectionChanged(null);
    }

    public void cursorPositionChanged(int n) {
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 20, 20, 20));
        this.add((Component)this.graph, "Center");
    }

    void writeIt() {
        if (this.sequence == null) {
            return;
        }
        if (this.threadIsRunning) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                double[][] dArray = null;
                StringBuffer stringBuffer = new StringBuffer();
                if (IsoElectricPointPanel.this.sequence.isProtein()) {
                    dArray = IsoElectricPoint.pIData(IsoElectricPointPanel.this.sequence, IsoElectricPointPanel.this.selection, 2.0, 11.5, 0.5);
                    if (IsoElectricPointPanel.this.selection != null) {
                        stringBuffer.append("pI of selection").append(" ");
                        stringBuffer.append("").append(IsoElectricPointPanel.this.selection[0] + 1).append("-").append(IsoElectricPointPanel.this.selection[1]).append("");
                        IsoElectricPointPanel.this.graph.setTitle(stringBuffer.toString());
                    } else {
                        IsoElectricPointPanel.this.graph.setTitle("IsoElectric Point, pI");
                    }
                } else if (IsoElectricPointPanel.this.sequence.isNucleic()) {
                    Sequence sequence = null;
                    sequence = IsoElectricPointPanel.this.selection != null ? new Sequence(IsoElectricPointPanel.this.sequence.getSequence().substring(IsoElectricPointPanel.this.selection[0], IsoElectricPointPanel.this.selection[1])) : new Sequence(IsoElectricPointPanel.this.sequence.getSequence());
                    sequence.nucToProtein();
                    stringBuffer.append("pI of translated ").append(" ");
                    if (IsoElectricPointPanel.this.selection != null) {
                        stringBuffer.append("selection").append(" ");
                        stringBuffer.append("").append(IsoElectricPointPanel.this.selection[0] + 1).append("-").append(IsoElectricPointPanel.this.selection[1]).append("");
                    } else {
                        stringBuffer.append("sequence");
                    }
                    IsoElectricPointPanel.this.graph.setTitle(stringBuffer.toString());
                    dArray = IsoElectricPoint.pIData(sequence, null, 2.0, 11.5, 0.5);
                }
                IsoElectricPointPanel.this.writeToDocument(dArray);
                IsoElectricPointPanel.this.threadIsRunning = false;
            }
        };
        try {
            this.threadIsRunning = true;
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    void writeToDocument(final double[][] dArray) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    IsoElectricPointPanel.this.graph.setData(dArray);
                }
            });
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void savePanel() {
        int n = this.graph.getSize().width;
        int n2 = this.graph.getSize().height;
        Image image = this.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.graph.paintComponent(graphics);
        graphics.dispose();
        String string = this.sequence != null ? this.sequence.getUID() : "";
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveImage(frame, image, string, "IsoelectricPoint");
    }

    public void printPanel() {
        ImagePrinter imagePrinter = new ImagePrinter();
        int n = this.graph.getSize().width;
        int n2 = this.graph.getSize().height;
        Image image = this.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.graph.paintComponent(graphics);
        graphics.dispose();
        imagePrinter.setImage(image);
        imagePrinter.print();
    }
}

