/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.F;
import com.informagen.sa.digest.CutSite;
import com.informagen.sa.digest.Digest;
import com.informagen.sa.digest.DigestReportPanel;
import com.informagen.sa.digest.EnzymeCuts;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class UniqueCuttersPanel
extends DigestReportPanel {
    private static final int COL1 = 12;
    private static final int COL2 = 17;
    private static final int GROUPS = 5;
    private static final String COLSPACE = " ";
    private int numWidth = 5;

    public UniqueCuttersPanel() {
        super("Unique Cutters");
    }

    public void digestChanged(Digest digest) {
        Object object;
        this.writeHeader(digest);
        this.numWidth = (int)Math.ceil(Math.log(digest.getSeqLength()) / Math.log(10.0));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(F.f("Enzyme", 12, (short)2)).append(F.f("Site", 17, (short)2));
        stringBuffer.append(F.f("5'", this.numWidth, (short)1));
        stringBuffer.append(F.f("Cut", this.numWidth + this.numWidth + 4, (short)1));
        stringBuffer.append(F.f("3'", this.numWidth + this.numWidth + 4, (short)1));
        stringBuffer.append("\n");
        stringBuffer.append(F.f("-", 11, (short)16)).append(COLSPACE);
        stringBuffer.append(F.f("-", 11, (short)16));
        stringBuffer.append("\n");
        Vector vector = digest.getUniqueCutters();
        Vector<CutSite> vector2 = new Vector<CutSite>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (EnzymeCuts)iterator.next();
            Iterator iterator2 = ((EnzymeCuts)object).getCutSites().iterator();
            while (iterator2.hasNext()) {
                CutSite cutSite = (CutSite)iterator2.next();
                vector2.addElement(cutSite);
            }
        }
        Collections.sort(vector2, CutSite.getComparator());
        object = vector2.iterator();
        while (object.hasNext()) {
            this.writeLine(digest, stringBuffer, (CutSite)object.next());
        }
        this.textArea.append(stringBuffer.toString());
    }

    void writeLine(Digest digest, StringBuffer stringBuffer, CutSite cutSite) {
        String string = cutSite.getEnzymeName();
        string = string.startsWith("*") ? string : COLSPACE + string;
        int n = 1;
        stringBuffer.append(F.f(string, 12, (short)2));
        stringBuffer.append(F.f(cutSite.getEnzymeSite(), 17, (short)2));
        int n2 = cutSite.getCutPosition();
        stringBuffer.append(F.f(n, this.numWidth));
        stringBuffer.append(COLSPACE);
        stringBuffer.append("(");
        stringBuffer.append(F.f(n2 - n, this.numWidth));
        stringBuffer.append(")");
        stringBuffer.append(COLSPACE);
        n = n2;
        stringBuffer.append(F.f(n, this.numWidth));
        stringBuffer.append(COLSPACE);
        stringBuffer.append("(");
        stringBuffer.append(F.f(digest.getSeqLength() - n + 1, this.numWidth));
        stringBuffer.append(")");
        stringBuffer.append(COLSPACE);
        stringBuffer.append(F.f(digest.getSeqLength(), this.numWidth));
        stringBuffer.append("\n");
    }
}

