/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.composition;

import com.informagen.Sequence;
import com.informagen.Util;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.PanelPrinter;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import com.informagen.sa.composition.Composition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class CompositionPanel
extends AnalysisPanel {
    final JTextPane outputArea = new JTextPane();

    public static String getAnalysisName() {
        return "Composition";
    }

    public CompositionPanel() {
        this.buildUI();
    }

    public boolean ignorePropertyChangeEvents() {
        return true;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = nArray;
        this.writeIt();
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = null;
        this.writeIt();
    }

    public void sequenceUnavailable() {
        this.selection = null;
        this.sequence = null;
        this.writeToOutputArea("");
    }

    public void selectionChanged(int[] nArray) {
        this.selection = nArray;
        this.writeIt();
    }

    public void selectionCancelled() {
        this.selectionChanged(null);
    }

    public void cursorPositionChanged(int n) {
    }

    public void printPanel() {
        String string = this.outputArea.getText();
        PanelPrinter panelPrinter = new PanelPrinter(string);
        panelPrinter.setPointSize(12);
        panelPrinter.print();
    }

    public void savePanel() {
        String string = this.outputArea.getText();
        String string2 = this.sequence != null ? this.sequence.getUID() : "";
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveText(frame, string, string2 + "-Composition.txt");
    }

    private void buildUI() {
        this.setLayout(new BorderLayout(5, 5));
        this.outputArea.setFont(new Font("Courier", 0, Util.isWindows() ? 10 : 12));
        this.outputArea.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.outputArea, 22, 30);
        this.add((Component)jScrollPane, "Center");
    }

    private void writeIt() {
        if (this.workThread != null) {
            this.workThread.interrupt();
        }
        this.workThread = new Thread(){

            public void run() {
                String string = Composition.composition(CompositionPanel.this.sequence, CompositionPanel.this.selection);
                if (CompositionPanel.this.sequence.isNucleic() && CompositionPanel.this.selection != null) {
                    Sequence sequence = new Sequence(CompositionPanel.this.sequence.getSequence().substring(CompositionPanel.this.selection[0], CompositionPanel.this.selection[1]));
                    sequence.nucToProtein();
                    string = string + "\n\nNucleic acid selection as protein:";
                    string = string + "\n----------------------------------";
                    string = string + Composition.composition(sequence, null);
                }
                CompositionPanel.this.writeToOutputArea(string);
                CompositionPanel.this.workThread = null;
            }
        };
        try {
            this.workThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    void writeToOutputArea(final String string) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CompositionPanel.this.outputArea.selectAll();
                    CompositionPanel.this.outputArea.replaceSelection(string);
                    CompositionPanel.this.outputArea.setCaretPosition(0);
                }
            });
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

