/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;

public class Uri
implements PhylogenyData {
    private final URI _uri;
    private final String _description;
    private final String _type;

    public Uri(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("attempt to create Uri from null");
        }
        this._uri = URI.create(string);
        this._description = string2;
        this._type = string3;
    }

    public Uri(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("attempt to create Uri from null URI");
        }
        this._uri = uRI;
        this._description = "";
        this._type = "";
    }

    public Uri(URI uRI, String string, String string2) {
        if (uRI == null) {
            throw new IllegalArgumentException("attempt to create Uri from null URI");
        }
        this._uri = uRI;
        this._description = string;
        this._type = string2;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue().toString());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(this.getDescription());
        stringBuffer.append(" ");
        stringBuffer.append(this.getType());
        stringBuffer.append("] ");
        stringBuffer.append(this.getValue().toString());
        return stringBuffer;
    }

    @Override
    public PhylogenyData copy() {
        return new Uri(this.getValue().toString(), new String(this.getDescription()), new String(this.getType()));
    }

    public String getDescription() {
        return this._description;
    }

    public String getType() {
        return this._type;
    }

    public URI getValue() {
        return this._uri;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        PhylogenyDataUtil.appendElement(writer, "uri", this.getValue().toString(), "type", this.getType(), "desc", this.getDescription(), string);
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

