/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BranchData;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.ExternalForwardIterator;
import org.forester.phylogeny.iterators.LevelOrderTreeIterator;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PostorderTreeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.FailedConditionCheckException;

public class Phylogeny {
    public static final boolean ALLOW_MULTIPLE_PARENTS_DEFAULT = false;
    private PhylogenyNode _root;
    private boolean _rooted;
    private boolean _allow_multiple_parents;
    private String _name;
    private String _type;
    private String _description;
    private String _distance_unit;
    private Confidence _confidence;
    private Identifier _identifier;
    private boolean _rerootable;
    private HashMap<Long, PhylogenyNode> _id_to_node_map;
    private List<PhylogenyNode> _external_nodes_set;
    private Collection<Sequence> _sequenceRelationQueries;
    private Collection<SequenceRelation.SEQUENCE_RELATION_TYPE> _relevant_sequence_relation_types;

    public Phylogeny() {
        this.init();
    }

    public void addAsChild(PhylogenyNode phylogenyNode) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Attempt to add an empty tree.");
        }
        if (!this.isRooted()) {
            throw new IllegalArgumentException("Attempt to add an unrooted tree.");
        }
        phylogenyNode.addAsChild(this.getRoot());
        this.externalNodesHaveChanged();
    }

    public void addAsSibling(PhylogenyNode phylogenyNode) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Attempt to add an empty tree.");
        }
        if (!this.isRooted()) {
            throw new IllegalArgumentException("Attempt to add an unrooted tree.");
        }
        int n = phylogenyNode.getChildNodeIndex();
        PhylogenyNode phylogenyNode2 = new PhylogenyNode();
        PhylogenyNode phylogenyNode3 = phylogenyNode.getParent();
        phylogenyNode2.setChild1(phylogenyNode);
        phylogenyNode2.setChild2(this.getRoot());
        phylogenyNode2.setParent(phylogenyNode3);
        phylogenyNode.setParent(phylogenyNode2);
        phylogenyNode3.setChildNode(n, phylogenyNode2);
        double d = phylogenyNode.getDistanceToParent() == -1024.0 ? -1024.0 : phylogenyNode.getDistanceToParent() / 2.0;
        phylogenyNode2.setDistanceToParent(d);
        phylogenyNode.setDistanceToParent(d);
        this.externalNodesHaveChanged();
    }

    public double calculateSubtreeHeight(PhylogenyNode phylogenyNode, boolean bl) {
        if (phylogenyNode.isExternal() || bl && phylogenyNode.isCollapse()) {
            return phylogenyNode.getDistanceToParent() > 0.0 ? phylogenyNode.getDistanceToParent() : 0.0;
        }
        double d = 0.0;
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        Iterator<PhylogenyNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            PhylogenyNode phylogenyNode2;
            double d2 = 0.0;
            for (phylogenyNode2 = iterator.next(); phylogenyNode2 != phylogenyNode; phylogenyNode2 = phylogenyNode2.getParent()) {
                if (bl && phylogenyNode2.isCollapse()) {
                    d2 = 0.0;
                }
                d2 += phylogenyNode2.getDistanceToParent() > 0.0 ? phylogenyNode2.getDistanceToParent() : 0.0;
            }
            double d3 = phylogenyNode2.getDistanceToParent() > 0.0 ? phylogenyNode2.getDistanceToParent() : 0.0;
            if (!((d2 += d3) > d)) continue;
            d = d2;
        }
        return d;
    }

    public void clearHashIdToNodeMap() {
        this.setIdToNodeMap(null);
    }

    public Phylogeny copy() {
        return this.copy(this._root);
    }

    public Phylogeny copy(PhylogenyNode phylogenyNode) {
        Phylogeny phylogeny = new Phylogeny();
        if (this.isEmpty()) {
            phylogeny.init();
            return phylogeny;
        }
        phylogeny._rooted = this._rooted;
        phylogeny._name = new String(this._name);
        phylogeny._description = new String(this._description);
        phylogeny._type = new String(this._type);
        phylogeny._rerootable = this._rerootable;
        phylogeny._distance_unit = new String(this._distance_unit);
        if (this._confidence != null) {
            phylogeny._confidence = (Confidence)this._confidence.copy();
        }
        if (this._identifier != null) {
            phylogeny._identifier = (Identifier)this._identifier.copy();
        }
        phylogeny.setAllowMultipleParents(this.isAllowMultipleParents());
        phylogeny._root = PhylogenyMethods.copySubTree(phylogenyNode);
        return phylogeny;
    }

    public Phylogeny copyShallow() {
        return this.copyShallow(this._root);
    }

    public Phylogeny copyShallow(PhylogenyNode phylogenyNode) {
        Phylogeny phylogeny = new Phylogeny();
        if (this.isEmpty()) {
            phylogeny.init();
            return phylogeny;
        }
        phylogeny._rooted = this._rooted;
        phylogeny._name = this._name;
        phylogeny._description = this._description;
        phylogeny._type = this._type;
        phylogeny._rerootable = this._rerootable;
        phylogeny._distance_unit = this._distance_unit;
        phylogeny._confidence = this._confidence;
        phylogeny._identifier = this._identifier;
        phylogeny.setAllowMultipleParents(this.isAllowMultipleParents());
        phylogeny._root = PhylogenyMethods.copySubTreeShallow(phylogenyNode);
        return phylogeny;
    }

    public void deleteSubtree(PhylogenyNode phylogenyNode, boolean bl) {
        if (this.isEmpty() || phylogenyNode.isRoot() && this.getNumberOfExternalNodes() != 1) {
            return;
        }
        if (phylogenyNode.isRoot() && this.getNumberOfExternalNodes() == 1) {
            this.init();
        } else if (!bl) {
            phylogenyNode.getParent().removeChildNode(phylogenyNode);
        } else {
            PhylogenyNode phylogenyNode2 = phylogenyNode;
            PhylogenyNode phylogenyNode3 = phylogenyNode.getParent();
            if (phylogenyNode3.isRoot()) {
                if (phylogenyNode3.getNumberOfDescendants() == 2) {
                    if (phylogenyNode2.isFirstChildNode()) {
                        this.setRoot(this.getRoot().getChildNode(1));
                        this.getRoot().setParent(null);
                    } else {
                        this.setRoot(this.getRoot().getChildNode(0));
                        this.getRoot().setParent(null);
                    }
                } else {
                    phylogenyNode3.removeChildNode(phylogenyNode2.getChildNodeIndex());
                }
            } else {
                PhylogenyNode phylogenyNode4 = phylogenyNode2.getParent().getParent();
                if (phylogenyNode3.getNumberOfDescendants() == 2) {
                    int n = phylogenyNode3.getChildNodeIndex();
                    if (phylogenyNode2.isFirstChildNode()) {
                        phylogenyNode3.getChildNode(1).setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(phylogenyNode3.getDistanceToParent(), phylogenyNode3.getChildNode(1).getDistanceToParent()));
                        phylogenyNode4.setChildNode(n, phylogenyNode3.getChildNode(1));
                    } else {
                        phylogenyNode3.getChildNode(0).setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(phylogenyNode3.getDistanceToParent(), phylogenyNode3.getChildNode(0).getDistanceToParent()));
                        phylogenyNode4.setChildNode(n, phylogenyNode3.getChildNode(0));
                    }
                } else {
                    phylogenyNode3.removeChildNode(phylogenyNode2.getChildNodeIndex());
                }
            }
        }
        phylogenyNode.removeConnections();
        this.externalNodesHaveChanged();
    }

    public void externalNodesHaveChanged() {
        this._external_nodes_set = null;
    }

    public String[] getAllExternalNodeNames() {
        int n = 0;
        if (this.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[this.getNumberOfExternalNodes()];
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            stringArray[n++] = new String(phylogenyNodeIterator.next().getName());
        }
        return stringArray;
    }

    public Confidence getConfidence() {
        return this._confidence;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDistanceUnit() {
        return this._distance_unit;
    }

    public static final Phylogeny createInstanceFromNhxString(String string) throws IOException {
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        return phylogenyFactory.create(string, new NHXParser())[0];
    }

    public List<PhylogenyNode> getExternalNodes() {
        if (this._external_nodes_set == null) {
            this._external_nodes_set = new ArrayList<PhylogenyNode>();
            PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPostorder();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                if (!phylogenyNode.isExternal()) continue;
                this._external_nodes_set.add(phylogenyNode);
            }
        }
        return this._external_nodes_set;
    }

    public PhylogenyNode getFirstExternalNode() {
        if (this.isEmpty()) {
            throw new FailedConditionCheckException("attempt to obtain first external node of empty phylogeney");
        }
        PhylogenyNode phylogenyNode = this.getRoot();
        while (phylogenyNode.isInternal()) {
            phylogenyNode = phylogenyNode.getFirstChildNode();
        }
        return phylogenyNode;
    }

    public double calculateHeight(boolean bl) {
        if (this.isEmpty()) {
            return 0.0;
        }
        return this.calculateSubtreeHeight(this.getRoot(), bl);
    }

    public Identifier getIdentifier() {
        return this._identifier;
    }

    public String getName() {
        return this._name;
    }

    public PhylogenyNode getNode(long l) throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException("attempt to get node in an empty phylogeny");
        }
        if (this.getIdToNodeMap() == null || this.getIdToNodeMap().isEmpty()) {
            this.reHashIdToNodeMap();
        }
        return this.getIdToNodeMap().get(l);
    }

    public PhylogenyNode getNode(String string) {
        if (this.isEmpty()) {
            return null;
        }
        List<PhylogenyNode> list = this.getNodes(string);
        if (list == null || list.size() < 1) {
            throw new IllegalArgumentException("node named \"" + string + "\" not found");
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("node named \"" + string + "\" not unique");
        }
        return list.get(0);
    }

    public int getNodeCount() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            ++n;
            phylogenyNodeIterator.next();
        }
        return n;
    }

    public List<PhylogenyNode> getNodes(String string) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getName().equals(string)) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public List<PhylogenyNode> getNodes(Pattern pattern) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            Matcher matcher;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getName() == null || !(matcher = pattern.matcher(phylogenyNode.getName())).find()) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public List<PhylogenyNode> getNodesViaSequenceName(String string) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasSequence() || !phylogenyNode.getNodeData().getSequence().getName().equals(string)) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public List<PhylogenyNode> getNodesViaSequenceSymbol(String string) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasSequence() || !phylogenyNode.getNodeData().getSequence().getSymbol().equals(string)) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public List<PhylogenyNode> getNodesViaGeneName(String string) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasSequence() || !phylogenyNode.getNodeData().getSequence().getGeneName().equals(string)) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public List<PhylogenyNode> getNodesViaTaxonomyCode(String string) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || !phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode().equals(string)) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public List<PhylogenyNode> getNodesViaScientificName(String string) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || !phylogenyNode.getNodeData().getTaxonomy().getScientificName().equals(string)) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public List<PhylogenyNode> getNodesWithMatchingSpecies(String string) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!PhylogenyMethods.getSpecies(phylogenyNode).equals(string)) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public PhylogenyNode getNodeViaSequenceName(String string) {
        if (this.isEmpty()) {
            return null;
        }
        List<PhylogenyNode> list = this.getNodesViaSequenceName(string);
        if (list == null || list.size() < 1) {
            throw new IllegalArgumentException("node with sequence named [" + string + "] not found");
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("node with sequence named [" + string + "] not unique");
        }
        return list.get(0);
    }

    public PhylogenyNode getNodeViaTaxonomyCode(String string) {
        if (this.isEmpty()) {
            return null;
        }
        List<PhylogenyNode> list = this.getNodesViaTaxonomyCode(string);
        if (list == null || list.size() < 1) {
            throw new IllegalArgumentException("node with taxonomy code \"" + string + "\" not found");
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("node with taxonomy code \"" + string + "\" not unique");
        }
        return list.get(0);
    }

    public int getNumberOfBranches() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            ++n;
            phylogenyNodeIterator.next();
        }
        if (!this.isRooted()) {
            --n;
        }
        return n;
    }

    public int getNumberOfInternalNodes() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!phylogenyNodeIterator.next().isInternal()) continue;
            ++n;
        }
        if (!this.isRooted()) {
            --n;
        }
        return n;
    }

    public int getNumberOfExternalNodes() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.getExternalNodes().size();
    }

    public List<PhylogenyNode> getParalogousNodes(PhylogenyNode phylogenyNode, String[] stringArray) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        PhylogenyNode phylogenyNode3 = null;
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        HashMap<PhylogenyNode, List<String>> hashMap = new HashMap<PhylogenyNode, List<String>>();
        this.getTaxonomyMap(this.getRoot(), hashMap);
        if (!phylogenyNode2.isExternal() || this.isEmpty()) {
            return null;
        }
        String string = PhylogenyMethods.getTaxonomyIdentifier(phylogenyNode);
        if (!phylogenyNode2.isExternal() || this.isEmpty()) {
            return null;
        }
        List list = null;
        List<String> list2 = Arrays.asList(stringArray);
        while (!phylogenyNode2.isRoot()) {
            phylogenyNode3 = phylogenyNode2;
            phylogenyNode2 = phylogenyNode2.getParent();
            list = (List)hashMap.get(phylogenyNode2);
            if (!phylogenyNode2.isDuplication() || !this.isContains(list, list2)) continue;
            if (phylogenyNode2.getChildNode1() == phylogenyNode3) {
                arrayList.addAll(this.getNodeByTaxonomyID(string, phylogenyNode2.getChildNode2().getAllExternalDescendants()));
                continue;
            }
            arrayList.addAll(this.getNodeByTaxonomyID(string, phylogenyNode2.getChildNode1().getAllExternalDescendants()));
        }
        return arrayList;
    }

    public Collection<SequenceRelation.SEQUENCE_RELATION_TYPE> getRelevantSequenceRelationTypes() {
        if (this._relevant_sequence_relation_types == null) {
            this._relevant_sequence_relation_types = new Vector<SequenceRelation.SEQUENCE_RELATION_TYPE>();
        }
        return this._relevant_sequence_relation_types;
    }

    public PhylogenyNode getRoot() {
        return this._root;
    }

    public Collection<Sequence> getSequenceRelationQueries() {
        return this._sequenceRelationQueries;
    }

    public String getType() {
        return this._type;
    }

    public void init() {
        this._root = null;
        this._rooted = false;
        this._name = "";
        this._description = "";
        this._type = "";
        this._distance_unit = "";
        this._id_to_node_map = null;
        this._confidence = null;
        this._identifier = null;
        this._rerootable = true;
        this.setAllowMultipleParents(false);
    }

    public boolean isCompletelyBinary() {
        if (this.isEmpty()) {
            return false;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isInternal() || phylogenyNode.getNumberOfDescendants() == 2) continue;
            return false;
        }
        return true;
    }

    public boolean isCompletelyBinaryAllow3ChildrenAtRoot() {
        if (this.isEmpty()) {
            return false;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!(phylogenyNode.isRoot() ? phylogenyNode.isInternal() && phylogenyNode.getNumberOfDescendants() != 2 && phylogenyNode.getNumberOfDescendants() != 3 : phylogenyNode.isInternal() && phylogenyNode.getNumberOfDescendants() != 2)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.getRoot() == null;
    }

    public boolean isRerootable() {
        return this._rerootable;
    }

    public boolean isRooted() {
        return this._rooted;
    }

    public boolean isTree() {
        return true;
    }

    public PhylogenyNodeIterator iteratorExternalForward() {
        return new ExternalForwardIterator(this);
    }

    public PhylogenyNodeIterator iteratorLevelOrder() {
        return new LevelOrderTreeIterator(this);
    }

    public PhylogenyNodeIterator iteratorPostorder() {
        return new PostorderTreeIterator(this);
    }

    public PhylogenyNodeIterator iteratorPreorder() {
        return new PreorderTreeIterator(this);
    }

    public void levelOrderReID() {
        if (this.isEmpty()) {
            return;
        }
        this._id_to_node_map = null;
        long l = 0L;
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isRoot()) {
                phylogenyNode.setId(PhylogenyNode.getNodeCount());
                continue;
            }
            phylogenyNode.setId(phylogenyNode.getParent().getId() + 1L);
            if (phylogenyNode.getId() <= l) continue;
            l = phylogenyNode.getId();
        }
        PhylogenyNode.setNodeCount(l + 1L);
    }

    public void printExtNodes() {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            System.out.println(phylogenyNodeIterator.next() + "\n");
        }
    }

    public void recalculateNumberOfExternalDescendants(boolean bl) {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || bl && phylogenyNode.isCollapse()) {
                phylogenyNode.setSumExtNodes(1);
                continue;
            }
            int n = 0;
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                n += phylogenyNode.getChildNode(i).getNumberOfExternalNodes();
            }
            phylogenyNode.setSumExtNodes(n);
        }
    }

    public void reRoot(long l) {
        this.reRoot(this.getNode(l));
    }

    public void reRoot(PhylogenyNode phylogenyNode) {
        this.reRoot(phylogenyNode, -1.0);
    }

    public void reRoot(PhylogenyNode phylogenyNode, double d) {
        if (this.isEmpty() || this.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setRooted(true);
        if (phylogenyNode.isRoot()) {
            return;
        }
        if (phylogenyNode.getParent().isRoot()) {
            if (phylogenyNode.getParent().getNumberOfDescendants() == 2 && d >= 0.0) {
                double d2 = phylogenyNode.getParent().getChildNode1().getDistanceToParent() + phylogenyNode.getParent().getChildNode2().getDistanceToParent();
                PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNodeIndex() == 0 ? phylogenyNode.getParent().getChildNode2() : phylogenyNode.getParent().getChildNode1();
                phylogenyNode.setDistanceToParent(d);
                double d3 = d2 - d;
                if (d3 >= 0.0) {
                    phylogenyNode2.setDistanceToParent(d3);
                } else {
                    phylogenyNode2.setDistanceToParent(0.0);
                }
            }
            if (phylogenyNode.getParent().getNumberOfDescendants() > 2) {
                int n = phylogenyNode.getChildNodeIndex();
                double d4 = phylogenyNode.getDistanceToParent();
                PhylogenyNode phylogenyNode3 = this.getRoot();
                phylogenyNode3.getDescendants().remove(n);
                PhylogenyNode phylogenyNode4 = new PhylogenyNode();
                phylogenyNode4.setChildNode(0, phylogenyNode);
                phylogenyNode4.setChildNode(1, phylogenyNode3);
                if (phylogenyNode.getBranchDataDirectly() != null) {
                    phylogenyNode3.setBranchData((BranchData)phylogenyNode.getBranchDataDirectly().copy());
                }
                this.setRoot(phylogenyNode4);
                if (d >= 0.0) {
                    phylogenyNode.setDistanceToParent(d);
                    double d5 = d4 - d;
                    if (d5 >= 0.0) {
                        phylogenyNode3.setDistanceToParent(d5);
                    } else {
                        phylogenyNode3.setDistanceToParent(0.0);
                    }
                } else if (d4 >= 0.0) {
                    double d6 = d4 / 2.0;
                    phylogenyNode.setDistanceToParent(d6);
                    phylogenyNode3.setDistanceToParent(d6);
                }
            }
        } else {
            double d7;
            PhylogenyNode phylogenyNode5 = phylogenyNode;
            PhylogenyNode phylogenyNode6 = null;
            PhylogenyNode phylogenyNode7 = null;
            PhylogenyNode phylogenyNode8 = new PhylogenyNode();
            double d8 = 0.0;
            double d9 = 0.0;
            BranchData branchData = null;
            BranchData branchData2 = null;
            phylogenyNode6 = phylogenyNode5.getParent();
            phylogenyNode7 = phylogenyNode6.getParent();
            phylogenyNode8.setChildNode(0, phylogenyNode5);
            phylogenyNode8.setChildNode(1, phylogenyNode6);
            d8 = phylogenyNode7.getDistanceToParent();
            if (phylogenyNode7.getBranchDataDirectly() != null) {
                branchData = (BranchData)phylogenyNode7.getBranchDataDirectly().copy();
            }
            phylogenyNode7.setDistanceToParent(phylogenyNode6.getDistanceToParent());
            if (phylogenyNode6.getBranchDataDirectly() != null) {
                phylogenyNode7.setBranchData((BranchData)phylogenyNode6.getBranchDataDirectly().copy());
            }
            if (phylogenyNode5.getBranchDataDirectly() != null) {
                phylogenyNode6.setBranchData((BranchData)phylogenyNode5.getBranchDataDirectly().copy());
            }
            if (phylogenyNode5.getDistanceToParent() == -1024.0) {
                phylogenyNode6.setDistanceToParent(-1024.0);
            } else if (d >= 0.0) {
                d7 = phylogenyNode5.getDistanceToParent() - d;
                phylogenyNode5.setDistanceToParent(d);
                phylogenyNode6.setDistanceToParent(d7 >= 0.0 ? d7 : 0.0);
            } else {
                d7 = phylogenyNode5.getDistanceToParent() / 2.0;
                phylogenyNode5.setDistanceToParent(d7);
                phylogenyNode6.setDistanceToParent(d7);
            }
            phylogenyNode6.setChildNodeOnly(phylogenyNode5.getChildNodeIndex(phylogenyNode6), phylogenyNode7);
            while (!phylogenyNode7.isRoot()) {
                phylogenyNode5 = phylogenyNode6;
                phylogenyNode6 = phylogenyNode7;
                phylogenyNode7 = phylogenyNode7.getParent();
                phylogenyNode6.setChildNodeOnly(phylogenyNode5.getChildNodeIndex(phylogenyNode6), phylogenyNode7);
                phylogenyNode6.setParent(phylogenyNode5);
                d9 = phylogenyNode7.getDistanceToParent();
                branchData2 = phylogenyNode7.getBranchDataDirectly();
                phylogenyNode7.setDistanceToParent(d8);
                phylogenyNode7.setBranchData(branchData);
                d8 = d9;
                branchData = branchData2;
            }
            if (phylogenyNode7.getNumberOfDescendants() == 2) {
                PhylogenyNode phylogenyNode9 = phylogenyNode7.getChildNode(1 - phylogenyNode6.getChildNodeIndex(phylogenyNode7));
                phylogenyNode9.setParent(phylogenyNode6);
                if (phylogenyNode7.getDistanceToParent() == -1024.0 && phylogenyNode9.getDistanceToParent() == -1024.0) {
                    phylogenyNode9.setDistanceToParent(-1024.0);
                } else {
                    phylogenyNode9.setDistanceToParent((phylogenyNode7.getDistanceToParent() >= 0.0 ? phylogenyNode7.getDistanceToParent() : 0.0) + (phylogenyNode9.getDistanceToParent() >= 0.0 ? phylogenyNode9.getDistanceToParent() : 0.0));
                }
                if (phylogenyNode7.getBranchDataDirectly() != null) {
                    phylogenyNode9.setBranchData((BranchData)phylogenyNode7.getBranchDataDirectly().copy());
                }
                for (int i = 0; i < phylogenyNode6.getNumberOfDescendants(); ++i) {
                    if (phylogenyNode6.getChildNode(i) != phylogenyNode7) continue;
                    phylogenyNode6.setChildNodeOnly(i, phylogenyNode9);
                    break;
                }
            } else {
                phylogenyNode7.setParent(phylogenyNode6);
                phylogenyNode7.removeChildNode(phylogenyNode6.getChildNodeIndex(phylogenyNode7));
            }
            this.setRoot(phylogenyNode8);
        }
    }

    public void setAllNodesToNotCollapse() {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            phylogenyNode.setCollapse(false);
        }
    }

    public void setConfidence(Confidence confidence) {
        this._confidence = confidence;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public void setDistanceUnit(String string) {
        this._distance_unit = string;
    }

    public void setIdentifier(Identifier identifier) {
        this._identifier = identifier;
    }

    public void setIdToNodeMap(HashMap<Long, PhylogenyNode> hashMap) {
        this._id_to_node_map = hashMap;
    }

    public void setIndicatorsToZero() {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNodeIterator.next().setIndicator((byte)0);
        }
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setRelevantSequenceRelationTypes(Collection<SequenceRelation.SEQUENCE_RELATION_TYPE> collection) {
        this._relevant_sequence_relation_types = collection;
    }

    public void setRerootable(boolean bl) {
        this._rerootable = bl;
    }

    public void setRoot(PhylogenyNode phylogenyNode) {
        this._root = phylogenyNode;
    }

    public void setRooted(boolean bl) {
        this._rooted = bl;
    }

    public void setSequenceRelationQueries(Collection<Sequence> collection) {
        this._sequenceRelationQueries = collection;
    }

    public void setType(String string) {
        this._type = string;
    }

    public String toNewHampshire() {
        return this.toNewHampshire(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE);
    }

    public String toNewHampshire(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) {
        try {
            return new PhylogenyWriter().toNewHampshire(this, true, nH_CONVERSION_SUPPORT_VALUE_STYLE).toString();
        }
        catch (IOException iOException) {
            throw new Error("this should not have happend: " + iOException.getMessage());
        }
    }

    public String toNewHampshireX() {
        try {
            return new PhylogenyWriter().toNewHampshireX(this).toString();
        }
        catch (IOException iOException) {
            throw new Error("this should not have happend: " + iOException.getMessage());
        }
    }

    public String toNexus() {
        return this.toNexus(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE);
    }

    public String toNexus(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) {
        try {
            return new PhylogenyWriter().toNexus(this, nH_CONVERSION_SUPPORT_VALUE_STYLE).toString();
        }
        catch (IOException iOException) {
            throw new Error("this should not have happend: " + iOException.getMessage());
        }
    }

    public String toPhyloXML(int n) {
        try {
            return new PhylogenyWriter().toPhyloXML(this, n).toString();
        }
        catch (IOException iOException) {
            throw new Error("this should not have happend: " + iOException.getMessage());
        }
    }

    public String toString() {
        return this.toNewHampshireX();
    }

    public void unRoot() throws RuntimeException {
        if (!this.isTree()) {
            throw new FailedConditionCheckException("Attempt to unroot a phylogeny which is not tree-like.");
        }
        if (this.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        if (!this.isRooted() || this.getNumberOfExternalNodes() <= 1) {
            return;
        }
        this.setRooted(false);
    }

    private HashMap<Long, PhylogenyNode> getIdToNodeMap() {
        return this._id_to_node_map;
    }

    private List<PhylogenyNode> getNodeByTaxonomyID(String string, List<PhylogenyNode> list) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        for (PhylogenyNode phylogenyNode : list) {
            if (!string.equals(PhylogenyMethods.getTaxonomyIdentifier(phylogenyNode))) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    private List<String> getSubNodeTaxonomy(PhylogenyNode phylogenyNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        String string = null;
        for (PhylogenyNode phylogenyNode2 : list) {
            string = PhylogenyMethods.getTaxonomyIdentifier(phylogenyNode2);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private void getTaxonomyMap(PhylogenyNode phylogenyNode, Map<PhylogenyNode, List<String>> map) {
        if (phylogenyNode.isExternal()) {
            return;
        }
        map.put(phylogenyNode, this.getSubNodeTaxonomy(phylogenyNode));
        this.getTaxonomyMap(phylogenyNode.getChildNode1(), map);
        this.getTaxonomyMap(phylogenyNode.getChildNode2(), map);
    }

    private boolean isAllowMultipleParents() {
        return this._allow_multiple_parents;
    }

    private boolean isContains(List<String> list, List<String> list2) {
        if (list.size() > list2.size()) {
            return false;
        }
        String string2 = null;
        for (String string2 : list) {
            if (list2.contains(string2)) continue;
            return false;
        }
        return true;
    }

    private void reHashIdToNodeMap() {
        if (this.isEmpty()) {
            return;
        }
        this.setIdToNodeMap(new HashMap<Long, PhylogenyNode>());
        PhylogenyNodeIterator phylogenyNodeIterator = this.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            this.getIdToNodeMap().put(phylogenyNode.getId(), phylogenyNode);
        }
    }

    private void setAllowMultipleParents(boolean bl) {
        this._allow_multiple_parents = bl;
    }
}

