/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.GeneralMsaParser;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class rid {
    private static final String PRG_NAME = "rid";
    private static final String PRG_DATE = "170902";
    private static final String PRG_DESC = "sequence file reformatting and identifier normalization";
    private static final String PRG_VERSION = "1.00";
    private static final String WWW = "https://sites.google.com/site/cmzmasek/home/software/forester";
    private static final String E_MAIL = "phyloxml@gmail.com";
    private static final String OUTPUT_FORMAT_OPTION = "o";
    private static final String ID_NORM_OPTION = "s";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String OUTPUT_FORMAT_FASTA = "f";
    private static final String OUTPUT_FORMAT_PHYLIP = "p";
    private static final String OUTPUT_FORMAT_NEXUS = "n";
    private static final String OUTPUT_FORMAT_FASTA_L = "fasta";
    private static final String OUTPUT_FORMAT_PHYLIP_L = "phylip";
    private static final String OUTPUT_FORMAT_NEXUS_L = "nexus";

    public static void main(String[] stringArray) {
        try {
            String string;
            Object object;
            File file;
            boolean bl;
            File file2;
            String string2;
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
            CommandLineArguments commandLineArguments = null;
            try {
                commandLineArguments = new CommandLineArguments(stringArray);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
            if (commandLineArguments.getNumberOfNames() == 0 || commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
                System.out.println();
                rid.print_help();
                System.exit(0);
            }
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (commandLineArguments.getNumberOfNames() == 2 || commandLineArguments.getNumberOfNames() == 3) {
                string3 = commandLineArguments.getName(0);
                string4 = commandLineArguments.getName(1);
                if (commandLineArguments.getNumberOfNames() == 3) {
                    string5 = commandLineArguments.getName(2);
                }
            } else if (commandLineArguments.getNumberOfNames() == 1) {
                string3 = commandLineArguments.getName(0);
                string6 = null;
                string6 = string3.toLowerCase().endsWith(".fasta") ? string3.substring(0, string3.length() - 6) : (string3.toLowerCase().endsWith(".fsa") ? string3.substring(0, string3.length() - 4) : (string3.toLowerCase().endsWith(".phy") ? string3.substring(0, string3.length() - 4) : (string3.toLowerCase().endsWith(".aln") ? string3.substring(0, string3.length() - 4) : (string3.toLowerCase().endsWith(".phylip") ? string3.substring(0, string3.length() - 7) : (string3.toLowerCase().endsWith(".nex") ? string3.substring(0, string3.length() - 4) : (string3.toLowerCase().endsWith(".nexus") ? string3.substring(0, string3.length() - 5) : string3))))));
                string5 = string6 + ".nim";
            } else {
                rid.print_help();
                System.exit(-1);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(OUTPUT_FORMAT_OPTION);
            arrayList.add(ID_NORM_OPTION);
            String string7 = commandLineArguments.validateAllowedOptionsAsString(arrayList);
            if (string7.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string7);
            }
            if (!ForesterUtil.isEmpty(string2 = ForesterUtil.isReadableFile(file2 = new File(string3)))) {
                ForesterUtil.fatalError(PRG_NAME, string2);
            }
            boolean bl2 = ForesterUtil.isLooksLikeFasta(file2);
            Msa.MSA_FORMAT mSA_FORMAT = Msa.MSA_FORMAT.FASTA;
            if (commandLineArguments.isOptionSet(OUTPUT_FORMAT_OPTION)) {
                if (commandLineArguments.isOptionValueSet(OUTPUT_FORMAT_OPTION)) {
                    String string8 = commandLineArguments.getOptionValue(OUTPUT_FORMAT_OPTION);
                    if (string8.equals(OUTPUT_FORMAT_FASTA) || string8.equalsIgnoreCase(OUTPUT_FORMAT_FASTA_L)) {
                        mSA_FORMAT = Msa.MSA_FORMAT.FASTA;
                    } else if (string8.equals(OUTPUT_FORMAT_PHYLIP) || string8.equalsIgnoreCase(OUTPUT_FORMAT_PHYLIP_L)) {
                        mSA_FORMAT = Msa.MSA_FORMAT.PHYLIP;
                    } else if (string8.equals(OUTPUT_FORMAT_NEXUS) || string8.equalsIgnoreCase(OUTPUT_FORMAT_NEXUS_L)) {
                        mSA_FORMAT = Msa.MSA_FORMAT.NEXUS;
                    } else {
                        ForesterUtil.fatalError(PRG_NAME, "unknown output format option: " + string8);
                    }
                } else {
                    ForesterUtil.fatalError(PRG_NAME, "no value for output format option");
                }
            }
            if ((bl = commandLineArguments.isOptionSet(ID_NORM_OPTION) || commandLineArguments.getNumberOfNames() == 3) && ForesterUtil.isEmpty(string5)) {
                ForesterUtil.fatalError(PRG_NAME, "need to indicate name for output map file");
            }
            if (bl) {
                file = new File(string5);
                object = ForesterUtil.isWritableFile(file);
                if (!ForesterUtil.isEmpty((String)object)) {
                    ForesterUtil.fatalError(PRG_NAME, (String)object);
                }
            } else {
                file = null;
            }
            if (commandLineArguments.getNumberOfNames() == 1) {
                if (bl) {
                    if (mSA_FORMAT == Msa.MSA_FORMAT.FASTA) {
                        string4 = string6 + "_ni.fasta";
                    } else if (mSA_FORMAT == Msa.MSA_FORMAT.NEXUS) {
                        string4 = string6 + "_ni.nexus";
                    } else if (mSA_FORMAT == Msa.MSA_FORMAT.PHYLIP) {
                        string4 = string6 + "_ni.phylip";
                    }
                } else if (mSA_FORMAT == Msa.MSA_FORMAT.FASTA) {
                    string4 = string6 + ".fasta";
                    if (ForesterUtil.isWritableFile(string4) != null) {
                        string4 = string6 + "_" + ".fasta";
                    }
                } else if (mSA_FORMAT == Msa.MSA_FORMAT.NEXUS) {
                    string4 = string6 + ".nexus";
                    if (ForesterUtil.isWritableFile(string4) != null) {
                        string4 = string6 + "_" + ".nexus";
                    }
                } else if (mSA_FORMAT == Msa.MSA_FORMAT.PHYLIP && ForesterUtil.isWritableFile(string4 = string6 + ".phylip") != null) {
                    string4 = string6 + "_" + ".phylip";
                }
            }
            if (!ForesterUtil.isEmpty(string = ForesterUtil.isWritableFile((File)(object = new File(string4))))) {
                ForesterUtil.fatalError(PRG_NAME, string);
            }
            System.out.println();
            if (bl2) {
                System.out.println("Input format          : Fasta");
            } else {
                System.out.println("Input format          : Phylip like");
            }
            System.out.println("Input file            : " + string3);
            if (mSA_FORMAT == Msa.MSA_FORMAT.FASTA) {
                System.out.println("Output format         : Fasta");
            } else if (mSA_FORMAT == Msa.MSA_FORMAT.NEXUS) {
                System.out.println("Output format         : Nexus");
            } else if (mSA_FORMAT == Msa.MSA_FORMAT.PHYLIP) {
                System.out.println("Output format         : Phylip");
            }
            System.out.println("Output file           : " + string4);
            System.out.println("Shorten names         : " + bl);
            if (bl) {
                System.out.println("Identifier map        : " + string5);
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            List<MolecularSequence> list = FastaParser.isLikelyFasta(file2) ? FastaParser.parse(fileInputStream) : GeneralMsaParser.parseSeqs(fileInputStream);
            if (list == null) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read input sequences");
            }
            if (list.size() < 1) {
                ForesterUtil.fatalError(PRG_NAME, "input seems to be devoid of sequences");
            }
            BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
            for (MolecularSequence molecularSequence : list) {
                basicDescriptiveStatistics.addValue(molecularSequence.getLength());
            }
            System.out.println("Number of sequences   : " + list.size());
            if (!ForesterUtil.isEqual(basicDescriptiveStatistics.getMin(), basicDescriptiveStatistics.getMax())) {
                System.out.println("Sequence lenght min   : " + (int)basicDescriptiveStatistics.getMin());
                System.out.println("Sequence lenght max   : " + (int)basicDescriptiveStatistics.getMax());
                if (list.size() > 2) {
                    System.out.println("Sequence length median: " + (int)basicDescriptiveStatistics.median());
                }
                if (mSA_FORMAT == Msa.MSA_FORMAT.NEXUS || mSA_FORMAT == Msa.MSA_FORMAT.PHYLIP) {
                    ForesterUtil.fatalError(PRG_NAME, "Input is not an alignment, cannot write in Nexus or Phylip format");
                }
            } else {
                System.out.println("Alignment length      : " + (int)basicDescriptiveStatistics.getMax());
            }
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            BufferedWriter bufferedWriter = bl ? ForesterUtil.createBufferedWriter(string5) : null;
            for (MolecularSequence object2 : list) {
                String string8 = bl ? rid.modify_name(object2.getIdentifier(), n++, bufferedWriter) : object2.getIdentifier();
                MolecularSequence molecularSequence = BasicSequence.createGeneralSequence(string8, object2.getMolecularSequenceAsString());
                arrayList2.add(molecularSequence);
            }
            System.out.println();
            if (bl) {
                bufferedWriter.flush();
                bufferedWriter.close();
                System.out.println("Wrote                 : " + file);
            }
            BufferedWriter bufferedWriter2 = ForesterUtil.createBufferedWriter((File)object);
            if (mSA_FORMAT == Msa.MSA_FORMAT.NEXUS || mSA_FORMAT == Msa.MSA_FORMAT.PHYLIP) {
                Msa msa = BasicMsa.createInstance(arrayList2);
                msa.write(bufferedWriter2, mSA_FORMAT);
            } else if (mSA_FORMAT == Msa.MSA_FORMAT.FASTA) {
                SequenceWriter.writeSeqs((List<MolecularSequence>)arrayList2, bufferedWriter2, SequenceWriter.SEQ_FORMAT.FASTA, 60);
            }
            bufferedWriter2.flush();
            bufferedWriter2.close();
            System.out.println("Wrote                 : " + object);
            System.out.println();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ForesterUtil.fatalError(PRG_NAME, illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ForesterUtil.fatalError(PRG_NAME, "Unexpected errror!");
        }
    }

    static final String modify_name(String string, int n, Writer writer) throws IOException {
        string.replaceAll("\\s+", " ");
        String string2 = Integer.toHexString(n);
        if (string2.length() > 9) {
            ForesterUtil.fatalError(PRG_NAME, "shortened identifier [" + string2 + "] is too long (" + string2.length() + " characters)");
        }
        writer.write(string2 + "\t" + string + "\n");
        return string2;
    }

    private static final void print_help() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("rid [options] <input sequences file> [output sequences file] [output map file]");
        System.out.println();
        System.out.println(" options:");
        System.out.println("  -o=<format>: output format: fasta or f for Fasta (default), phylip or p for Phylip, nexus or n for Nexus");
        System.out.println("  -s         : to replace sequence names with short(er) identifiers");
        System.out.println();
        System.out.println("Example:");
        System.out.println();
        System.out.println(" rid -s -o=p my_seqs.fasta");
        System.out.println();
    }
}

