/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.render.AbstractRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class Title
extends AbstractRenderer {
    protected String text = "Chart Title";
    protected Font font = new Font("Helvetica", 0, 22);

    public Title() {
    }

    public Title(String text) {
        this.setText(text);
    }

    public Title(String text, Font font) {
        this.setText(text);
        this.setFont(font);
    }

    public void setText(String text) {
        this.text = text;
        super.fireRenderChangeEvent();
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font f) {
        this.font = f;
        super.fireRenderChangeEvent();
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void paintDefault(Graphics2D g) {
        g.setColor(Color.black);
        TextLayout layout = new TextLayout(this.getText(), this.getFont(), new FontRenderContext(null, true, false));
        layout.draw(g, 0.0f, (float)this.getPreferredSize().getHeight() - layout.getDescent());
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle2D titleBounds = this.getFont().getStringBounds(this.getText(), new FontRenderContext(null, true, false));
        return new Dimension((int)titleBounds.getWidth(), (int)titleBounds.getHeight());
    }
}

