/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FACS_objects;

import FCSalyzer.FACS_objects.FACS_panel;
import FCSalyzer.GUI.FACS_document;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JTextArea;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.staticMethods;

public class FACS_comment
extends FACS_panel
implements FocusListener {
    private final JTextArea textArea = new JTextArea();
    private boolean isDragged = false;
    private final int border = 5;
    public static final String XML_NAME = "FACS_comment";
    private static final String XML_TEXT = "Text";

    private FACS_comment() {
    }

    public FACS_comment(FACS_document paramDoc) {
        this.setFCS_Document(paramDoc);
        this.textArea.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.textArea.addMouseListener(this);
        this.textArea.addMouseMotionListener(this);
        this.setOpaque(false);
        this.textArea.setOpaque(false);
        this.textArea.setFont(this.getFont());
        this.textArea.setForeground(Color.black);
        this.textArea.setEditable(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.setLayout(new BorderLayout());
        this.add(Box.createHorizontalStrut(5), "East");
        this.add(Box.createHorizontalStrut(5), "West");
        this.add(Box.createVerticalStrut(5), "North");
        this.add(Box.createVerticalStrut(5), "South");
        this.add(this.textArea);
        this.textArea.requestFocusInWindow();
    }

    public static synchronized FACS_comment loadComment(FACS_document paramDoc, Node storedData) throws NumberFormatException {
        FACS_comment newComment = new FACS_comment(paramDoc);
        NodeList nL = storedData.getChildNodes();
        for (int i = 0; i < nL.getLength(); ++i) {
            Integer zo;
            NodeList nL_temp;
            Node current = nL.item(i);
            String nameCurrent = current.getNodeName();
            if (nameCurrent.equals("Bounds")) {
                nL_temp = current.getChildNodes();
                double x = 0.0;
                double y = 0.0;
                double width = 0.0;
                double height = 0.0;
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    Node curr2 = nL_temp.item(j);
                    String curr2Name = curr2.getNodeName();
                    if (curr2Name.equals("X")) {
                        x = staticMethods.getNodeDouble(curr2, x);
                        continue;
                    }
                    if (curr2Name.equals("Y")) {
                        y = staticMethods.getNodeDouble(curr2, y);
                        continue;
                    }
                    if (curr2Name.equals("Width")) {
                        width = staticMethods.getNodeDouble(curr2, width);
                        continue;
                    }
                    if (!curr2Name.equals("Height")) continue;
                    height = staticMethods.getNodeDouble(curr2, height);
                }
                newComment.setBounds((int)x, (int)y, (int)width, (int)height);
                continue;
            }
            if (nameCurrent.equals("Font")) {
                nL_temp = current.getChildNodes();
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    Node curr2 = nL_temp.item(j);
                    String curr2Name = curr2.getNodeName();
                    Float fonts = null;
                    if (!curr2Name.equals("Size") || (fonts = staticMethods.getNodeFloat(curr2, fonts)) == null) continue;
                    newComment.setFontSize(fonts);
                }
                continue;
            }
            if (nameCurrent.equals(XML_TEXT)) {
                newComment.textArea.setText(staticMethods.getNodeText(current));
                continue;
            }
            if (!nameCurrent.equals("ZOrder") || (zo = staticMethods.getNodeInteger(current, null)) == null) continue;
            newComment.rememberZOrder(zo);
        }
        return newComment;
    }

    public void toXML(Node parent) {
        Node com = staticMethods.addNode(parent, XML_NAME, null);
        Node bounds = staticMethods.addNode(com, "Bounds", null);
        Rectangle r = this.getBounds();
        staticMethods.addNode(bounds, "X", r.getX());
        staticMethods.addNode(bounds, "Y", r.getY());
        staticMethods.addNode(bounds, "Width", r.getWidth());
        staticMethods.addNode(bounds, "Height", r.getHeight());
        staticMethods.addNode(com, "ZOrder", this.theDocument.getComponentZOrder(this));
        Node font = staticMethods.addNode(com, "Font", null);
        staticMethods.addNode(font, "Size", this.getFont().getSize());
        staticMethods.addNode(com, XML_TEXT, this.textArea.getText());
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.textArea.setEditable(false);
        this.setBounds(this.getX(), this.getY(), this.getPreferredSize().width, this.getPreferredSize().height);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.textArea.setEditable(false);
        this.isDragged = true;
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseMoved(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseReleased(e);
        if (!this.isDragged && e.getSource() == this.textArea) {
            this.textArea.setEditable(true);
            this.textArea.getCaret().setVisible(true);
        } else {
            this.textArea.setEditable(false);
            this.textArea.getCaret().setVisible(false);
            this.grabFocus();
        }
        this.isDragged = false;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String newText) {
        this.textArea.setText(newText);
    }

    @Override
    public FACS_panel duplicate() {
        FACS_comment returnComment = new FACS_comment(this.getFCS_Document());
        returnComment.setBounds(this.getBounds());
        returnComment.setFontSize(this.getFontSize());
        returnComment.setText(this.getText());
        return returnComment;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.textArea.setBounds(5, 5, this.getBounds().width - 5, this.getBounds().height - 5);
    }

    @Override
    public void setFontSize(Float newSize) {
        super.setFontSize(newSize);
        this.textArea.setFont(this.getFont());
    }

    @Override
    public void delete() {
        this.theDocument = null;
    }

    @Override
    public void removeListeners() {
        this.textArea.removeFocusListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.textArea.removeMouseListener(this);
        this.textArea.removeMouseMotionListener(this);
    }

    public String[] getTextLines() {
        FontMetrics fm = this.textArea.getFontMetrics(this.textArea.getFont());
        int maxWidth = this.textArea.getWidth() - this.textArea.getMargin().left - this.textArea.getMargin().right - this.textArea.getInsets().left - this.textArea.getInsets().right;
        int tabExpand = this.textArea.getTabSize();
        String tab = "";
        for (int i = 0; i < tabExpand; ++i) {
            tab = tab + " ";
        }
        String text = this.textArea.getText();
        text = text.replaceAll("\t", tab);
        text = text.replaceAll(System.getProperty("line.separator"), "\n");
        StringBuilder temp = new StringBuilder(text);
        int start = 0;
        while (start < temp.length()) {
            if (fm.stringWidth(temp.substring(start)) < maxWidth) {
                start = temp.length();
                continue;
            }
            int end = start + 1;
            int space = -1;
            boolean endLine = false;
            boolean stillShort = true;
            while (stillShort && !endLine) {
                String current = temp.substring(start, end);
                if (!current.endsWith(" ")) {
                    current = current + " ";
                }
                if (fm.stringWidth(current) >= maxWidth) {
                    stillShort = false;
                    --end;
                    continue;
                }
                if (temp.charAt(end) == '\n') {
                    endLine = true;
                }
                if (temp.charAt(end) == ' ') {
                    space = end;
                }
                if (++end <= temp.length()) continue;
                endLine = true;
            }
            if (endLine) {
                start = end;
                continue;
            }
            if (space != -1) {
                boolean noSpace = false;
                while (fm.stringWidth(temp.substring(start, space) + " ") < maxWidth && !noSpace) {
                    if (temp.charAt(space + 1) == ' ') {
                        ++space;
                        continue;
                    }
                    noSpace = true;
                }
                temp.setCharAt(space, '\n');
                start = space;
                continue;
            }
            temp.insert(end, '\n');
            start = end;
        }
        return temp.toString().split("\n");
    }

    public Rectangle getTextAreaBounds() {
        return this.textArea.getBounds();
    }
}

