/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.chunker;

import java.io.File;
import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.chunker.ChunkerModelLoader;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.PlainTextByLineStream;

public class ChunkerMETool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learnable chunker";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    @Override
    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
        } else {
            ChunkerModel model = (ChunkerModel)new ChunkerModelLoader().load(new File(args[0]));
            ChunkerME chunker = new ChunkerME(model);
            PlainTextByLineStream lineStream = null;
            PerformanceMonitor perfMon = null;
            try {
                String line;
                lineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());
                perfMon = new PerformanceMonitor(System.err, "sent");
                perfMon.start();
                while ((line = (String)lineStream.read()) != null) {
                    POSSample posSample;
                    try {
                        posSample = POSSample.parse(line);
                    }
                    catch (InvalidFormatException e) {
                        System.err.println("Invalid format:");
                        System.err.println(line);
                        continue;
                    }
                    String[] chunks = chunker.chunk(posSample.getSentence(), posSample.getTags());
                    System.out.println(new ChunkSample(posSample.getSentence(), posSample.getTags(), chunks).nicePrint());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

