/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import org.encog.persist.EncogPersistor;
import org.encog.persist.PersistError;
import org.encog.persist.PersistorRegistry;
import org.encog.util.file.ResourceInputStream;
import org.encog.util.logging.EncogLogging;

public class EncogDirectoryPersistence {
    private final File parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadResourceObject(String res) {
        InputStream is = null;
        try {
            is = ResourceInputStream.openResourceInputStream(res);
            Object object = EncogDirectoryPersistence.loadObject(is);
            return object;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Object loadObject(File file) {
        FileInputStream fis = null;
        try {
            Object result;
            fis = new FileInputStream(file);
            Object object = result = EncogDirectoryPersistence.loadObject(fis);
            return object;
        }
        catch (IOException ex) {
            throw new PersistError(ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
            }
        }
    }

    public static Object loadObject(InputStream is) {
        String header = EncogDirectoryPersistence.readLine(is);
        String[] params = header.split(",");
        if (!"encog".equals(params[0])) {
            throw new PersistError("Not a valid EG file.");
        }
        String name = params[1];
        EncogPersistor p = PersistorRegistry.getInstance().getPersistor(name);
        if (p == null) {
            throw new PersistError("Do not know how to read the object: " + name);
        }
        if (p.getFileVersion() < Integer.parseInt(params[4])) {
            throw new PersistError("The file you are trying to read is from a later version of Encog.  Please upgrade Encog to read this file.");
        }
        return p.read(is);
    }

    private static String readLine(InputStream is) {
        try {
            char ch;
            StringBuilder result = new StringBuilder();
            do {
                int b;
                if ((b = is.read()) == -1) {
                    return result.toString();
                }
                ch = (char)b;
                if (ch == '\r' || ch == '\n') continue;
                result.append(ch);
            } while (ch != '\n');
            return result.toString();
        }
        catch (IOException ex) {
            throw new PersistError(ex);
        }
    }

    public static void saveObject(File filename, Object obj) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            EncogDirectoryPersistence.saveObject(fos, obj);
        }
        catch (IOException ex) {
            throw new PersistError(ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                EncogLogging.log(e);
            }
        }
    }

    public static void saveObject(OutputStream os, Object obj) {
        try {
            EncogPersistor p = PersistorRegistry.getInstance().getPersistor(obj.getClass());
            if (p == null) {
                throw new PersistError("Do not know how to persist object: " + obj.getClass().getSimpleName());
            }
            os.flush();
            PrintWriter pw = new PrintWriter(os);
            Date now = new Date();
            pw.println("encog," + obj.getClass().getSimpleName() + ",java," + "3.2.0" + "," + p.getFileVersion() + "," + now.getTime());
            pw.flush();
            p.save(os, obj);
        }
        catch (IOException ex) {
            throw new PersistError(ex);
        }
    }

    public EncogDirectoryPersistence(File parent) {
        this.parent = parent;
    }

    public String getEncogType(String name) {
        BufferedReader br = null;
        try {
            File path = new File(this.parent, name);
            br = new BufferedReader(new FileReader(path));
            String header = br.readLine();
            if (header == null) {
                throw new PersistError("Invalid file, can't find header");
            }
            String[] params = header.split(",");
            String string = params[1];
            return string;
        }
        catch (IOException ex) {
            throw new PersistError(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
            }
        }
    }

    public final File getParent() {
        return this.parent;
    }

    public final Object loadFromDirectory(String name) {
        File path = new File(this.parent, name);
        return EncogDirectoryPersistence.loadObject(path);
    }

    public final void saveToDirectory(String name, Object obj) {
        File path = new File(this.parent, name);
        EncogDirectoryPersistence.saveObject(path, obj);
    }
}

