/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import com.jgoodies.looks.HeaderStyle;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.specialfields.SpecialFieldValue;

public class SpecialFieldDropDown {
    public static JButton generateSpecialFieldButtonWithDropDown(SpecialField field, JabRefFrame frame) {
        Dimension buttonDim = new Dimension(23, 23);
        JButton button = new JButton(field.getRepresentingIcon());
        button.setToolTipText(field.getToolTip());
        button.setPreferredSize(buttonDim);
        if (!Globals.ON_MAC) {
            button.setMargin(new Insets(1, 0, 2, 0));
        }
        button.setBorder(null);
        button.setBorderPainted(false);
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        button.setBounds(0, 0, buttonDim.width, buttonDim.height);
        button.setSize(buttonDim);
        button.setMinimumSize(buttonDim);
        button.setMaximumSize(buttonDim);
        button.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        button.addActionListener(new MenuButtonActionListener(field, frame, button, buttonDim));
        return button;
    }

    private static class MenuButtonActionListener
    implements ActionListener {
        private JPopupMenu popup;
        private Dimension dim;
        private JabRefFrame frame;
        private SpecialField field;
        private JButton button;

        public MenuButtonActionListener(SpecialField field, JabRefFrame frame, JButton button, Dimension dim) {
            this.field = field;
            this.dim = dim;
            this.frame = frame;
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.popup == null) {
                this.popup = new JPopupMenu();
                for (SpecialFieldValue val : this.field.getValues()) {
                    JMenuItem item = new JMenuItem(val.getIcon());
                    item.setText(val.getMenuString());
                    item.setToolTipText(val.getToolTipText());
                    item.addActionListener(new PopupitemActionListener(this.frame.basePanel(), val.getActionName()));
                    item.setMargin(new Insets(0, 0, 0, 0));
                    this.popup.add(item);
                }
            }
            this.popup.show(this.button, 0, this.dim.height);
        }

        private class PopupitemActionListener
        implements ActionListener {
            private BasePanel panel;
            private String actionName;

            public PopupitemActionListener(BasePanel panel, String actionName) {
                this.panel = panel;
                this.actionName = actionName;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.panel.runCommand(this.actionName);
                MenuButtonActionListener.this.popup.setVisible(false);
            }
        }
    }
}

