/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRule;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.UnsupportedVersionException;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.QuotedStringTokenizer;

public class KeywordGroup
extends AbstractGroup
implements SearchRule {
    public static final String ID = "KeywordGroup:";
    private final String m_searchField;
    private final String m_searchExpression;
    private final boolean m_caseSensitive;
    private final boolean m_regExp;
    private Pattern m_pattern = null;

    public KeywordGroup(String name, String searchField, String searchExpression, boolean caseSensitive, boolean regExp, int context) throws IllegalArgumentException, PatternSyntaxException {
        super(name, context);
        this.m_searchField = searchField;
        this.m_searchExpression = searchExpression;
        this.m_caseSensitive = caseSensitive;
        this.m_regExp = regExp;
        if (this.m_regExp) {
            this.compilePattern();
        }
    }

    protected void compilePattern() throws IllegalArgumentException, PatternSyntaxException {
        this.m_pattern = this.m_caseSensitive ? Pattern.compile("\\b" + this.m_searchExpression + "\\b") : Pattern.compile("\\b" + this.m_searchExpression + "\\b", 2);
    }

    public static AbstractGroup fromString(String s, BibtexDatabase db, int version) throws Exception {
        if (!s.startsWith(ID)) {
            throw new Exception("Internal error: KeywordGroup cannot be created from \"" + s + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(s.substring(ID.length()), ";", '\\');
        switch (version) {
            case 0: {
                String name = tok.nextToken();
                String field = tok.nextToken();
                String expression = tok.nextToken();
                return new KeywordGroup(Util.unquote(name, '\\'), Util.unquote(field, '\\'), Util.unquote(expression, '\\'), false, true, 0);
            }
            case 1: 
            case 2: {
                String name = tok.nextToken();
                String field = tok.nextToken();
                String expression = tok.nextToken();
                boolean caseSensitive = Integer.parseInt(tok.nextToken()) == 1;
                boolean regExp = Integer.parseInt(tok.nextToken()) == 1;
                return new KeywordGroup(Util.unquote(name, '\\'), Util.unquote(field, '\\'), Util.unquote(expression, '\\'), caseSensitive, regExp, 0);
            }
            case 3: {
                String name = tok.nextToken();
                int context = Integer.parseInt(tok.nextToken());
                String field = tok.nextToken();
                String expression = tok.nextToken();
                boolean caseSensitive = Integer.parseInt(tok.nextToken()) == 1;
                boolean regExp = Integer.parseInt(tok.nextToken()) == 1;
                return new KeywordGroup(Util.unquote(name, '\\'), Util.unquote(field, '\\'), Util.unquote(expression, '\\'), caseSensitive, regExp, context);
            }
        }
        throw new UnsupportedVersionException("KeywordGroup", version);
    }

    @Override
    public SearchRule getSearchRule() {
        return this;
    }

    public String toString() {
        return ID + Util.quote(this.m_name, ";", '\\') + ";" + this.m_context + ";" + Util.quote(this.m_searchField, ";", '\\') + ";" + Util.quote(this.m_searchExpression, ";", '\\') + ";" + (this.m_caseSensitive ? "1" : "0") + ";" + (this.m_regExp ? "1" : "0") + ";";
    }

    @Override
    public boolean supportsAdd() {
        return !this.m_regExp;
    }

    @Override
    public boolean supportsRemove() {
        return !this.m_regExp;
    }

    @Override
    public AbstractUndoableEdit add(BibtexEntry[] entries) {
        if (!this.supportsAdd()) {
            return null;
        }
        if (entries != null && entries.length > 0) {
            NamedCompound ce = new NamedCompound(Globals.lang("add entries to group"));
            boolean modified = false;
            for (int i = 0; i < entries.length; ++i) {
                if (this.applyRule(null, entries[i]) != 0) continue;
                String oldContent = entries[i].getField(this.m_searchField);
                String pre = Globals.prefs.get("groupKeywordSeparator");
                String newContent = (oldContent == null ? "" : oldContent + pre) + this.m_searchExpression;
                entries[i].setField(this.m_searchField, newContent);
                ce.addEdit(new UndoableFieldChange(entries[i], this.m_searchField, oldContent, newContent));
                modified = true;
            }
            if (modified) {
                ce.end();
            }
            return modified ? ce : null;
        }
        return null;
    }

    @Override
    public AbstractUndoableEdit remove(BibtexEntry[] entries) {
        if (!this.supportsRemove()) {
            return null;
        }
        if (entries != null && entries.length > 0) {
            NamedCompound ce = new NamedCompound(Globals.lang("remove from group"));
            boolean modified = false;
            for (int i = 0; i < entries.length; ++i) {
                if (this.applyRule(null, entries[i]) <= 0) continue;
                String oldContent = entries[i].getField(this.m_searchField);
                this.removeMatches(entries[i]);
                ce.addEdit(new UndoableFieldChange(entries[i], this.m_searchField, oldContent, entries[i].getField(this.m_searchField)));
                modified = true;
            }
            if (modified) {
                ce.end();
            }
            return modified ? ce : null;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof KeywordGroup)) {
            return false;
        }
        KeywordGroup other = (KeywordGroup)o;
        return this.m_name.equals(other.m_name) && this.m_searchField.equals(other.m_searchField) && this.m_searchExpression.equals(other.m_searchExpression) && this.m_caseSensitive == other.m_caseSensitive && this.m_regExp == other.m_regExp && this.getHierarchicalContext() == other.getHierarchicalContext();
    }

    @Override
    public boolean contains(Map<String, String> searchOptions, BibtexEntry entry) {
        return this.contains(entry);
    }

    @Override
    public boolean contains(BibtexEntry entry) {
        String content = entry.getField(this.m_searchField);
        if (content == null) {
            return false;
        }
        if (this.m_regExp) {
            return this.m_pattern.matcher(content).find();
        }
        if (this.m_caseSensitive) {
            return KeywordGroup.containsWord(this.m_searchExpression, content);
        }
        return KeywordGroup.containsWord(this.m_searchExpression.toLowerCase(), content.toLowerCase());
    }

    private static boolean containsWord(String word, String text) {
        int piv = 0;
        while (piv < text.length()) {
            int ind = text.indexOf(word, piv);
            if (ind < 0) {
                return false;
            }
            if (!(ind != 0 && Character.isLetterOrDigit(text.charAt(ind - 1)) || ind + word.length() != text.length() && Character.isLetterOrDigit(text.charAt(ind + word.length())))) {
                return true;
            }
            piv = ind + 1;
        }
        return false;
    }

    private void removeMatches(BibtexEntry entry) {
        int i;
        String content = entry.getField(this.m_searchField);
        if (content == null) {
            return;
        }
        StringBuffer sbOrig = new StringBuffer(content);
        StringBuffer sbLower = new StringBuffer(content.toLowerCase());
        StringBuffer haystack = this.m_caseSensitive ? sbOrig : sbLower;
        String needle = this.m_caseSensitive ? this.m_searchExpression : this.m_searchExpression.toLowerCase();
        String separator = Globals.prefs.get("groupKeywordSeparator");
        while ((i = haystack.indexOf(needle)) >= 0) {
            sbOrig.replace(i, i + needle.length(), "");
            sbLower.replace(i, i + needle.length(), "");
            int j = i;
            int k = i;
            while (j - 1 >= 0 && separator.indexOf(haystack.charAt(j - 1)) >= 0) {
                --j;
            }
            while (k < haystack.length() && separator.indexOf(haystack.charAt(k)) >= 0) {
                ++k;
            }
            sbOrig.replace(j, k, j >= 0 && k < sbOrig.length() ? separator : "");
            sbLower.replace(j, k, j >= 0 && k < sbOrig.length() ? separator : "");
        }
        String result = sbOrig.toString().trim();
        entry.setField(this.m_searchField, result.length() > 0 ? result : null);
    }

    @Override
    public int applyRule(Map<String, String> searchOptions, BibtexEntry entry) {
        return this.contains(searchOptions, entry) ? 1 : 0;
    }

    @Override
    public boolean validateSearchStrings(Map<String, String> searchStrings) {
        return true;
    }

    @Override
    public AbstractGroup deepCopy() {
        try {
            return new KeywordGroup(this.m_name, this.m_searchField, this.m_searchExpression, this.m_caseSensitive, this.m_regExp, this.m_context);
        }
        catch (Throwable t) {
            System.err.println("Internal error: Exception " + t + " in KeywordGroup.deepCopy(). " + "Please report this on www.sf.net/projects/jabref");
            return null;
        }
    }

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public boolean isRegExp() {
        return this.m_regExp;
    }

    public String getSearchExpression() {
        return this.m_searchExpression;
    }

    public String getSearchField() {
        return this.m_searchField;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getDescription() {
        return KeywordGroup.getDescriptionForPreview(this.m_searchField, this.m_searchExpression, this.m_caseSensitive, this.m_regExp);
    }

    public static String getDescriptionForPreview(String field, String expr, boolean caseSensitive, boolean regExp) {
        StringBuffer sb = new StringBuffer();
        sb.append(regExp ? Globals.lang("This group contains entries whose <b>%0</b> field contains the regular expression <b>%1</b>", field, Util.quoteForHTML(expr)) : Globals.lang("This group contains entries whose <b>%0</b> field contains the keyword <b>%1</b>", field, Util.quoteForHTML(expr)));
        sb.append(" (").append(caseSensitive ? Globals.lang("case sensitive") : Globals.lang("case insensitive")).append("). ");
        sb.append(regExp ? Globals.lang("Entries cannot be manually assigned to or removed from this group.") : Globals.lang("Additionally, entries whose <b>%0</b> field does not contain <b>%1</b> can be assigned manually to this group by selecting them then using either drag and drop or the context menu. This process adds the term <b>%1</b> to each entry's <b>%0</b> field. Entries can be removed manually from this group by selecting them then using the context menu. This process removes the term <b>%1</b> from each entry's <b>%0</b> field.", field, Util.quoteForHTML(expr)));
        return sb.toString();
    }

    @Override
    public String getShortDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("<b>");
        if (Globals.prefs.getBoolean("groupShowDynamic")) {
            sb.append("<i>").append(Util.quoteForHTML(this.getName())).append("</i>");
        } else {
            sb.append(Util.quoteForHTML(this.getName()));
        }
        sb.append("</b> - ");
        sb.append(Globals.lang("dynamic group"));
        sb.append("<b>");
        sb.append(this.m_searchField);
        sb.append("</b>");
        sb.append(Globals.lang("contains"));
        sb.append(" <b>");
        sb.append(Util.quoteForHTML(this.m_searchExpression));
        sb.append("</b>)");
        switch (this.getHierarchicalContext()) {
            case 2: {
                sb.append(", ").append(Globals.lang("includes subgroups"));
                break;
            }
            case 1: {
                sb.append(", ").append(Globals.lang("refines supergroup"));
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public String getTypeId() {
        return ID;
    }
}

