/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.jabref.GUIGlobals;

public class ExternalFileType
implements Comparable<ExternalFileType> {
    protected String name;
    protected String extension;
    protected String openWith;
    protected String iconName;
    protected String mimeType;
    protected ImageIcon icon;
    protected JLabel label = new JLabel();

    public ExternalFileType(String name, String extension, String mimeType, String openWith, String iconName) {
        this.label.setText(null);
        this.name = name;
        this.label.setToolTipText(this.name);
        this.extension = extension;
        this.mimeType = mimeType;
        this.openWith = openWith;
        this.setIconName(iconName);
    }

    public ExternalFileType(String[] val) {
        if (val == null || val.length < 4) {
            throw new IllegalArgumentException("Cannot contruct ExternalFileType without four elements in String[] argument.");
        }
        this.name = val[0];
        this.label.setToolTipText(this.name);
        this.extension = val[1];
        this.label.setText(null);
        if (val.length == 4) {
            this.openWith = val[2];
            this.setIconName(val[3]);
        } else if (val.length == 5) {
            this.mimeType = val[2];
            this.openWith = val[3];
            this.setIconName(val[4]);
        }
    }

    public String[] getStringArrayRepresentation() {
        return new String[]{this.name, this.extension, this.mimeType, this.openWith, this.iconName};
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.label.setToolTipText(this.name);
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getFieldName() {
        return this.extension;
    }

    public String getOpenWith() {
        return this.openWith;
    }

    public void setOpenWith(String openWith) {
        this.openWith = openWith;
    }

    public void setIconName(String name) {
        this.iconName = name;
        try {
            this.icon = GUIGlobals.getImage(this.iconName);
        }
        catch (NullPointerException ex) {
            this.icon = null;
        }
        this.label.setIcon(this.icon);
    }

    public JLabel getIconLabel() {
        return this.label;
    }

    public String getIconName() {
        return this.iconName;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(ExternalFileType o) {
        return this.getName().compareTo(o.getName());
    }

    public ExternalFileType copy() {
        return new ExternalFileType(this.name, this.extension, this.mimeType, this.openWith, this.iconName);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        ExternalFileType other = (ExternalFileType)object;
        if (other == null) {
            return false;
        }
        return (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.extension == null ? other.extension == null : this.extension.equals(other.extension)) && (this.mimeType == null ? other.mimeType == null : this.mimeType.equals(other.mimeType)) && (this.openWith == null ? other.openWith == null : this.openWith.equals(other.openWith)) && (this.iconName == null ? other.iconName == null : this.iconName.equals(other.iconName));
    }
}

