/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.NameFormatterTab;
import net.sf.jabref.Util;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.export.layout.ParamLayoutFormatter;
import net.sf.jabref.export.layout.StringInt;
import net.sf.jabref.export.layout.WSITools;
import net.sf.jabref.export.layout.format.NotFoundFormatter;
import net.sf.jabref.export.layout.format.plugin.NameFormat;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;

public class LayoutEntry {
    private LayoutFormatter[] option;
    private LayoutFormatter postFormatter = null;
    private String text;
    private LayoutEntry[] layoutEntries;
    private int type;
    private String classPrefix;
    private ArrayList<String> invalidFormatter = null;
    static Map<String, LayoutFormatter> pluginLayoutFormatter;

    public LayoutEntry(StringInt si, String classPrefix_) throws Exception {
        this.type = si.i;
        this.classPrefix = classPrefix_;
        if (si.i == 1) {
            this.text = si.s;
        } else if (si.i == 2) {
            this.text = si.s.trim();
        } else if (si.i != 3 && si.i != 4 && si.i == 5) {
            Vector<String> v = new Vector<String>();
            WSITools.tokenize(v, si.s, "\n");
            if (v.size() == 1) {
                this.text = v.get(0);
            } else {
                this.text = v.get(0).trim();
                this.option = LayoutEntry.getOptionalLayout(v.get(1), this.classPrefix);
                for (int i = 0; i < this.option.length; ++i) {
                    if (!(this.option[i] instanceof NotFoundFormatter)) continue;
                    String notFound = ((NotFoundFormatter)this.option[i]).getNotFound();
                    if (this.invalidFormatter == null) {
                        this.invalidFormatter = new ArrayList();
                    }
                    this.invalidFormatter.add(notFound);
                }
            }
        }
    }

    public LayoutEntry(Vector<StringInt> parsedEntries, String classPrefix_, int layoutType) throws Exception {
        int i;
        this.classPrefix = classPrefix_;
        String blockStart = null;
        String blockEnd = null;
        Vector<StringInt> blockEntries = null;
        Vector<LayoutEntry> tmpEntries = new Vector<LayoutEntry>();
        StringInt si = parsedEntries.get(0);
        blockStart = si.s;
        si = parsedEntries.get(parsedEntries.size() - 1);
        blockEnd = si.s;
        if (!blockStart.equals(blockEnd)) {
            System.err.println("Field start and end entry must be equal.");
        }
        this.type = layoutType;
        this.text = si.s;
        for (i = 1; i < parsedEntries.size() - 1; ++i) {
            si = parsedEntries.get(i);
            if (si.i != 1 && si.i != 2) {
                if (si.i == 3 || si.i == 6) {
                    blockEntries = new Vector<StringInt>();
                    blockStart = si.s;
                } else if (si.i == 4 || si.i == 7) {
                    if (blockStart.equals(si.s)) {
                        blockEntries.add(si);
                        LayoutEntry le = si.i == 7 ? new LayoutEntry(blockEntries, this.classPrefix, 6) : new LayoutEntry(blockEntries, this.classPrefix, 3);
                        tmpEntries.add(le);
                        blockEntries = null;
                    } else {
                        System.out.println("Nested field entries are not implemented !!!");
                    }
                } else if (si.i == 5) {
                    // empty if block
                }
            }
            if (blockEntries == null) {
                tmpEntries.add(new LayoutEntry(si, this.classPrefix));
                continue;
            }
            blockEntries.add(si);
        }
        this.layoutEntries = new LayoutEntry[tmpEntries.size()];
        for (i = 0; i < tmpEntries.size(); ++i) {
            this.layoutEntries[i] = (LayoutEntry)tmpEntries.get(i);
            if (!this.layoutEntries[i].isInvalidFormatter()) continue;
            if (this.invalidFormatter == null) {
                this.invalidFormatter = new ArrayList(1);
            }
            this.invalidFormatter.addAll(this.layoutEntries[i].getInvalidFormatters());
        }
    }

    public void setPostFormatter(LayoutFormatter formatter) {
        this.postFormatter = formatter;
    }

    public String doLayout(BibtexEntry bibtex, BibtexDatabase database) {
        return this.doLayout(bibtex, database, null);
    }

    public String doLayout(BibtexEntry bibtex, BibtexDatabase database, ArrayList<String> wordsToHighlight) {
        switch (this.type) {
            case 1: {
                return this.text;
            }
            case 2: {
                String value = BibtexDatabase.getResolvedField(this.text, bibtex, database);
                if (value == null) {
                    value = "";
                }
                if (this.postFormatter != null) {
                    value = this.postFormatter.format(value);
                }
                return value;
            }
            case 3: 
            case 6: {
                int i;
                String[] parts;
                String field;
                if (this.type == 6) {
                    field = BibtexDatabase.getResolvedField(this.text, bibtex, database);
                } else if (this.text.matches(".*(;|(\\&+)).*")) {
                    parts = this.text.split("\\s*(;|(\\&+))\\s*");
                    field = null;
                    for (i = 0; i < parts.length && (field = BibtexDatabase.getResolvedField(parts[i], bibtex, database)) != null; ++i) {
                    }
                } else {
                    parts = this.text.split("\\s*(\\|+)\\s*");
                    field = null;
                    for (i = 0; i < parts.length && (field = BibtexDatabase.getResolvedField(parts[i], bibtex, database)) == null; ++i) {
                    }
                }
                if (field == null || this.type == 6 && field.equalsIgnoreCase(LayoutHelper.getCurrentGroup())) {
                    return null;
                }
                if (this.type == 6) {
                    LayoutHelper.setCurrentGroup(field);
                }
                StringBuffer sb = new StringBuffer(100);
                boolean previousSkipped = false;
                for (int i2 = 0; i2 < this.layoutEntries.length; ++i2) {
                    String fieldText = this.layoutEntries[i2].doLayout(bibtex, database);
                    if (fieldText == null) {
                        if (i2 + 1 < this.layoutEntries.length && this.layoutEntries[i2 + 1].doLayout(bibtex, database).trim().length() == 0) {
                            ++i2;
                            previousSkipped = true;
                            continue;
                        }
                    } else if (previousSkipped) {
                        int eol;
                        for (eol = 0; eol < fieldText.length() && (fieldText.charAt(eol) == '\n' || fieldText.charAt(eol) == '\r'); ++eol) {
                        }
                        if (eol < fieldText.length()) {
                            sb.append(fieldText.substring(eol));
                        }
                    } else if (bibtex.isSearchHit()) {
                        sb.append(this.highlightWords(fieldText, wordsToHighlight));
                    } else {
                        sb.append(fieldText);
                    }
                    previousSkipped = false;
                }
                return sb.toString();
            }
            case 4: 
            case 7: {
                return "";
            }
            case 5: {
                String fieldEntry;
                if (this.text.equals("bibtextype")) {
                    fieldEntry = bibtex.getType().getName();
                } else {
                    String field = this.text.startsWith("\\") ? BibtexDatabase.getResolvedField(this.text.substring(1), bibtex, database) : BibtexDatabase.getText(this.text, database);
                    fieldEntry = field == null ? "" : field;
                }
                if (this.option != null) {
                    for (int i = 0; i < this.option.length; ++i) {
                        fieldEntry = this.option[i].format(fieldEntry);
                    }
                }
                if (this.postFormatter != null) {
                    fieldEntry = this.postFormatter.format(fieldEntry);
                }
                return fieldEntry;
            }
            case 8: {
                return BibtexDatabase.getResolvedField("encoding", bibtex, database);
            }
        }
        return "";
    }

    public String doLayout(BibtexDatabase database, String encoding) {
        if (this.type == 1) {
            return this.text;
        }
        if (this.type == 2) {
            throw new UnsupportedOperationException("bibtex entry fields not allowed in begin or end layout");
        }
        if (this.type == 3 || this.type == 6) {
            throw new UnsupportedOperationException("field and group starts not allowed in begin or end layout");
        }
        if (this.type == 4 || this.type == 7) {
            throw new UnsupportedOperationException("field and group ends not allowed in begin or end layout");
        }
        if (this.type == 5) {
            String field = BibtexDatabase.getText(this.text, database);
            if (this.option != null) {
                for (int i = 0; i < this.option.length; ++i) {
                    field = this.option[i].format(field);
                }
            }
            if (this.postFormatter != null) {
                field = this.postFormatter.format(field);
            }
            return field;
        }
        if (this.type == 8) {
            String commonName = Globals.ENCODING_NAMES_LOOKUP.get(encoding);
            return commonName != null ? commonName : encoding;
        }
        if (this.type == 9) {
            File f = Globals.prefs.databaseFile;
            return f != null ? f.getName() : "";
        }
        if (this.type == 10) {
            File f = Globals.prefs.databaseFile;
            return f != null ? f.getPath() : "";
        }
        return "";
    }

    public static LayoutFormatter getLayoutFormatterFromPlugins(String formatterName) {
        if (pluginLayoutFormatter == null) {
            pluginLayoutFormatter = new HashMap<String, LayoutFormatter>();
            JabRefPlugin plugin = JabRefPlugin.getInstance(PluginCore.getManager());
            if (plugin != null) {
                for (_JabRefPlugin.LayoutFormatterExtension e : plugin.getLayoutFormatterExtensions()) {
                    LayoutFormatter formatter = e.getLayoutFormatter();
                    String name = e.getName();
                    if (name == null) {
                        name = e.getId();
                    }
                    if (formatter == null) continue;
                    pluginLayoutFormatter.put(name, formatter);
                }
            }
        }
        if (pluginLayoutFormatter.containsKey(formatterName)) {
            Class<?> c = pluginLayoutFormatter.get(formatterName).getClass();
            try {
                return (LayoutFormatter)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return pluginLayoutFormatter.get(formatterName);
            }
        }
        return null;
    }

    public static LayoutFormatter getLayoutFormatterByClassName(String className, String classPrefix) throws Exception {
        if (className.length() > 0) {
            try {
                try {
                    return (LayoutFormatter)Class.forName(classPrefix + className).newInstance();
                }
                catch (Throwable ex2) {
                    return (LayoutFormatter)Class.forName(className).newInstance();
                }
            }
            catch (ClassNotFoundException ex) {
                throw new Exception(Globals.lang("Formatter not found") + ": " + className);
            }
            catch (InstantiationException ex) {
                throw new Exception(className + " can not be instantiated.");
            }
            catch (IllegalAccessException ex) {
                throw new Exception(className + " can't be accessed.");
            }
        }
        return null;
    }

    public static LayoutFormatter[] getOptionalLayout(String formatterName, String classPrefix) throws Exception {
        ArrayList<String[]> formatterStrings = Util.parseMethodsCalls(formatterName);
        ArrayList<LayoutFormatter> results = new ArrayList<LayoutFormatter>(formatterStrings.size());
        Map<String, String> userNameFormatter = NameFormatterTab.getNameFormatters();
        for (String[] strings : formatterStrings) {
            NameFormat nf;
            String contents;
            String className = strings[0].trim();
            if (Globals.prefs.customExportNameFormatters != null && (contents = Globals.prefs.customExportNameFormatters.get(className)) != null) {
                nf = new NameFormat();
                nf.setParameter(contents);
                results.add(nf);
                continue;
            }
            try {
                LayoutFormatter f = LayoutEntry.getLayoutFormatterByClassName(className, classPrefix);
                if (f instanceof ParamLayoutFormatter && strings.length >= 2) {
                    ((ParamLayoutFormatter)f).setArgument(strings[1]);
                }
                results.add(f);
            }
            catch (Exception e) {
                String formatterParameter = userNameFormatter.get(className);
                if (formatterParameter != null) {
                    nf = new NameFormat();
                    nf.setParameter(formatterParameter);
                    results.add(nf);
                    continue;
                }
                LayoutFormatter f = LayoutEntry.getLayoutFormatterFromPlugins(className);
                if (f != null) {
                    if (f instanceof ParamLayoutFormatter && strings.length >= 2) {
                        ((ParamLayoutFormatter)f).setArgument(strings[1]);
                    }
                    results.add(f);
                    continue;
                }
                results.add(new NotFoundFormatter(className));
            }
        }
        return results.toArray(new LayoutFormatter[0]);
    }

    public boolean isInvalidFormatter() {
        return this.invalidFormatter != null;
    }

    public ArrayList<String> getInvalidFormatters() {
        return this.invalidFormatter;
    }

    private String highlightWords(String text, ArrayList<String> toHighlight) {
        if (toHighlight == null) {
            return text;
        }
        Matcher matcher = Globals.getPatternForWords(toHighlight).matcher(text);
        if (Character.isLetterOrDigit(text.charAt(0))) {
            String hlColor = "#3399FF";
            StringBuffer sb = new StringBuffer();
            boolean foundSomething = false;
            while (matcher.find()) {
                matcher.end();
                String found = matcher.group();
                matcher.appendReplacement(sb, "<span style=\"background-color:" + hlColor + ";\">" + found + "</span>");
                foundSomething = true;
            }
            if (foundSomething) {
                matcher.appendTail(sb);
                text = sb.toString();
            }
        }
        return text;
    }
}

